/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.indatabase.db.object;

import com.rapidminer.extension.indatabase.provider.DatabaseProvider;
import java.io.Serializable;

public class Column
implements Serializable {
    private static final long serialVersionUID = -1432922056537896029L;
    private final String destCol;
    private final int type;
    public static final int UNKNOWN_TYPE = 0;

    public Column(String destCol) {
        this.destCol = destCol;
        this.type = 0;
    }

    public String toSql(DatabaseProvider provider) {
        return provider.quote(this.getDestCol());
    }

    protected Column(ColumnBuilder<?, ?> b) {
        this.destCol = b.destCol;
        this.type = b.type;
    }

    public static ColumnBuilder<?, ?> builder() {
        return new ColumnBuilderImpl();
    }

    public String getDestCol() {
        return this.destCol;
    }

    public int getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Column)) {
            return false;
        }
        Column other = (Column)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getType() != other.getType()) {
            return false;
        }
        String this$destCol = this.getDestCol();
        String other$destCol = other.getDestCol();
        return !(this$destCol == null ? other$destCol != null : !this$destCol.equals(other$destCol));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Column;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getType();
        String $destCol = this.getDestCol();
        result = result * 59 + ($destCol == null ? 43 : $destCol.hashCode());
        return result;
    }

    public String toString() {
        return "Column(destCol=" + this.getDestCol() + ", type=" + this.getType() + ")";
    }

    public Column(String destCol, int type) {
        this.destCol = destCol;
        this.type = type;
    }

    public static abstract class ColumnBuilder<C extends Column, B extends ColumnBuilder<C, B>> {
        private String destCol;
        private int type;

        public B destCol(String destCol) {
            this.destCol = destCol;
            return this.self();
        }

        public B type(int type) {
            this.type = type;
            return this.self();
        }

        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "Column.ColumnBuilder(destCol=" + this.destCol + ", type=" + this.type + ")";
        }
    }

    private static final class ColumnBuilderImpl
    extends ColumnBuilder<Column, ColumnBuilderImpl> {
        private ColumnBuilderImpl() {
        }

        @Override
        protected ColumnBuilderImpl self() {
            return this;
        }

        @Override
        public Column build() {
            return new Column(this);
        }
    }
}

