/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.indatabase.db.object;

import com.rapidminer.extension.indatabase.provider.DatabaseProvider;
import java.io.Serializable;

public final class Expression
implements Serializable {
    private static final long serialVersionUID = -4417340845464816995L;
    private final String expression;
    private final boolean replacingSquareBrackets;

    public Expression(String expr) {
        this(expr, true);
    }

    public Expression(String expr, boolean replacingSquareBrackets) {
        this.expression = expr;
        this.replacingSquareBrackets = replacingSquareBrackets;
    }

    public String toSql(DatabaseProvider provider) {
        if (this.replacingSquareBrackets) {
            return Expression.replaceBrackets(provider, this.expression);
        }
        return this.expression;
    }

    public static String replaceBrackets(DatabaseProvider provider, String expression) {
        return expression.replaceAll("\\[|\\]", provider.getEnclosingCharacter());
    }

    public String getExpression() {
        return this.expression;
    }

    public boolean isReplacingSquareBrackets() {
        return this.replacingSquareBrackets;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Expression)) {
            return false;
        }
        Expression other = (Expression)o;
        if (this.isReplacingSquareBrackets() != other.isReplacingSquareBrackets()) {
            return false;
        }
        String this$expression = this.getExpression();
        String other$expression = other.getExpression();
        return !(this$expression == null ? other$expression != null : !this$expression.equals(other$expression));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isReplacingSquareBrackets() ? 79 : 97);
        String $expression = this.getExpression();
        result = result * 59 + ($expression == null ? 43 : $expression.hashCode());
        return result;
    }

    public String toString() {
        return "Expression(expression=" + this.getExpression() + ", replacingSquareBrackets=" + this.isReplacingSquareBrackets() + ")";
    }
}

