/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.indatabase.db.object;

import com.rapidminer.extension.indatabase.db.object.Table;
import com.rapidminer.extension.indatabase.provider.DatabaseProvider;

public final class ForeignTable
extends Table {
    private static final long serialVersionUID = -12547043804580545L;
    private final String project;

    public ForeignTable(String project, String schema, String table) {
        super(schema, table);
        this.project = project;
    }

    @Override
    public String toString() {
        return this.project + "." + super.toString();
    }

    @Override
    public String toSql(DatabaseProvider provider) {
        return String.format("%s.%s", provider.quote(this.project), super.toSql(provider));
    }

    public String getProject() {
        return this.project;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ForeignTable)) {
            return false;
        }
        ForeignTable other = (ForeignTable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$project = this.getProject();
        String other$project = other.getProject();
        return !(this$project == null ? other$project != null : !this$project.equals(other$project));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ForeignTable;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $project = this.getProject();
        result = result * 59 + ($project == null ? 43 : $project.hashCode());
        return result;
    }
}

