/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.indatabase.db.object;

import com.rapidminer.extension.indatabase.db.object.Column;
import com.rapidminer.extension.indatabase.provider.DatabaseProvider;

public final class RenamedColumn
extends Column {
    private static final long serialVersionUID = -5022632235947088269L;
    private final String oldCol;

    private RenamedColumn(String oldCol, String destCol, int type) {
        super(destCol, type);
        this.oldCol = oldCol;
    }

    public static RenamedColumn rename(Column col, String destCol) {
        return new RenamedColumn(col.getDestCol(), destCol, col.getType());
    }

    @Override
    public String toSql(DatabaseProvider provider) {
        return String.format("%s %s", provider.quote(this.oldCol), super.toSql(provider));
    }

    public String getOldCol() {
        return this.oldCol;
    }

    @Override
    public String toString() {
        return "RenamedColumn(oldCol=" + this.getOldCol() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RenamedColumn)) {
            return false;
        }
        RenamedColumn other = (RenamedColumn)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$oldCol = this.getOldCol();
        String other$oldCol = other.getOldCol();
        return !(this$oldCol == null ? other$oldCol != null : !this$oldCol.equals(other$oldCol));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RenamedColumn;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $oldCol = this.getOldCol();
        result = result * 59 + ($oldCol == null ? 43 : $oldCol.hashCode());
        return result;
    }
}

