/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.indatabase.db.object;

import com.rapidminer.extension.indatabase.db.object.Column;
import com.rapidminer.extension.indatabase.provider.DatabaseProvider;

public final class SourceColumn
extends Column {
    private static final long serialVersionUID = -3677805497911504147L;
    private final String sourceTab;
    private final String sourceCol;
    private final boolean definesAlias;

    public SourceColumn(String tab, String col) {
        this(tab, col, 0);
    }

    public SourceColumn(String tab, String col, int type) {
        this(tab, col, col, type);
    }

    public SourceColumn(String tab, String col, String alias, int type) {
        super(alias, type);
        this.definesAlias = !col.equals(alias);
        this.sourceTab = tab;
        this.sourceCol = col;
    }

    @Override
    public String toSql(DatabaseProvider provider) {
        if (this.definesAlias) {
            return String.format("%s.%s %s", provider.quote(this.sourceTab), provider.quote(this.sourceCol), super.toSql(provider));
        }
        return String.format("%s.%s", provider.quote(this.sourceTab), provider.quote(this.sourceCol));
    }

    public String getSourceTab() {
        return this.sourceTab;
    }

    public String getSourceCol() {
        return this.sourceCol;
    }

    public boolean isDefinesAlias() {
        return this.definesAlias;
    }

    @Override
    public String toString() {
        return "SourceColumn(sourceTab=" + this.getSourceTab() + ", sourceCol=" + this.getSourceCol() + ", definesAlias=" + this.isDefinesAlias() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SourceColumn)) {
            return false;
        }
        SourceColumn other = (SourceColumn)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isDefinesAlias() != other.isDefinesAlias()) {
            return false;
        }
        String this$sourceTab = this.getSourceTab();
        String other$sourceTab = other.getSourceTab();
        if (this$sourceTab == null ? other$sourceTab != null : !this$sourceTab.equals(other$sourceTab)) {
            return false;
        }
        String this$sourceCol = this.getSourceCol();
        String other$sourceCol = other.getSourceCol();
        return !(this$sourceCol == null ? other$sourceCol != null : !this$sourceCol.equals(other$sourceCol));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SourceColumn;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isDefinesAlias() ? 79 : 97);
        String $sourceTab = this.getSourceTab();
        result = result * 59 + ($sourceTab == null ? 43 : $sourceTab.hashCode());
        String $sourceCol = this.getSourceCol();
        result = result * 59 + ($sourceCol == null ? 43 : $sourceCol.hashCode());
        return result;
    }
}

