/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.indatabase.db.object;

import com.rapidminer.extension.indatabase.provider.DatabaseProvider;
import java.io.Serializable;

public class Table
implements Serializable {
    private static final long serialVersionUID = -2064408113804580545L;
    private final String schema;
    private final String table;

    public Table(String tab) {
        this.schema = "";
        this.table = tab;
    }

    public String toSql(DatabaseProvider provider) {
        if (this.schema.isEmpty()) {
            return String.format("%s", provider.quote(this.table));
        }
        return String.format("%s.%s", provider.quote(this.schema), provider.quote(this.table));
    }

    public String toString() {
        return this.schema + "." + this.table;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getTable() {
        return this.table;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Table)) {
            return false;
        }
        Table other = (Table)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$schema = this.getSchema();
        String other$schema = other.getSchema();
        if (this$schema == null ? other$schema != null : !this$schema.equals(other$schema)) {
            return false;
        }
        String this$table = this.getTable();
        String other$table = other.getTable();
        return !(this$table == null ? other$table != null : !this$table.equals(other$table));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Table;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $schema = this.getSchema();
        result = result * 59 + ($schema == null ? 43 : $schema.hashCode());
        String $table = this.getTable();
        result = result * 59 + ($table == null ? 43 : $table.hashCode());
        return result;
    }

    public Table(String schema, String table) {
        this.schema = schema;
        this.table = table;
    }
}

