/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.indatabase.db.step;

import com.rapidminer.extension.indatabase.db.object.Column;
import com.rapidminer.extension.indatabase.db.object.Expression;
import com.rapidminer.extension.indatabase.db.step.DbStep;
import com.rapidminer.extension.indatabase.provider.DatabaseProvider;
import java.io.Serializable;
import java.util.List;

public final class Filter
implements DbStep {
    private static final long serialVersionUID = 8704320585766557070L;
    private final DbStep from;
    private final Expression where;
    private final List<FilterRow> filters;
    private final boolean and;

    @Override
    public List<Column> getColumns(DatabaseProvider provider) {
        return this.from.getColumnRefs(provider);
    }

    Filter(DbStep from, Expression where, List<FilterRow> filters, boolean and) {
        this.from = from;
        this.where = where;
        this.filters = filters;
        this.and = and;
    }

    public static FilterBuilder builder() {
        return new FilterBuilder();
    }

    public DbStep getFrom() {
        return this.from;
    }

    public Expression getWhere() {
        return this.where;
    }

    public List<FilterRow> getFilters() {
        return this.filters;
    }

    public boolean isAnd() {
        return this.and;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Filter)) {
            return false;
        }
        Filter other = (Filter)o;
        if (this.isAnd() != other.isAnd()) {
            return false;
        }
        DbStep this$from = this.getFrom();
        DbStep other$from = other.getFrom();
        if (this$from == null ? other$from != null : !this$from.equals(other$from)) {
            return false;
        }
        Expression this$where = this.getWhere();
        Expression other$where = other.getWhere();
        if (this$where == null ? other$where != null : !((Object)this$where).equals(other$where)) {
            return false;
        }
        List<FilterRow> this$filters = this.getFilters();
        List<FilterRow> other$filters = other.getFilters();
        return !(this$filters == null ? other$filters != null : !((Object)this$filters).equals(other$filters));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAnd() ? 79 : 97);
        DbStep $from = this.getFrom();
        result = result * 59 + ($from == null ? 43 : $from.hashCode());
        Expression $where = this.getWhere();
        result = result * 59 + ($where == null ? 43 : ((Object)$where).hashCode());
        List<FilterRow> $filters = this.getFilters();
        result = result * 59 + ($filters == null ? 43 : ((Object)$filters).hashCode());
        return result;
    }

    public String toString() {
        return "Filter(from=" + String.valueOf(this.getFrom()) + ", where=" + String.valueOf(this.getWhere()) + ", filters=" + String.valueOf(this.getFilters()) + ", and=" + this.isAnd() + ")";
    }

    public static class FilterBuilder {
        private DbStep from;
        private Expression where;
        private List<FilterRow> filters;
        private boolean and;

        FilterBuilder() {
        }

        public FilterBuilder from(DbStep from) {
            this.from = from;
            return this;
        }

        public FilterBuilder where(Expression where) {
            this.where = where;
            return this;
        }

        public FilterBuilder filters(List<FilterRow> filters) {
            this.filters = filters;
            return this;
        }

        public FilterBuilder and(boolean and) {
            this.and = and;
            return this;
        }

        public Filter build() {
            return new Filter(this.from, this.where, this.filters, this.and);
        }

        public String toString() {
            return "Filter.FilterBuilder(from=" + String.valueOf(this.from) + ", where=" + String.valueOf(this.where) + ", filters=" + String.valueOf(this.filters) + ", and=" + this.and + ")";
        }
    }

    public static final class FilterRow
    implements Serializable {
        private static final long serialVersionUID = -2090201400900689545L;
        private final Column column;
        private final FilterCondition condition;
        private final String value;

        public FilterRow(Column column, FilterCondition condition, String value) {
            this.column = column;
            this.condition = condition;
            this.value = value;
        }

        public Column getColumn() {
            return this.column;
        }

        public FilterCondition getCondition() {
            return this.condition;
        }

        public String getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FilterRow)) {
                return false;
            }
            FilterRow other = (FilterRow)o;
            Column this$column = this.getColumn();
            Column other$column = other.getColumn();
            if (this$column == null ? other$column != null : !((Object)this$column).equals(other$column)) {
                return false;
            }
            FilterCondition this$condition = this.getCondition();
            FilterCondition other$condition = other.getCondition();
            if (this$condition == null ? other$condition != null : !((Object)((Object)this$condition)).equals((Object)other$condition)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Column $column = this.getColumn();
            result = result * 59 + ($column == null ? 43 : ((Object)$column).hashCode());
            FilterCondition $condition = this.getCondition();
            result = result * 59 + ($condition == null ? 43 : ((Object)((Object)$condition)).hashCode());
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        public String toString() {
            return "Filter.FilterRow(column=" + String.valueOf(this.getColumn()) + ", condition=" + String.valueOf((Object)this.getCondition()) + ", value=" + this.getValue() + ")";
        }
    }

    public static enum FilterCondition {
        EQ,
        NE,
        LT,
        LE,
        GT,
        GE,
        EQUALS,
        DOES_NOT_EQUAL,
        IS_IN,
        IS_NOT_IN,
        CONTAINS,
        DOES_NOT_CONTAIN,
        STARTS_WITH,
        ENDS_WITH,
        MATCHES,
        IS_MISSING,
        IS_NOT_MISSING;

    }
}

