/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.indatabase.db.step;

import com.rapidminer.extension.indatabase.db.object.Column;
import com.rapidminer.extension.indatabase.db.step.DbStep;
import com.rapidminer.extension.indatabase.provider.DatabaseProvider;
import com.rapidminer.tools.LogService;
import java.util.List;

public class GeneratedDbStep
implements DbStep {
    private static final long serialVersionUID = 3896316335107841899L;
    private final String providerId;
    private final List<Column> columns;
    private final List<Column> columnRefs;
    private final String sql;

    private GeneratedDbStep(String pId, List<Column> cols, List<Column> cRefs, String s) {
        this.providerId = pId;
        this.columns = cols;
        this.columnRefs = cRefs;
        this.sql = s;
    }

    public static GeneratedDbStep of(DatabaseProvider provider, DbStep step) {
        return new GeneratedDbStep(provider.getId(), step.getColumns(provider), step.getColumnRefs(provider), step.toSql(provider));
    }

    private void checkProvider(DatabaseProvider provider) {
        if (!this.providerId.equals(provider.getId())) {
            LogService.getRoot().finer(() -> String.format("Specified provider (%s) differs from generator provider (%s).", provider.getId(), this.providerId));
        }
    }

    @Override
    public List<Column> getColumns(DatabaseProvider provider) {
        this.checkProvider(provider);
        return this.columns;
    }

    @Override
    public List<Column> getColumnRefs(DatabaseProvider provider) {
        this.checkProvider(provider);
        return this.columnRefs;
    }

    @Override
    public String toSql(DatabaseProvider p) {
        this.checkProvider(p);
        return this.sql;
    }
}

