/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.indatabase.db.step;

import com.rapidminer.extension.indatabase.DbTools;
import com.rapidminer.extension.indatabase.db.object.Column;
import com.rapidminer.extension.indatabase.db.object.SourceColumn;
import com.rapidminer.extension.indatabase.db.step.DbStep;
import com.rapidminer.extension.indatabase.provider.DatabaseProvider;
import com.rapidminer.tools.container.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public final class Join
implements DbStep {
    private static final long serialVersionUID = 9174706376602646006L;
    public static final String LEFT_ALIAS = "t1";
    public static final String RIGHT_ALIAS = "t2";
    public static final String FROM_SECOND_SET = "_from_es2";
    private final DbStep left;
    private final DbStep right;
    private final JoinType type;
    private final boolean keepAll;
    private final boolean keepBothKeys;
    private final List<Pair<Column, Column>> keys;

    @Override
    public List<Column> getColumns(DatabaseProvider provider) {
        Set keyCols = this.keys.stream().map(p -> ((Column)p.getFirst()).getDestCol()).collect(Collectors.toSet());
        LinkedHashMap rightTypes = new LinkedHashMap();
        this.right.getColumns(provider).forEach(c -> rightTypes.put(c.getDestCol(), c.getType()));
        List<Column> res = this.left.getColumns(provider).stream().flatMap(c -> {
            if (!keyCols.contains(c.getDestCol()) || this.keepBothKeys || Arrays.asList(JoinType.INNER, JoinType.LEFT).contains((Object)this.type)) {
                return Stream.of(new SourceColumn(LEFT_ALIAS, c.getDestCol(), c.getType()));
            }
            if (this.type == JoinType.OUTER) {
                return Stream.of(DbTools.buildFirstNonNullExpr(provider, new SourceColumn(LEFT_ALIAS, c.getDestCol(), c.getType()), new SourceColumn(RIGHT_ALIAS, c.getDestCol(), (Integer)rightTypes.get(c.getDestCol()))));
            }
            return Stream.empty();
        }).collect(Collectors.toList());
        Set addedLeftColumnsSet = res.stream().map(Column::getDestCol).collect(Collectors.toSet());
        this.right.getColumns(provider).forEach(c -> {
            if (!addedLeftColumnsSet.contains(c.getDestCol())) {
                res.add(new SourceColumn(RIGHT_ALIAS, c.getDestCol(), c.getType()));
            } else if (keyCols.contains(c.getDestCol())) {
                if (this.keepBothKeys) {
                    res.add(new SourceColumn(RIGHT_ALIAS, c.getDestCol(), c.getDestCol() + FROM_SECOND_SET, c.getType()));
                }
            } else if (this.keepAll) {
                res.add(new SourceColumn(RIGHT_ALIAS, c.getDestCol(), c.getDestCol() + FROM_SECOND_SET, c.getType()));
            }
        });
        return res;
    }

    Join(DbStep left, DbStep right, JoinType type, boolean keepAll, boolean keepBothKeys, List<Pair<Column, Column>> keys) {
        this.left = left;
        this.right = right;
        this.type = type;
        this.keepAll = keepAll;
        this.keepBothKeys = keepBothKeys;
        this.keys = keys;
    }

    public static JoinBuilder builder() {
        return new JoinBuilder();
    }

    public DbStep getLeft() {
        return this.left;
    }

    public DbStep getRight() {
        return this.right;
    }

    public JoinType getType() {
        return this.type;
    }

    public boolean isKeepAll() {
        return this.keepAll;
    }

    public boolean isKeepBothKeys() {
        return this.keepBothKeys;
    }

    public List<Pair<Column, Column>> getKeys() {
        return this.keys;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Join)) {
            return false;
        }
        Join other = (Join)o;
        if (this.isKeepAll() != other.isKeepAll()) {
            return false;
        }
        if (this.isKeepBothKeys() != other.isKeepBothKeys()) {
            return false;
        }
        DbStep this$left = this.getLeft();
        DbStep other$left = other.getLeft();
        if (this$left == null ? other$left != null : !this$left.equals(other$left)) {
            return false;
        }
        DbStep this$right = this.getRight();
        DbStep other$right = other.getRight();
        if (this$right == null ? other$right != null : !this$right.equals(other$right)) {
            return false;
        }
        JoinType this$type = this.getType();
        JoinType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        List<Pair<Column, Column>> this$keys = this.getKeys();
        List<Pair<Column, Column>> other$keys = other.getKeys();
        return !(this$keys == null ? other$keys != null : !((Object)this$keys).equals(other$keys));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isKeepAll() ? 79 : 97);
        result = result * 59 + (this.isKeepBothKeys() ? 79 : 97);
        DbStep $left = this.getLeft();
        result = result * 59 + ($left == null ? 43 : $left.hashCode());
        DbStep $right = this.getRight();
        result = result * 59 + ($right == null ? 43 : $right.hashCode());
        JoinType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        List<Pair<Column, Column>> $keys = this.getKeys();
        result = result * 59 + ($keys == null ? 43 : ((Object)$keys).hashCode());
        return result;
    }

    public String toString() {
        return "Join(left=" + String.valueOf(this.getLeft()) + ", right=" + String.valueOf(this.getRight()) + ", type=" + String.valueOf((Object)this.getType()) + ", keepAll=" + this.isKeepAll() + ", keepBothKeys=" + this.isKeepBothKeys() + ", keys=" + String.valueOf(this.getKeys()) + ")";
    }

    public static enum JoinType {
        INNER,
        LEFT,
        RIGHT,
        OUTER;

    }

    public static class JoinBuilder {
        private DbStep left;
        private DbStep right;
        private JoinType type;
        private boolean keepAll;
        private boolean keepBothKeys;
        private List<Pair<Column, Column>> keys;

        public JoinBuilder keys(String ... keyAttrs) {
            if (keyAttrs.length % 2 != 0) {
                throw new IllegalArgumentException("Join key attribute list must contain even number of attributes. Provided list length is " + keyAttrs.length + ".");
            }
            this.keys = new ArrayList<Pair<Column, Column>>();
            IntStream.range(0, keyAttrs.length / 2).forEachOrdered(i -> this.keys.add((Pair<Column, Column>)new Pair((Object)new SourceColumn(Join.LEFT_ALIAS, keyAttrs[i * 2]), (Object)new SourceColumn(Join.RIGHT_ALIAS, keyAttrs[i * 2 + 1]))));
            return this;
        }

        JoinBuilder() {
        }

        public JoinBuilder left(DbStep left) {
            this.left = left;
            return this;
        }

        public JoinBuilder right(DbStep right) {
            this.right = right;
            return this;
        }

        public JoinBuilder type(JoinType type) {
            this.type = type;
            return this;
        }

        public JoinBuilder keepAll(boolean keepAll) {
            this.keepAll = keepAll;
            return this;
        }

        public JoinBuilder keepBothKeys(boolean keepBothKeys) {
            this.keepBothKeys = keepBothKeys;
            return this;
        }

        public Join build() {
            return new Join(this.left, this.right, this.type, this.keepAll, this.keepBothKeys, this.keys);
        }

        public String toString() {
            return "Join.JoinBuilder(left=" + String.valueOf(this.left) + ", right=" + String.valueOf(this.right) + ", type=" + String.valueOf((Object)this.type) + ", keepAll=" + this.keepAll + ", keepBothKeys=" + this.keepBothKeys + ", keys=" + String.valueOf(this.keys) + ")";
        }
    }
}

