/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.indatabase.db.step;

import com.rapidminer.extension.indatabase.db.object.Column;
import com.rapidminer.extension.indatabase.db.step.DbStep;
import com.rapidminer.extension.indatabase.provider.DatabaseProvider;
import java.util.List;

public final class ProbabilitySample
implements DbStep {
    private static final long serialVersionUID = 8226600579053540878L;
    private final DbStep from;
    private final double probability;
    private final boolean useSeed;
    private final long seed;

    @Override
    public List<Column> getColumns(DatabaseProvider provider) {
        return this.from.getColumnRefs(provider);
    }

    ProbabilitySample(DbStep from, double probability, boolean useSeed, long seed) {
        this.from = from;
        this.probability = probability;
        this.useSeed = useSeed;
        this.seed = seed;
    }

    public static ProbabilitySampleBuilder builder() {
        return new ProbabilitySampleBuilder();
    }

    public DbStep getFrom() {
        return this.from;
    }

    public double getProbability() {
        return this.probability;
    }

    public boolean isUseSeed() {
        return this.useSeed;
    }

    public long getSeed() {
        return this.seed;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProbabilitySample)) {
            return false;
        }
        ProbabilitySample other = (ProbabilitySample)o;
        if (Double.compare(this.getProbability(), other.getProbability()) != 0) {
            return false;
        }
        if (this.isUseSeed() != other.isUseSeed()) {
            return false;
        }
        if (this.getSeed() != other.getSeed()) {
            return false;
        }
        DbStep this$from = this.getFrom();
        DbStep other$from = other.getFrom();
        return !(this$from == null ? other$from != null : !this$from.equals(other$from));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $probability = Double.doubleToLongBits(this.getProbability());
        result = result * 59 + (int)($probability >>> 32 ^ $probability);
        result = result * 59 + (this.isUseSeed() ? 79 : 97);
        long $seed = this.getSeed();
        result = result * 59 + (int)($seed >>> 32 ^ $seed);
        DbStep $from = this.getFrom();
        result = result * 59 + ($from == null ? 43 : $from.hashCode());
        return result;
    }

    public String toString() {
        return "ProbabilitySample(from=" + String.valueOf(this.getFrom()) + ", probability=" + this.getProbability() + ", useSeed=" + this.isUseSeed() + ", seed=" + this.getSeed() + ")";
    }

    public static class ProbabilitySampleBuilder {
        private DbStep from;
        private double probability;
        private boolean useSeed;
        private long seed;

        ProbabilitySampleBuilder() {
        }

        public ProbabilitySampleBuilder from(DbStep from) {
            this.from = from;
            return this;
        }

        public ProbabilitySampleBuilder probability(double probability) {
            this.probability = probability;
            return this;
        }

        public ProbabilitySampleBuilder useSeed(boolean useSeed) {
            this.useSeed = useSeed;
            return this;
        }

        public ProbabilitySampleBuilder seed(long seed) {
            this.seed = seed;
            return this;
        }

        public ProbabilitySample build() {
            return new ProbabilitySample(this.from, this.probability, this.useSeed, this.seed);
        }

        public String toString() {
            return "ProbabilitySample.ProbabilitySampleBuilder(from=" + String.valueOf(this.from) + ", probability=" + this.probability + ", useSeed=" + this.useSeed + ", seed=" + this.seed + ")";
        }
    }
}

