/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.indatabase.db.step;

import com.rapidminer.extension.indatabase.db.object.Column;
import com.rapidminer.extension.indatabase.db.step.DbStep;
import com.rapidminer.extension.indatabase.provider.DatabaseProvider;
import java.util.List;

public final class Sample
implements DbStep {
    private static final long serialVersionUID = 7094387992799806423L;
    private final DbStep from;
    private final long limit;
    private final long offset;

    @Override
    public List<Column> getColumns(DatabaseProvider provider) {
        return this.from.getColumnRefs(provider);
    }

    Sample(DbStep from, long limit, long offset) {
        this.from = from;
        this.limit = limit;
        this.offset = offset;
    }

    public static SampleBuilder builder() {
        return new SampleBuilder();
    }

    public DbStep getFrom() {
        return this.from;
    }

    public long getLimit() {
        return this.limit;
    }

    public long getOffset() {
        return this.offset;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Sample)) {
            return false;
        }
        Sample other = (Sample)o;
        if (this.getLimit() != other.getLimit()) {
            return false;
        }
        if (this.getOffset() != other.getOffset()) {
            return false;
        }
        DbStep this$from = this.getFrom();
        DbStep other$from = other.getFrom();
        return !(this$from == null ? other$from != null : !this$from.equals(other$from));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $limit = this.getLimit();
        result = result * 59 + (int)($limit >>> 32 ^ $limit);
        long $offset = this.getOffset();
        result = result * 59 + (int)($offset >>> 32 ^ $offset);
        DbStep $from = this.getFrom();
        result = result * 59 + ($from == null ? 43 : $from.hashCode());
        return result;
    }

    public String toString() {
        return "Sample(from=" + String.valueOf(this.getFrom()) + ", limit=" + this.getLimit() + ", offset=" + this.getOffset() + ")";
    }

    public static class SampleBuilder {
        private DbStep from;
        private long limit;
        private long offset;

        SampleBuilder() {
        }

        public SampleBuilder from(DbStep from) {
            this.from = from;
            return this;
        }

        public SampleBuilder limit(long limit) {
            this.limit = limit;
            return this;
        }

        public SampleBuilder offset(long offset) {
            this.offset = offset;
            return this;
        }

        public Sample build() {
            return new Sample(this.from, this.limit, this.offset);
        }

        public String toString() {
            return "Sample.SampleBuilder(from=" + String.valueOf(this.from) + ", limit=" + this.limit + ", offset=" + this.offset + ")";
        }
    }
}

