/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.indatabase.db.step;

import com.rapidminer.extension.indatabase.db.object.Column;
import com.rapidminer.extension.indatabase.db.object.Table;
import com.rapidminer.extension.indatabase.db.step.DbStep;
import com.rapidminer.extension.indatabase.provider.DatabaseProvider;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class Select
implements DbStep {
    private static final long serialVersionUID = -2777340078713552201L;
    private final List<Column> columns;
    private final Table source;
    private final DbStep from;

    @Override
    public List<Column> getColumns(DatabaseProvider provider) {
        return this.getColumns();
    }

    Select(List<Column> columns, Table source, DbStep from) {
        this.columns = columns;
        this.source = source;
        this.from = from;
    }

    public static SelectBuilder builder() {
        return new SelectBuilder();
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public Table getSource() {
        return this.source;
    }

    public DbStep getFrom() {
        return this.from;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Select)) {
            return false;
        }
        Select other = (Select)o;
        List<Column> this$columns = this.getColumns();
        List<Column> other$columns = other.getColumns();
        if (this$columns == null ? other$columns != null : !((Object)this$columns).equals(other$columns)) {
            return false;
        }
        Table this$source = this.getSource();
        Table other$source = other.getSource();
        if (this$source == null ? other$source != null : !((Object)this$source).equals(other$source)) {
            return false;
        }
        DbStep this$from = this.getFrom();
        DbStep other$from = other.getFrom();
        return !(this$from == null ? other$from != null : !this$from.equals(other$from));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Column> $columns = this.getColumns();
        result = result * 59 + ($columns == null ? 43 : ((Object)$columns).hashCode());
        Table $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : ((Object)$source).hashCode());
        DbStep $from = this.getFrom();
        result = result * 59 + ($from == null ? 43 : $from.hashCode());
        return result;
    }

    public String toString() {
        return "Select(columns=" + String.valueOf(this.getColumns()) + ", source=" + String.valueOf(this.getSource()) + ", from=" + String.valueOf(this.getFrom()) + ")";
    }

    public static class SelectBuilder {
        private List<Column> columns;
        private Table source;
        private DbStep from;

        public SelectBuilder select(String ... cols) {
            this.columns = Stream.of(cols).map(Column::new).collect(Collectors.toList());
            return this;
        }

        public SelectBuilder from(String tab) {
            this.source = new Table(tab);
            return this;
        }

        public SelectBuilder from(DbStep step) {
            this.from = step;
            return this;
        }

        SelectBuilder() {
        }

        public SelectBuilder columns(List<Column> columns) {
            this.columns = columns;
            return this;
        }

        public SelectBuilder source(Table source) {
            this.source = source;
            return this;
        }

        public Select build() {
            return new Select(this.columns, this.source, this.from);
        }

        public String toString() {
            return "Select.SelectBuilder(columns=" + String.valueOf(this.columns) + ", source=" + String.valueOf(this.source) + ", from=" + String.valueOf(this.from) + ")";
        }
    }
}

