/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.indatabase.db.step;

import com.rapidminer.extension.indatabase.db.object.Column;
import com.rapidminer.extension.indatabase.db.step.DbStep;
import com.rapidminer.extension.indatabase.provider.DatabaseProvider;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class Sort
implements DbStep {
    private static final long serialVersionUID = 3811793193277785704L;
    private final DbStep from;
    private final List<SortColumn> by;

    @Override
    public List<Column> getColumns(DatabaseProvider provider) {
        return this.from.getColumnRefs(provider);
    }

    Sort(DbStep from, List<SortColumn> by) {
        this.from = from;
        this.by = by;
    }

    public static SortBuilder builder() {
        return new SortBuilder();
    }

    public DbStep getFrom() {
        return this.from;
    }

    public List<SortColumn> getBy() {
        return this.by;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Sort)) {
            return false;
        }
        Sort other = (Sort)o;
        DbStep this$from = this.getFrom();
        DbStep other$from = other.getFrom();
        if (this$from == null ? other$from != null : !this$from.equals(other$from)) {
            return false;
        }
        List<SortColumn> this$by = this.getBy();
        List<SortColumn> other$by = other.getBy();
        return !(this$by == null ? other$by != null : !((Object)this$by).equals(other$by));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DbStep $from = this.getFrom();
        result = result * 59 + ($from == null ? 43 : $from.hashCode());
        List<SortColumn> $by = this.getBy();
        result = result * 59 + ($by == null ? 43 : ((Object)$by).hashCode());
        return result;
    }

    public String toString() {
        return "Sort(from=" + String.valueOf(this.getFrom()) + ", by=" + String.valueOf(this.getBy()) + ")";
    }

    public static class SortBuilder {
        private DbStep from;
        private List<SortColumn> by;

        public SortBuilder by(String ... cols) {
            this.by = Stream.of(cols).map(Column::new).map(SortColumn::new).collect(Collectors.toList());
            return this;
        }

        public SortBuilder by(List<SortColumn> cols) {
            this.by = cols;
            return this;
        }

        SortBuilder() {
        }

        public SortBuilder from(DbStep from) {
            this.from = from;
            return this;
        }

        public Sort build() {
            return new Sort(this.from, this.by);
        }

        public String toString() {
            return "Sort.SortBuilder(from=" + String.valueOf(this.from) + ", by=" + String.valueOf(this.by) + ")";
        }
    }

    public static final class SortColumn
    implements Serializable {
        private static final long serialVersionUID = 3936356371005466786L;
        private final Column column;
        private final SortType type;

        public SortColumn(Column col) {
            this.column = col;
            this.type = SortType.ASCENDING;
        }

        public Column getColumn() {
            return this.column;
        }

        public SortType getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SortColumn)) {
                return false;
            }
            SortColumn other = (SortColumn)o;
            Column this$column = this.getColumn();
            Column other$column = other.getColumn();
            if (this$column == null ? other$column != null : !((Object)this$column).equals(other$column)) {
                return false;
            }
            SortType this$type = this.getType();
            SortType other$type = other.getType();
            return !(this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Column $column = this.getColumn();
            result = result * 59 + ($column == null ? 43 : ((Object)$column).hashCode());
            SortType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            return result;
        }

        public String toString() {
            return "Sort.SortColumn(column=" + String.valueOf(this.getColumn()) + ", type=" + String.valueOf((Object)this.getType()) + ")";
        }

        public SortColumn(Column column, SortType type) {
            this.column = column;
            this.type = type;
        }
    }

    public static enum SortType {
        ASCENDING,
        DESCENDING;

    }
}

