/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.indatabase.db.step;

import com.rapidminer.extension.indatabase.db.object.Column;
import com.rapidminer.extension.indatabase.db.step.DbStep;
import com.rapidminer.extension.indatabase.metadata.DbMetaDataTools;
import com.rapidminer.extension.indatabase.provider.DatabaseProvider;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public final class Union
implements DbStep {
    private static final long serialVersionUID = -3779293034629824384L;
    private final DbStep left;
    private final DbStep right;
    private final boolean all;

    @Override
    public List<Column> getColumns(DatabaseProvider provider) {
        List<Column> leftCols = this.left.getColumnRefs(provider);
        List<Column> rightCols = this.right.getColumnRefs(provider);
        return IntStream.range(0, leftCols.size()).mapToObj(i -> DbMetaDataTools.compareSqlTypesForGenerality(((Column)leftCols.get(i)).getType(), ((Column)rightCols.get(i)).getType()) <= 0 ? (Column)leftCols.get(i) : (Column)rightCols.get(i)).collect(Collectors.toList());
    }

    Union(DbStep left, DbStep right, boolean all) {
        this.left = left;
        this.right = right;
        this.all = all;
    }

    public static UnionBuilder builder() {
        return new UnionBuilder();
    }

    public DbStep getLeft() {
        return this.left;
    }

    public DbStep getRight() {
        return this.right;
    }

    public boolean isAll() {
        return this.all;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Union)) {
            return false;
        }
        Union other = (Union)o;
        if (this.isAll() != other.isAll()) {
            return false;
        }
        DbStep this$left = this.getLeft();
        DbStep other$left = other.getLeft();
        if (this$left == null ? other$left != null : !this$left.equals(other$left)) {
            return false;
        }
        DbStep this$right = this.getRight();
        DbStep other$right = other.getRight();
        return !(this$right == null ? other$right != null : !this$right.equals(other$right));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAll() ? 79 : 97);
        DbStep $left = this.getLeft();
        result = result * 59 + ($left == null ? 43 : $left.hashCode());
        DbStep $right = this.getRight();
        result = result * 59 + ($right == null ? 43 : $right.hashCode());
        return result;
    }

    public String toString() {
        return "Union(left=" + String.valueOf(this.getLeft()) + ", right=" + String.valueOf(this.getRight()) + ", all=" + this.isAll() + ")";
    }

    public static class UnionBuilder {
        private DbStep left;
        private DbStep right;
        private boolean all;

        UnionBuilder() {
        }

        public UnionBuilder left(DbStep left) {
            this.left = left;
            return this;
        }

        public UnionBuilder right(DbStep right) {
            this.right = right;
            return this;
        }

        public UnionBuilder all(boolean all) {
            this.all = all;
            return this;
        }

        public Union build() {
            return new Union(this.left, this.right, this.all);
        }

        public String toString() {
            return "Union.UnionBuilder(left=" + String.valueOf(this.left) + ", right=" + String.valueOf(this.right) + ", all=" + this.all + ")";
        }
    }
}

