/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.indatabase.exceptions;

import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.SimpleProcessSetupError;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.PortOwner;
import com.rapidminer.operator.ports.metadata.MetaDataError;
import com.rapidminer.operator.ports.quickfix.QuickFix;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class OperatorOrSetupError
extends Exception {
    private static final long serialVersionUID = 8386599046306408095L;
    private final List<ProcessSetupError> processSetupError = new ArrayList<ProcessSetupError>();
    private final List<MetaDataError> metaDataError = new ArrayList<MetaDataError>();
    private OperatorException operatorException;

    public OperatorOrSetupError withProcessSetupError(ProcessSetupError ... e) {
        this.processSetupError.addAll(Arrays.asList(e));
        return this;
    }

    public OperatorOrSetupError withMetaDataError(MetaDataError ... e) {
        this.metaDataError.addAll(Arrays.asList(e));
        return this;
    }

    public OperatorOrSetupError withUserError(UserError e) {
        this.operatorException = e;
        return this;
    }

    public OperatorOrSetupError withOperatorException(OperatorException e) {
        this.operatorException = e;
        return this;
    }

    public OperatorOrSetupError withCustomError(Exception e, PortOwner o, List<QuickFix> fixes) {
        this.processSetupError.add((ProcessSetupError)new SimpleProcessSetupError(ProcessSetupError.Severity.ERROR, o, fixes, "custom_error", new Object[]{e.getMessage()}));
        return this;
    }

    public void addSetupError(Operator op) {
        this.processSetupError.forEach(arg_0 -> ((Operator)op).addError(arg_0));
        this.metaDataError.forEach(e -> e.getPort().addError(e));
    }

    public void throwOperatorException() throws OperatorException {
        if (this.operatorException != null) {
            throw this.operatorException;
        }
    }
}

