/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.indatabase.gui;

import com.rapidminer.Process;
import com.rapidminer.extension.indatabase.exceptions.NestNotFoundException;
import com.rapidminer.extension.indatabase.gui.ParameterTypeDbExpression;
import com.rapidminer.extension.indatabase.operator.Nest;
import com.rapidminer.extension.indatabase.operator.function.DatabaseFunctionRegistry;
import com.rapidminer.extension.indatabase.operator.function.SQLExpressionParser;
import com.rapidminer.gui.properties.ExpressionPropertyDialog;
import com.rapidminer.gui.properties.celleditors.value.PropertyValueCellEditor;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.OperatorVersion;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.ModelMetaData;
import com.rapidminer.parameter.ParameterTypeExpression;
import com.rapidminer.tools.expression.ExampleResolver;
import com.rapidminer.tools.expression.ExpressionParser;
import com.rapidminer.tools.expression.ExpressionParserBuilder;
import com.rapidminer.tools.expression.MacroResolver;
import com.rapidminer.tools.expression.Resolver;
import com.rapidminer.tools.expression.internal.ConstantResolver;
import com.rapidminer.tools.expression.internal.function.eval.Evaluation;
import com.rapidminer.tools.expression.internal.function.eval.TypeConstants;
import com.rapidminer.tools.expression.internal.function.process.ParameterValue;
import com.rapidminer.tools.expression.internal.function.statistical.Random;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.swing.AbstractCellEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;

public class DbExpressionValueCellEditor
extends AbstractCellEditor
implements PropertyValueCellEditor {
    private static final long serialVersionUID = -6938088022502950908L;
    private static final Color LIGHTER_GRAY = new Color(237, 237, 237);
    private static final String CALCULATOR_NAME = "calculator.png";
    private static Icon CALCULATOR_ICON = null;
    private final JPanel panel = new JPanel();
    private final JEditorPane editorPane = new JEditorPane();
    private final ParameterTypeDbExpression type;
    private final GridBagLayout gridBagLayout = new GridBagLayout();
    private boolean showOverflow = false;
    private JButton button;
    private Insets margin = new Insets(8, 5, 8, 5);
    private RSyntaxTextArea currentExpression = new RSyntaxTextArea();

    public DbExpressionValueCellEditor(ParameterTypeDbExpression type) {
        this.type = type;
        this.panel.setLayout(this.gridBagLayout);
        this.panel.setToolTipText(type.getDescription());
        this.editorPane.setMargin(this.margin);
        this.editorPane.setAlignmentX(0.0f);
        this.editorPane.setToolTipText(type.getDescription());
        this.editorPane.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                Component oppositeComponent = e.getOppositeComponent();
                if (oppositeComponent != DbExpressionValueCellEditor.this.button && !e.isTemporary()) {
                    DbExpressionValueCellEditor.this.fireEditingStopped();
                }
                DbExpressionValueCellEditor.this.resetEditorPanePosition();
                DbExpressionValueCellEditor.this.updateOverflowIndicator();
            }

            @Override
            public void focusGained(FocusEvent e) {
                DbExpressionValueCellEditor.this.resetEditorPanePosition();
                DbExpressionValueCellEditor.this.showOverflow = false;
                DbExpressionValueCellEditor.this.panel.repaint();
            }
        });
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weighty = 1.0;
        c.weightx = 1.0;
        ExtendedJScrollPane scrollPane = new ExtendedJScrollPane(this.editorPane){
            private static final long serialVersionUID = 1L;

            public void paint(Graphics g) {
                super.paint(g);
                if (DbExpressionValueCellEditor.this.showOverflow) {
                    DbExpressionValueCellEditor.this.drawOverflowIndicator(g, this.getPreferredSize().width);
                }
            }
        };
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.setVerticalScrollBarPolicy(21);
        scrollPane.setBorder(null);
        this.panel.add((Component)scrollPane, c);
        this.button = new JButton(CALCULATOR_ICON);
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DbExpressionValueCellEditor.this.buttonPressed();
                DbExpressionValueCellEditor.this.resetEditorPanePosition();
                DbExpressionValueCellEditor.this.updateOverflowIndicator();
            }
        });
        this.button.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                if (e.getOppositeComponent() != DbExpressionValueCellEditor.this.editorPane && !e.isTemporary()) {
                    DbExpressionValueCellEditor.this.fireEditingStopped();
                }
                DbExpressionValueCellEditor.this.resetEditorPanePosition();
                DbExpressionValueCellEditor.this.updateOverflowIndicator();
            }

            @Override
            public void focusGained(FocusEvent e) {
                DbExpressionValueCellEditor.this.resetEditorPanePosition();
                DbExpressionValueCellEditor.this.updateOverflowIndicator();
            }
        });
        c.gridwidth = 0;
        c.weightx = 0.0;
        this.panel.add((Component)this.button, c);
    }

    private void hideSyntaxCheckPanel(ExpressionPropertyDialog dialog) {
        JPanel mainPanel = (JPanel)dialog.getContentPane().getComponent(1);
        mainPanel = (JPanel)mainPanel.getComponent(0);
        JPanel expressionPanel = (JPanel)mainPanel.getComponent(0);
        JPanel syntaxCheckPanel = (JPanel)expressionPanel.getComponent(2);
        syntaxCheckPanel.setVisible(false);
    }

    private void buttonPressed() {
        Nest.ExpressionEditorCacheMap eMap;
        Nest.ExpressionEditorCache e;
        Nest nest;
        Operator ownerOperator;
        Object value = this.getCellEditorValue();
        String initial = value == null ? null : value.toString();
        ExpressionParserBuilder builder = new ExpressionParserBuilder();
        if (this.type.getInputPort() != null) {
            builder = builder.withCompatibility(new OperatorVersion("6.5.0"));
        }
        if ((ownerOperator = this.type.getInputPort().getPorts().getOwner().getOperator()) != null) {
            try {
                nest = Nest.findParentNest(this.type.getInputPort().getPorts().getOwner().getOperator());
            }
            catch (NestNotFoundException e3) {
                e3.printStackTrace();
                return;
            }
        } else {
            return;
        }
        String dialect = null;
        try {
            dialect = nest.getCurrentProvider().getId();
        }
        catch (Nest.CouldNotRetrieveConnectionInformation | OperatorException e1) {
            SwingTools.showSimpleErrorMessage((String)"undefined_connection", (String)e1.getMessage(), (Object[])new Object[0]);
        }
        Nest.DialectAndMetaDataKey cacheKey = new Nest.DialectAndMetaDataKey(dialect, null);
        InputPort inPort = this.type.getInputPort();
        if (inPort != null) {
            ExampleSetMetaData emd;
            ModelMetaData mmd;
            if (inPort.getMetaData() instanceof ExampleSetMetaData) {
                ExampleSetMetaData emd2 = (ExampleSetMetaData)inPort.getMetaData();
                if (emd2 != null) {
                    builder = builder.withDynamics((Resolver)new ExampleResolver(emd2));
                    cacheKey = Nest.DialectAndMetaDataKey.fromExampleSetMetaData(dialect, emd2);
                }
            } else if (inPort.getMetaData() instanceof ModelMetaData && (mmd = (ModelMetaData)inPort.getMetaData()) != null && (emd = mmd.getTrainingSetMetaData()) != null) {
                builder = builder.withDynamics((Resolver)new ExampleResolver(emd));
            }
        }
        if ((e = (eMap = nest.getExpressionEditorCacheMap()).getOrCreate(cacheKey)).getControllingProcess() != null) {
            builder = builder.withProcess(e.getControllingProcess());
            builder = builder.withScope((Resolver)new MacroResolver(e.getControllingProcess().getMacroHandler()));
        }
        try {
            String providerKey = nest.getCurrentProvider().getId();
            builder = builder.withModules(DatabaseFunctionRegistry.getAllExpressionParserModules(providerKey));
            ExpressionParser parser = builder.build();
            List inputs = parser.getExpressionContext().getFunctionInputs();
            inputs.removeAll(new ConstantResolver(TypeConstants.INSTANCE.getKey(), TypeConstants.INSTANCE.getConstants()).getAllVariables());
            List functions = parser.getExpressionContext().getFunctionDescriptions();
            functions.removeAll(Arrays.asList(new Evaluation().getFunctionDescription(), new ParameterValue(e.getControllingProcess()).getFunctionDescription(), new Random(e.getControllingProcess()).getFunctionDescription()));
            SQLExpressionParser dbParser = DatabaseFunctionRegistry.getParser(e.getControllingProcess(), parser.getExpressionContext(), this.type.getKey(), nest.getGrammarStream());
            if (e.getCurrentDialog() == null) {
                e.setCurrentDialog(new ExpressionPropertyDialog((ParameterTypeExpression)this.type, e.getControllingProcess(), inputs, functions, (ExpressionParser)dbParser, initial));
            } else if (!Objects.equals(value, e.getCurrentDialog().getExpression())) {
                try {
                    Field fieldCurrentExpression = ExpressionPropertyDialog.class.getDeclaredField("currentExpression");
                    fieldCurrentExpression.setAccessible(true);
                    Object expr = fieldCurrentExpression.get(e.getCurrentDialog());
                    Method methodSetText = expr.getClass().getMethod("setText", String.class);
                    methodSetText.invoke(expr, value);
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | NoSuchMethodException | SecurityException | InvocationTargetException e1) {
                    e1.printStackTrace();
                }
            }
            this.hideSyntaxCheckPanel(e.getCurrentDialog());
            e.getCurrentDialog().setVisible(true);
            if (e.getCurrentDialog().isOk()) {
                this.setText(e.getCurrentDialog().getExpression());
            }
        }
        catch (Nest.CouldNotRetrieveConnectionInformation | OperatorException throwable) {
            // empty catch block
        }
        this.fireEditingStopped();
        this.resetEditorPanePosition();
        this.updateOverflowIndicator();
    }

    protected boolean isFilterExpression() {
        return false;
    }

    protected void setText(String text) {
        if (text == null) {
            this.editorPane.setText("");
        } else {
            this.editorPane.setText(text);
        }
        this.resetEditorPanePosition();
        this.updateOverflowIndicator();
    }

    private void resetEditorPanePosition() {
        this.editorPane.setCaretPosition(0);
        this.editorPane.setMargin(this.margin);
    }

    public void setOperator(Operator operator) {
        Nest.ExpressionEditorCache e;
        Nest nest;
        Process opProcess = operator.getProcess();
        try {
            nest = Nest.findParentNest(this.type.getInputPort().getPorts().getOwner().getOperator());
        }
        catch (NestNotFoundException e1) {
            e1.printStackTrace();
            return;
        }
        String dialect = null;
        try {
            dialect = nest.getCurrentProvider().getId();
        }
        catch (Nest.CouldNotRetrieveConnectionInformation | OperatorException throwable) {
            // empty catch block
        }
        Nest.DialectAndMetaDataKey eKey = new Nest.DialectAndMetaDataKey(dialect, null);
        InputPort in = (InputPort)operator.getInputPorts().getPortByIndex(0);
        Nest.ExpressionEditorCacheMap eMap = nest.getExpressionEditorCacheMap();
        if (in != null && in.getMetaData() != null && in.getMetaData() instanceof ExampleSetMetaData) {
            eKey = Nest.DialectAndMetaDataKey.fromExampleSetMetaData(dialect, (ExampleSetMetaData)in.getMetaData());
        }
        if (!Objects.equals(opProcess, (e = eMap.getOrCreate(eKey)).getControllingProcess())) {
            e.setCurrentDialog(null);
        }
        e.setControllingProcess(opProcess);
    }

    public boolean rendersLabel() {
        return false;
    }

    @Override
    public Object getCellEditorValue() {
        return this.editorPane.getText().trim().length() == 0 ? null : this.editorPane.getText().trim();
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
        this.editorPane.setText(value == null ? "" : value.toString());
        this.resetEditorPanePosition();
        this.updateOverflowIndicator();
        return this.panel;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        return this.getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    public boolean useEditorAsRenderer() {
        return true;
    }

    private void drawOverflowIndicator(Graphics g, int maxX) {
        int width = 25;
        int height = 10;
        int xOffset = 10;
        int stepSize = width / 5;
        int dotSize = 3;
        int x = maxX - width - xOffset;
        int y = this.button.getSize().height - height;
        g.setColor(LIGHTER_GRAY);
        g.fillRect(x, y, width, width);
        g.setColor(Color.GRAY);
        g.drawRoundRect(x, y, width, width, 5, 5);
        g.setColor(Color.BLACK);
        g.fillOval(x + stepSize, y + 4, dotSize, dotSize);
        g.fillOval(x + stepSize * 2, y + 4, dotSize, dotSize);
        g.fillOval(x + stepSize * 3, y + 4, dotSize, dotSize);
        g.dispose();
    }

    private int getLineCount() {
        this.currentExpression.setText(this.editorPane.getText());
        return this.currentExpression.getLineCount();
    }

    private void updateOverflowIndicator() {
        if (this.getLineCount() > 1) {
            this.showOverflow = true;
            this.panel.repaint();
        } else {
            this.showOverflow = false;
            this.panel.repaint();
        }
    }

    static {
        CALCULATOR_ICON = SwingTools.createIcon((String)"16/calculator.png");
    }
}

