/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.indatabase.gui;

import com.google.api.client.util.Strings;
import com.rapidminer.extension.indatabase.db.CachedDatabaseHandler;
import com.rapidminer.extension.indatabase.exceptions.NestNotFoundException;
import com.rapidminer.extension.indatabase.gui.TableParameterChooser;
import com.rapidminer.extension.indatabase.operator.Nest;
import com.rapidminer.extension.indatabase.operator.RetrieveOperator;
import com.rapidminer.extension.indatabase.provider.DatabaseProvider;
import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.tools.ProgressThread;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.parameter.SuggestionProvider;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.ProgressListener;
import com.rapidminer.tools.config.ConfigurationException;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import java.util.Vector;

public class DbSuggestionProvider
implements SuggestionProvider<String> {
    public final Operator operator;
    public final TableParameterChooser tableParameterChooser;
    private final ProvisionType provisionType;

    public DbSuggestionProvider(Operator operator, TableParameterChooser tableParameterChooser, ProvisionType provisionType) {
        Objects.requireNonNull(provisionType);
        this.operator = operator;
        this.tableParameterChooser = tableParameterChooser;
        this.provisionType = provisionType;
    }

    public List<String> getSuggestions(Operator op, ProgressListener pl) {
        return this.getSuggestions(false);
    }

    private List<String> getSuggestions(boolean force) {
        try {
            Nest nest = Nest.findParentNest(this.operator);
            CachedDatabaseHandler dbHandler = nest.getCurrentDbHandler();
            DatabaseProvider provider = dbHandler.getProvider();
            String project = provider.supportsProjects() ? this.tableParameterChooser.getProjectName() : "";
            switch (this.provisionType) {
                case PROJECT_NAMES: {
                    return new Vector<String>(dbHandler.getProjectNames(force));
                }
                case SCHEMA_NAMES: {
                    if (Strings.isNullOrEmpty((String)project)) {
                        return new Vector<String>(dbHandler.getSchemaNames(force));
                    }
                    return new Vector<String>(dbHandler.getSchemaNames(project, force));
                }
                case TABLE_NAMES: {
                    String dbName = this.tableParameterChooser.getSchemaName();
                    if (dbName == null) {
                        return new Vector<String>();
                    }
                    if (Strings.isNullOrEmpty((String)project)) {
                        return new Vector<String>(dbHandler.getTableNames(dbName, force));
                    }
                    return new Vector<String>(dbHandler.getTableNames(project, dbName, force));
                }
            }
            throw new IllegalStateException("Unknown ProvisionType");
        }
        catch (Nest.CouldNotRetrieveConnectionInformation | OperatorException | ConfigurationException e) {
            LogService.getRoot().fine(e.toString());
        }
        catch (SQLException e) {
            LogService.getRoot().warning(e.toString());
        }
        return new Vector<String>();
    }

    public ResourceAction getAction() {
        return new ResourceAction(true, this.provisionType.getResourceActionKey(), new Object[0]){
            private static final long serialVersionUID = 5287231242939242386L;
            {
                this.putValue("Name", "");
            }

            public void loggedActionPerformed(ActionEvent e) {
                ProgressThread t = new ProgressThread(DbSuggestionProvider.this.provisionType.getResourceActionKey()){

                    public void run() {
                        try {
                            this.getProgressListener().setTotal(100);
                            this.getProgressListener().setCompleted(10);
                            try {
                                Nest nest = Nest.findParentNest(DbSuggestionProvider.this.operator);
                                try {
                                    nest.getDbHandler().clearCache();
                                    if (DbSuggestionProvider.this.operator instanceof RetrieveOperator) {
                                        ((RetrieveOperator)DbSuggestionProvider.this.operator).clearMetaDataCache();
                                    }
                                }
                                catch (UserError userError) {}
                            }
                            catch (NestNotFoundException nestNotFoundException) {
                                // empty catch block
                            }
                            this.getProgressListener().setCompleted(20);
                            DbSuggestionProvider.this.getSuggestions(true);
                            this.getProgressListener().setCompleted(90);
                            RapidMinerGUI.getMainFrame().validateProcess(true);
                        }
                        finally {
                            this.getProgressListener().complete();
                        }
                    }
                };
                t.start();
            }
        };
    }

    public static enum ProvisionType {
        PROJECT_NAMES("db.refresh_projects"),
        SCHEMA_NAMES("db.refresh_schemas"),
        TABLE_NAMES("db.refresh_tables");

        private final String resourceActionKey;

        private ProvisionType(String resourceActionKey) {
            this.resourceActionKey = resourceActionKey;
        }

        public String getResourceActionKey() {
            return this.resourceActionKey;
        }
    }
}

