/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.indatabase.gui;

import com.google.api.client.util.Strings;
import com.rapidminer.extension.indatabase.exceptions.DbTableException;
import com.rapidminer.extension.indatabase.gui.DbSuggestionProvider;
import com.rapidminer.extension.indatabase.operator.Nest;
import com.rapidminer.extension.indatabase.provider.DatabaseProvider;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.SimpleProcessSetupError;
import com.rapidminer.operator.ports.quickfix.ParameterSettingQuickFix;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeSuggestion;
import com.rapidminer.parameter.SuggestionProvider;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.ParameterCondition;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TableParameterChooser {
    private static final String PARAMETER_PROJECT_NAME = "project_name";
    public static final String PARAMETER_SCHEMA_NAME = "schema_name";
    public static final String PARAMETER_TABLE_NAME = "table_name";
    public static final String PARAMETER_DEFAULT_PROJECT = "<default_project>";
    private final Operator operator;
    private final String projectParameterKey;
    private final String schemaParameterKey;
    private final String tableParameterKey;

    public TableParameterChooser(Operator operator, boolean addProjectParameter) {
        this.operator = operator;
        this.projectParameterKey = addProjectParameter ? PARAMETER_PROJECT_NAME : null;
        this.schemaParameterKey = PARAMETER_SCHEMA_NAME;
        this.tableParameterKey = PARAMETER_TABLE_NAME;
    }

    public List<ParameterType> getParameterTypes(String tableHelpString) {
        ArrayList<ParameterType> types = new ArrayList<ParameterType>();
        ParameterTypeSuggestion tableName = new ParameterTypeSuggestion(this.tableParameterKey, tableHelpString, (SuggestionProvider)new DbSuggestionProvider(this.operator, this, DbSuggestionProvider.ProvisionType.TABLE_NAMES), false);
        ParameterTypeSuggestion schemaName = new ParameterTypeSuggestion(this.schemaParameterKey, "Name of the schema.", (SuggestionProvider)new DbSuggestionProvider(this.operator, this, DbSuggestionProvider.ProvisionType.SCHEMA_NAMES), false);
        if (this.projectParameterKey != null) {
            ParameterTypeSuggestion projectName = new ParameterTypeSuggestion(this.projectParameterKey, "Project ID. If empty, project specified in the connection is used.", (SuggestionProvider)new DbSuggestionProvider(this.operator, this, DbSuggestionProvider.ProvisionType.PROJECT_NAMES), true);
            projectName.registerDependencyCondition(new ParameterCondition((ParameterHandler)this.operator, false){

                public boolean isConditionFullfilled() {
                    try {
                        Nest nest = Nest.findParentNest(TableParameterChooser.this.operator);
                        DatabaseProvider provider = nest.getCurrentProvider();
                        return provider != null && provider.supportsProjects();
                    }
                    catch (Nest.CouldNotRetrieveConnectionInformation | OperatorException e) {
                        return false;
                    }
                }
            });
            types.add((ParameterType)projectName);
        }
        types.add((ParameterType)schemaName);
        types.add((ParameterType)tableName);
        return types;
    }

    public String getProjectName() {
        if (this.projectParameterKey == null) {
            return null;
        }
        try {
            String p = this.operator.getParameterAsString(this.projectParameterKey);
            if (PARAMETER_DEFAULT_PROJECT.equals(p)) {
                return null;
            }
            return p;
        }
        catch (UndefinedParameterError e) {
            return null;
        }
    }

    public String getSchemaName() {
        try {
            return this.operator.getParameter(this.schemaParameterKey);
        }
        catch (UndefinedParameterError e) {
            return null;
        }
    }

    public String getTableNameForDisplay() throws UndefinedParameterError {
        String schema = this.getSchemaName();
        String table = this.getTableBaseName();
        if (schema != null && !schema.isEmpty()) {
            return String.format("'%s'.'%s'", schema, table);
        }
        return table;
    }

    public String getTableBaseName() throws UndefinedParameterError {
        return this.operator.getParameter(this.tableParameterKey);
    }

    public void checkTable(boolean forceReload) throws DbTableException, OperatorException, SQLException {
        DatabaseProvider provider;
        String projectName;
        boolean exists;
        Nest nest;
        String usedDatabase = this.getSchemaName();
        String tableName = this.getTableBaseName();
        if (usedDatabase != null && tableName != null && (nest = Nest.findParentNest(this.operator)) != null && !(exists = Strings.isNullOrEmpty((String)(projectName = (provider = nest.getProvider()).supportsProjects() ? this.getProjectName() : "")) ? nest.getDbHandler().tableExists(usedDatabase, tableName, forceReload) : nest.getDbHandler().tableExists(projectName, usedDatabase, tableName, forceReload))) {
            throw new DbTableException(tableName);
        }
    }

    public boolean checkSchema(boolean forceReload) throws OperatorException, SQLException {
        String projectName;
        if (this.getSchemaName() == null) {
            return true;
        }
        Nest nest = Nest.findParentNest(this.operator);
        DatabaseProvider provider = nest.getProvider();
        String string = projectName = provider.supportsProjects() ? this.getProjectName() : "";
        if (Strings.isNullOrEmpty((String)projectName)) {
            return nest.getDbHandler().schemaExists(this.getSchemaName(), forceReload);
        }
        return nest.getDbHandler().schemaExists(projectName, this.getSchemaName(), forceReload);
    }

    public boolean addProcessSetupErrors() {
        try {
            try {
                if (!this.checkSchema(false)) {
                    this.operator.addError((ProcessSetupError)new SimpleProcessSetupError(ProcessSetupError.Severity.WARNING, this.operator.getPortOwner(), Collections.singletonList(new ParameterSettingQuickFix(this.operator, this.schemaParameterKey)), "nonexistent_schema", new Object[]{this.getSchemaName()}));
                    return false;
                }
            }
            catch (SQLException e) {
                this.operator.logError(e.getMessage());
                this.operator.addError((ProcessSetupError)new SimpleProcessSetupError(ProcessSetupError.Severity.ERROR, this.operator.getPortOwner(), Collections.emptyList(), "schema_list", new Object[0]));
                return false;
            }
            try {
                this.checkTable(false);
                return true;
            }
            catch (DbTableException e) {
                this.operator.addError((ProcessSetupError)new SimpleProcessSetupError(ProcessSetupError.Severity.WARNING, this.operator.getPortOwner(), Collections.singletonList(new ParameterSettingQuickFix(this.operator, this.tableParameterKey)), "nonexistent_table", new Object[]{this.getTableNameForDisplay()}));
                return false;
            }
            catch (SQLException e) {
                this.operator.logError(e.getMessage());
                this.operator.addError((ProcessSetupError)new SimpleProcessSetupError(ProcessSetupError.Severity.ERROR, this.operator.getPortOwner(), Collections.emptyList(), "table_list", new Object[0]));
                return false;
            }
        }
        catch (OperatorException operatorException) {
            return false;
        }
    }
}

