/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.indatabase.metadata;

import com.rapidminer.belt.util.ColumnMetaData;
import com.rapidminer.extension.indatabase.data.DbTableExampleSet;
import com.rapidminer.extension.indatabase.db.step.DbStep;
import com.rapidminer.extension.indatabase.db.step.GeneratedDbStep;
import com.rapidminer.extension.indatabase.metadata.DbTableColumnMetaData;
import com.rapidminer.extension.indatabase.provider.DatabaseProvider;
import com.rapidminer.extension.jdbc.tools.jdbc.DatabaseHandler;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MDInteger;
import com.rapidminer.operator.ports.metadata.ToTableMetaDataConverter;
import com.rapidminer.operator.ports.metadata.table.TableMetaData;
import com.rapidminer.operator.ports.metadata.table.TableMetaDataBuilder;
import com.rapidminer.tools.Ontology;
import java.util.NoSuchElementException;

public class DbMetaDataTools {
    public static final MDInteger UNKNOWN_MDINTEGER = new MDInteger(){
        private static final long serialVersionUID = -6254206196392709548L;
        {
            this.setUnkown();
        }
    };

    public static TableMetaData buildTableMetaData(DatabaseProvider provider, DbStep dbStep) {
        ExampleSetMetaData md = new ExampleSetMetaData(DbTableExampleSet.class);
        dbStep = GeneratedDbStep.of(provider, dbStep);
        dbStep.getColumns(provider).stream().map(c -> {
            AttributeMetaData amd = new AttributeMetaData(c.getDestCol(), DbMetaDataTools.getRapidMinerTypeIndex(c.getType()));
            amd.setNumberOfMissingValues(UNKNOWN_MDINTEGER);
            return amd;
        }).forEachOrdered(amd -> md.addAttribute(amd));
        md.getNumberOfExamples().setUnkown();
        TableMetaData convertedMD = ToTableMetaDataConverter.convert((ExampleSetMetaData)md);
        TableMetaDataBuilder builder = new TableMetaDataBuilder(convertedMD);
        DbMetaDataTools.writeColumnMetaData(builder, new DbTableColumnMetaData(provider, dbStep));
        return builder.build();
    }

    public static void writeColumnMetaData(TableMetaDataBuilder builder, DbTableColumnMetaData md) {
        try {
            String firstName = (String)builder.labels().iterator().next();
            builder.addColumnMetaData(firstName, (ColumnMetaData)md);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        builder.updateHeight(DbTableColumnMetaData.UNKNOWN_MDINTEGER);
    }

    public static DbTableColumnMetaData readColumnMetaData(TableMetaData md) {
        for (String c : md.labels()) {
            DbTableColumnMetaData dbcmd = (DbTableColumnMetaData)md.getFirstColumnMetaData(c, DbTableColumnMetaData.class);
            if (dbcmd == null) continue;
            return dbcmd;
        }
        return null;
    }

    public static void resetColumnMetaData(TableMetaDataBuilder builder) {
        for (String c : builder.labels()) {
            DbTableColumnMetaData dbcmd = (DbTableColumnMetaData)builder.getFirstColumnMetaData(c, DbTableColumnMetaData.class);
            if (dbcmd == null) continue;
            builder.removeColumnMetaData(c, DbTableColumnMetaData.class);
            return;
        }
    }

    public static int getRapidMinerTypeIndex(int sqlType) {
        if (sqlType == 0) {
            return 0;
        }
        return DatabaseHandler.getRapidMinerTypeIndex((int)sqlType);
    }

    public static int getSqlType(int rapidMinerType) {
        switch (rapidMinerType) {
            case 0: {
                return 0;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 8;
            }
            case 2: {
                return 2;
            }
            case 5: {
                return 2004;
            }
            case 1: {
                return 12;
            }
            case 10: {
                return 91;
            }
            case 11: {
                return 92;
            }
            case 9: {
                return 93;
            }
        }
        return 12;
    }

    public static int getTheMoreGeneralSqlType(int type1, int type2) {
        switch (DbMetaDataTools.compareSqlTypesForGenerality(type1, type2)) {
            case -1: 
            case 0: {
                return type1;
            }
        }
        return type2;
    }

    public static int compareSqlTypesForGenerality(int type1, int type2) {
        int rmType1 = DbMetaDataTools.getRapidMinerTypeIndex(type1);
        int rmType2 = DbMetaDataTools.getRapidMinerTypeIndex(type2);
        return Ontology.ATTRIBUTE_VALUE_TYPE.isA(rmType2, rmType1) ? -1 : (Ontology.ATTRIBUTE_VALUE_TYPE.isA(rmType1, rmType2) ? 1 : 0);
    }
}

