/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.indatabase.operator;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.extension.indatabase.data.DbTableExampleSet;
import com.rapidminer.extension.indatabase.db.step.DbStep;
import com.rapidminer.extension.indatabase.exceptions.ConnectionEntryNotFound;
import com.rapidminer.extension.indatabase.exceptions.NestNotFoundException;
import com.rapidminer.extension.indatabase.exceptions.OperatorOrSetupError;
import com.rapidminer.extension.indatabase.operator.AbstractNestedOperator;
import com.rapidminer.extension.indatabase.provider.DatabaseProvider;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.SimpleProcessSetupError;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.quickfix.ParameterSettingQuickFix;
import com.rapidminer.operator.tools.AttributeSubsetSelector;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.ProcessTools;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class AbstractFilteredProcessing
extends AbstractNestedOperator {
    protected final AttributeSubsetSelector attributeSelector = new AbstractNestedOperator.DbColumnSubsetSelector((ParameterHandler)this, this.getInputPort());

    protected AbstractFilteredProcessing(OperatorDescription description) {
        super(description, true);
    }

    public List<ParameterType> getParameterTypes() {
        List types = super.getParameterTypes();
        types.addAll(ProcessTools.setSubsetSelectorPrimaryParameter((List)this.attributeSelector.getParameterTypes(), (boolean)true));
        return types;
    }

    @Override
    public final DbStep buildDbStep(DbStep ... inputs) throws OperatorOrSetupError, NestNotFoundException, UndefinedParameterError, ConnectionEntryNotFound {
        Set<String> attributeSubset;
        DatabaseProvider provider = this.getProvider();
        try {
            DbTableExampleSet inputEs = new DbTableExampleSet(provider, inputs[0]);
            attributeSubset = this.attributeSelector.getAttributeSubset((ExampleSet)inputEs, true).stream().map(Attribute::getName).collect(Collectors.toSet());
        }
        catch (UserError e) {
            throw new OperatorOrSetupError().withUserError(e);
        }
        if (attributeSubset.isEmpty()) {
            throw new OperatorOrSetupError().withUserError(new UserError((Operator)this, "empty_attribute_set", new Object[]{this.getName()})).withProcessSetupError(new ProcessSetupError[]{new SimpleProcessSetupError(ProcessSetupError.Severity.ERROR, this.getPortOwner(), Collections.singletonList(new ParameterSettingQuickFix((Operator)this, "attribute_filter_type", "change_parameter", new Object[]{"attribute_filter_type"})), "empty_attribute_set", new Object[]{this.getName()})});
        }
        return this.buildDbStepOnFilteredColumns(attributeSubset, inputs[0]);
    }

    public abstract DbStep buildDbStepOnFilteredColumns(Set<String> var1, DbStep var2) throws OperatorOrSetupError, NestNotFoundException, UndefinedParameterError, ConnectionEntryNotFound;
}

