/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.indatabase.operator;

import com.rapidminer.Process;
import com.rapidminer.extension.indatabase.data.DbTableExampleSet;
import com.rapidminer.extension.indatabase.data.SampleDbTableExampleSet;
import com.rapidminer.extension.indatabase.db.step.DbStep;
import com.rapidminer.extension.indatabase.db.step.GeneratedDbStep;
import com.rapidminer.extension.indatabase.exceptions.ConnectionEntryNotFound;
import com.rapidminer.extension.indatabase.exceptions.NestNotFoundException;
import com.rapidminer.extension.indatabase.exceptions.OperatorOrSetupError;
import com.rapidminer.extension.indatabase.metadata.DbMetaDataTools;
import com.rapidminer.extension.indatabase.metadata.DbTableColumnMetaData;
import com.rapidminer.extension.indatabase.operator.Nest;
import com.rapidminer.extension.indatabase.operator.NestedOperator;
import com.rapidminer.extension.indatabase.provider.DatabaseProvider;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.Port;
import com.rapidminer.operator.ports.metadata.CompatibilityLevel;
import com.rapidminer.operator.ports.metadata.InputMissingMetaDataError;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.MetaDataError;
import com.rapidminer.operator.ports.metadata.Precondition;
import com.rapidminer.operator.ports.metadata.table.TableMetaData;
import com.rapidminer.operator.ports.metadata.table.TablePrecondition;
import com.rapidminer.operator.tools.AttributeSubsetSelector;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.ProcessTools;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.stream.IntStream;

public abstract class AbstractNestedOperator
extends Operator
implements NestedOperator {
    private final InputPort exampleSetInput;
    private final OutputPort exampleSetOutput;
    private boolean queryIsRunning = false;

    protected AbstractNestedOperator(OperatorDescription description, boolean addDefaultPorts) {
        super(description);
        if (addDefaultPorts) {
            this.exampleSetInput = this.createInputPortWithPrecondition("example set input");
            this.exampleSetOutput = (OutputPort)this.getOutputPorts().createPort("example set output");
            this.addDefaultTransformationRule(this.exampleSetInput, this.exampleSetOutput);
        } else {
            this.exampleSetInput = null;
            this.exampleSetOutput = null;
        }
    }

    protected InputPort getInputPort() {
        if (this.exampleSetInput == null) {
            throw new IllegalStateException("getInputPort() called on uninitialized input port");
        }
        return this.exampleSetInput;
    }

    protected OutputPort getOutputPort() {
        if (this.exampleSetOutput == null) {
            throw new IllegalStateException("getOutputPort() called on uninitialized output port");
        }
        return this.exampleSetOutput;
    }

    protected InputPort createInputPortWithPrecondition(String name) {
        InputPort port = (InputPort)this.getInputPorts().createPort(name);
        port.addPrecondition((Precondition)new NestedPrecondition(port));
        return port;
    }

    protected void addDefaultTransformationRule(final InputPort inputPort, final OutputPort outputPort) {
        this.getTransformer().addRule(new MDTransformationRule(){

            public void transformMD() {
                TableMetaData tmd;
                TableMetaData result = tmd = (TableMetaData)inputPort.getMetaDataAsOrNull(TableMetaData.class);
                if (tmd != null) {
                    DbTableColumnMetaData dbcmd = DbMetaDataTools.readColumnMetaData(tmd);
                    if (dbcmd != null) {
                        try {
                            TableMetaData md;
                            DbStep dbStep = AbstractNestedOperator.this.buildDbStep(dbcmd.getDbStep());
                            result = md = DbMetaDataTools.buildTableMetaData(AbstractNestedOperator.this.getProvider(), dbStep);
                        }
                        catch (ConnectionEntryNotFound | NestNotFoundException | UndefinedParameterError dbStep) {
                        }
                        catch (OperatorOrSetupError e) {
                            e.addSetupError(AbstractNestedOperator.this);
                        }
                    }
                    if (result != null) {
                        result.addToHistory(outputPort);
                    }
                }
                outputPort.deliverMD((MetaData)result);
            }
        });
    }

    public void doWork() throws OperatorException {
        this.getProgress().setIndeterminate(true);
        ArrayList<GeneratedDbStep> inputs = new ArrayList<GeneratedDbStep>();
        for (InputPort p : this.getInputPorts().getAllPorts()) {
            if (this.exampleSetInput != null) {
                inputs.add(((DbTableExampleSet)p.getData(DbTableExampleSet.class)).getDbStep());
                continue;
            }
            DbTableExampleSet e = (DbTableExampleSet)p.getDataOrNull(DbTableExampleSet.class);
            if (e == null) continue;
            inputs.add(e.getDbStep());
        }
        try {
            DatabaseProvider provider = this.getProvider();
            DbTableExampleSet outputEs = new DbTableExampleSet(provider, this.buildDbStep(inputs.toArray(new DbStep[0])));
            OutputPort firstOutputPort = (OutputPort)this.getOutputPorts().getAllPorts().get(0);
            firstOutputPort.deliver((IOObject)this.handleBreakpoints(firstOutputPort, outputEs));
        }
        catch (OperatorOrSetupError e) {
            e.throwOperatorException();
        }
    }

    protected DbTableExampleSet handleBreakpoints(OutputPort outputPort, DbTableExampleSet outputEs) throws OperatorException {
        InputPort destinationPort;
        Operator o;
        if (outputEs instanceof SampleDbTableExampleSet) {
            return outputEs;
        }
        boolean explore = false;
        if (this.hasBreakpoint(1)) {
            explore = true;
        } else if (outputPort.isConnected() && (o = (destinationPort = outputPort.getDestination()).getPorts().getOwner().getOperator()) != null && o.hasBreakpoint(0)) {
            explore = true;
        }
        if (explore) {
            return outputEs.exploreTable(Nest.findParentNest(this));
        }
        return outputEs;
    }

    public abstract DbStep buildDbStep(DbStep ... var1) throws UndefinedParameterError, NestNotFoundException, OperatorOrSetupError, ConnectionEntryNotFound;

    protected void performAdditionalChecks() {
        super.performAdditionalChecks();
        this.checkIsInIndatabaseNest(true);
    }

    private void propagateCallBackwards(Consumer<AbstractNestedOperator> f) {
        this.getInputPorts().getAllPorts().stream().filter(Port::isConnected).map(p -> p.getSource().getPorts().getOwner().getOperator()).filter(o -> o instanceof AbstractNestedOperator).forEachOrdered(o -> f.accept((AbstractNestedOperator)o));
    }

    public void propagateQueryIsRunning() {
        this.queryIsRunning = true;
        this.getProgress().setIndeterminate(true);
        Process p = this.getProcess();
        if (p != null) {
            p.getRootOperator().processStartedOperator((Operator)this);
        }
        this.propagateCallBackwards(AbstractNestedOperator::propagateQueryIsRunning);
    }

    public void propagateQueryIsDone() {
        this.queryIsRunning = false;
        this.getProgress().reset();
        Process p = this.getProcess();
        if (p != null) {
            p.getRootOperator().processFinishedOperator((Operator)this);
        }
        this.propagateCallBackwards(AbstractNestedOperator::propagateQueryIsDone);
    }

    public boolean isAnimating() {
        return super.isAnimating() || this.queryIsRunning;
    }

    public static class NestedPrecondition
    extends TablePrecondition {
        public NestedPrecondition(InputPort inputPort) {
            super(inputPort);
        }

        public void makeAdditionalChecks(TableMetaData emd) throws UndefinedParameterError {
            super.makeAdditionalChecks(emd);
            if (DbMetaDataTools.readColumnMetaData(emd) == null) {
                this.getInputPort().addError((MetaDataError)new InputMissingMetaDataError(this.getInputPort(), DbTableExampleSet.class, null));
            }
        }

        public boolean isCompatible(MetaData input, CompatibilityLevel level) {
            return super.isCompatible(input, level) && DbTableExampleSet.class.isAssignableFrom(input.getObjectClass());
        }

        public MetaData getExpectedMetaData() {
            return new TableMetaData();
        }

        public String getDescription() {
            return "<em>expects:</em> Database Query Result";
        }
    }

    public static class DbColumnSubsetSelector
    extends AttributeSubsetSelector {
        public DbColumnSubsetSelector(ParameterHandler operator, InputPort inPort) {
            super(operator, inPort);
        }

        public List<ParameterType> getParameterTypes() {
            List types = ProcessTools.setSubsetSelectorPrimaryParameter((List)super.getParameterTypes(), (boolean)true);
            ParameterTypeCategory type = new ParameterTypeCategory("attribute_filter_type", "The condition specifies which attributes are selected or affected by this operator.", new String[]{"all", "single", "subset", "regular_expression", "value_type"}, 0);
            type.setExpert(false);
            types.set(this.indexOfParameter(types, "attribute_filter_type"), type);
            types.remove(this.indexOfParameter(types, "include_special_attributes"));
            return types;
        }

        private int indexOfParameter(List<ParameterType> types, String parameter) {
            return IntStream.range(0, types.size()).filter(i -> ((ParameterType)types.get(i)).getKey().equals(parameter)).findFirst().orElseThrow(() -> new NoSuchElementException(String.format("Initialization error. Could not find parameter %s in attribute selector parameters.", parameter)));
        }
    }
}

