/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.indatabase.operator;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.extension.indatabase.data.DbTableExampleSet;
import com.rapidminer.extension.indatabase.db.object.Column;
import com.rapidminer.extension.indatabase.db.object.ColumnExpr;
import com.rapidminer.extension.indatabase.db.step.Aggregate;
import com.rapidminer.extension.indatabase.db.step.DbStep;
import com.rapidminer.extension.indatabase.exceptions.ConnectionEntryNotFound;
import com.rapidminer.extension.indatabase.exceptions.NestNotFoundException;
import com.rapidminer.extension.indatabase.exceptions.OperatorOrSetupError;
import com.rapidminer.extension.indatabase.operator.AbstractNestedOperator;
import com.rapidminer.extension.indatabase.operator.function.FunctionDefinition;
import com.rapidminer.extension.indatabase.provider.DatabaseProvider;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.SimpleProcessSetupError;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.Port;
import com.rapidminer.operator.ports.metadata.MetaDataError;
import com.rapidminer.operator.ports.metadata.SimpleMetaDataError;
import com.rapidminer.operator.tools.AttributeSubsetSelector;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeAttribute;
import com.rapidminer.parameter.ParameterTypeAttributes;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.ParameterTypeSuggestion;
import com.rapidminer.parameter.SuggestionProvider;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.parameter.conditions.ParameterCondition;
import com.rapidminer.tools.ProgressListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class AggregateOperator
extends AbstractNestedOperator {
    private final AttributeSubsetSelector attributeSelector = new AbstractNestedOperator.DbColumnSubsetSelector((ParameterHandler)this, this.getInputPort());
    private final SuggestionProvider<String> aggregationFunctionSuggestionPovider = new AggregationFunctionsSuggestionProvider();
    private static final Pattern PATTERN_FUNCTION_WITH_PARENTHESIS = Pattern.compile("([^(]*)\\((.*)\\)");

    public AggregateOperator(OperatorDescription description) {
        super(description, true);
    }

    public List<ParameterType> getParameterTypes() {
        List types = super.getParameterTypes();
        types.add(new ParameterTypeBoolean("use_default_aggregation", "If checked you can select a default aggregation function for a subset of the attributes.", false, false));
        List parameterTypes = this.attributeSelector.getParameterTypes();
        for (ParameterType type : parameterTypes) {
            type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, "use_default_aggregation", false, true));
            types.add(type);
        }
        ParameterTypeSuggestion type = new ParameterTypeSuggestion("default_aggregation_function", "The type of the used aggregation function for all default attributes.", this.aggregationFunctionSuggestionPovider);
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, "use_default_aggregation", false, true));
        type.setExpert(false);
        types.add(type);
        ParameterTypeList aggregationAttribute = new ParameterTypeList("aggregation_attributes", "The attributes which should be aggregated.", (ParameterType)new ParameterTypeAttribute("aggregation_attribute", "Specifies the attribute which is aggregated.", this.getInputPort(), false), (ParameterType)new ParameterTypeSuggestion("aggregation_functions", "The type of the used aggregation function.", this.aggregationFunctionSuggestionPovider), false);
        aggregationAttribute.setPrimary(true);
        types.add(aggregationAttribute);
        types.add(new ParameterTypeAttributes("group_by_attributes", "Performs a grouping by the values of the attributes by the selected attributes.", this.getInputPort(), true, false));
        return types;
    }

    @Override
    public DbStep buildDbStep(DbStep ... inputs) throws UndefinedParameterError, NestNotFoundException, OperatorOrSetupError, ConnectionEntryNotFound {
        DatabaseProvider provider = this.getProvider();
        this.checkParameters(provider, inputs[0]);
        LinkedHashMap inputCols = new LinkedHashMap();
        inputs[0].getColumnRefs(this.getProvider()).forEach(c -> inputCols.put(c.getDestCol(), c));
        List<Column> groupByCols = Stream.of(this.getParameterAsString("group_by_attributes").split("\\|")).filter(a -> !a.isEmpty() && inputCols.containsKey(a)).map(inputCols::get).collect(Collectors.toList());
        ArrayList<Column> selectCols = new ArrayList<Column>();
        selectCols.addAll(groupByCols);
        List aggregationAttrs = this.getParameterList("aggregation_attributes");
        selectCols.addAll(aggregationAttrs.stream().map(p -> AggregateOperator.buildColumnExpr(provider, p[0], p[1], ((Column)inputCols.get(p[0])).getType())).collect(Collectors.toList()));
        if (this.getParameterAsBoolean("use_default_aggregation")) {
            Set defaultAggregationAttributeSubset;
            Set explicitAggregationAttrNames = aggregationAttrs.stream().map(p -> p[0]).collect(Collectors.toSet());
            DbTableExampleSet inputEs = new DbTableExampleSet(this.getProvider(), inputs[0]);
            try {
                defaultAggregationAttributeSubset = this.attributeSelector.getAttributeSubset((ExampleSet)inputEs, true).stream().map(Attribute::getName).collect(Collectors.toSet());
            }
            catch (UserError e) {
                throw new OperatorOrSetupError().withUserError(e);
            }
            List defaultAggregationAttrNames = defaultAggregationAttributeSubset.stream().filter(s -> !explicitAggregationAttrNames.contains(s)).collect(Collectors.toList());
            for (String a2 : defaultAggregationAttrNames) {
                selectCols.add(AggregateOperator.buildColumnExpr(provider, a2, this.getParameterAsString("default_aggregation_function"), ((Column)inputCols.get(a2)).getType()));
            }
        }
        if (selectCols.isEmpty()) {
            throw new OperatorOrSetupError().withUserError(new UserError((Operator)this, "aggregate.no_aggregation")).withProcessSetupError(new ProcessSetupError[]{new SimpleProcessSetupError(ProcessSetupError.Severity.ERROR, this.getPortOwner(), "aggregation.no_aggregation", new Object[0])});
        }
        return Aggregate.builder().select(selectCols).from(inputs[0]).groupBy(groupByCols).build();
    }

    private static Column buildColumnExpr(DatabaseProvider provider, String attrName, String functionName, int originalSqlType) {
        FunctionDefinition function = provider.getAggregationFunctions().get(functionName);
        if (function == null) {
            return new ColumnExpr(String.format("%s(%s)", functionName, provider.quote(attrName)), String.format("%s_%s", functionName, attrName), 0);
        }
        Matcher m = PATTERN_FUNCTION_WITH_PARENTHESIS.matcher(function.getIdentifier());
        if (m.matches()) {
            return new ColumnExpr(String.format("%s(%s %s)", m.group(1), m.group(2), new Column(attrName).toSql(provider)), String.format("%s_%s_%s", m.group(1), m.group(2), attrName), function.getReturnSqlType(originalSqlType));
        }
        return new ColumnExpr(String.format("%s(%s)", function.getIdentifier(), new Column(attrName).toSql(provider)), String.format("%s_%s", function.getIdentifier(), attrName), function.getReturnSqlType(originalSqlType));
    }

    private void checkParameters(DatabaseProvider provider, DbStep input) throws OperatorOrSetupError, UndefinedParameterError {
        Set inputAttrs = input.getColumns(provider).stream().map(Column::getDestCol).collect(Collectors.toSet());
        Set unknownGroupByAttributes = Stream.of(this.getParameterAsString("group_by_attributes").split("\\|")).filter(s -> !s.isEmpty()).filter(a -> !inputAttrs.contains(a)).collect(Collectors.toSet());
        if (!unknownGroupByAttributes.isEmpty()) {
            throw new OperatorOrSetupError().withUserError(new UserError((Operator)this, unknownGroupByAttributes.size() > 1 ? "aggregate_group_by_not_found" : "aggregate_group_by_not_found_single", new Object[]{unknownGroupByAttributes.stream().collect(Collectors.joining(", "))})).withMetaDataError(new MetaDataError[]{new SimpleMetaDataError(ProcessSetupError.Severity.ERROR, (Port)this.getInputPort(), "aggregation.group_by_attribute_unknown", new Object[]{unknownGroupByAttributes.iterator().next()})});
        }
        Set unknownAggregationAttrs = this.getParameterList("aggregation_attributes").stream().map(p -> p[0]).filter(a -> !inputAttrs.contains(a)).collect(Collectors.toSet());
        if (!unknownAggregationAttrs.isEmpty()) {
            String anUnknown = (String)unknownAggregationAttrs.iterator().next();
            throw new OperatorOrSetupError().withUserError(new UserError((Operator)this, "aggregation.aggregation_attribute_not_present", new Object[]{anUnknown})).withMetaDataError(new MetaDataError[]{new SimpleMetaDataError(ProcessSetupError.Severity.ERROR, (Port)this.getInputPort(), "aggregation.attribute_unknown", new Object[]{anUnknown})});
        }
    }

    private class AggregationFunctionsSuggestionProvider
    implements SuggestionProvider<String> {
        private AggregationFunctionsSuggestionProvider() {
        }

        public List<String> getSuggestions(Operator op, ProgressListener pl) {
            ArrayList<String> res = new ArrayList<String>();
            try {
                res.addAll(AggregateOperator.this.getProvider().getAggregationFunctions().keySet());
                return res;
            }
            catch (NestNotFoundException | OperatorOrSetupError e) {
                return Collections.emptyList();
            }
        }

        public ResourceAction getAction() {
            return null;
        }
    }
}

