/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.indatabase.operator;

import com.rapidminer.extension.indatabase.db.object.Column;
import com.rapidminer.extension.indatabase.db.step.DbStep;
import com.rapidminer.extension.indatabase.db.step.Select;
import com.rapidminer.extension.indatabase.exceptions.ConnectionEntryNotFound;
import com.rapidminer.extension.indatabase.exceptions.NestNotFoundException;
import com.rapidminer.extension.indatabase.exceptions.OperatorOrSetupError;
import com.rapidminer.extension.indatabase.operator.AbstractNestedOperator;
import com.rapidminer.extension.indatabase.provider.DatabaseProvider;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.SimpleProcessSetupError;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeAttributeOrderingRules;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.EqualTypeCondition;
import com.rapidminer.parameter.conditions.ParameterCondition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class AttributeOrdering
extends AbstractNestedOperator {
    public static final String PARAMETER_ORDER_MODE = "order_mode";
    public static final String USER_SPECIFIED_RULES_MODE = "user specified";
    public static final int USER_SPECIFIED_RULES_MODE_INDEX = 0;
    public static final String ALPHABETICALLY_MODE = "alphabetically";
    public static final int ALPHABETICALLY_MODE_INDEX = 1;
    public static final String[] ORDER_MODES_VALUES = new String[]{"user specified", "alphabetically"};
    public static final String PARAMETER_SORT_UNMATCHED_DIRECTION = "unmatched_direction";
    public static final String PARAMETER_SORT_DIRECTION = "sort_direction";
    public static final String DIRECTION_ASCENDING = "ascending";
    public static final int DIRECTION_ASCENDING_INDEX = 0;
    public static final String DIRECTION_DESCENDING = "descending";
    public static final int DIRECTION_DESCENDING_INDEX = 1;
    public static final String DIRECTION_NONE = "none";
    public static final int DIRECTION_NONE_INDEX = 2;
    public static final String[] SORT_UNMATCHED_DIRECTION_VALUES = new String[]{"ascending", "descending", "none"};
    public static final String[] SORT_DIRECTIONS_VALUES = new String[]{"ascending", "descending"};
    public static final String PARAMETER_ORDER_RULES = "attribute_ordering";
    public static final String PARAMETER_USE_REGEXP = "use_regular_expressions";
    public static final String PARAMETER_HANDLE_UNMATCHED_ATTRIBUTES = "handle_unmatched";
    public static final String REMOVE_UNMATCHED_MODE = "remove";
    public static final int REMOVE_UNMATCHED_MODE_INDEX = 0;
    public static final String PREPEND_UNMATCHED_MODE = "prepend";
    public static final int PREPEND_UNMATCHED_MODE_INDEX = 1;
    public static final String APPEND_UNMATCHED_MODE = "append";
    public static final int APPEND_UNMATCHED_MODE_INDEX = 2;
    public static final String[] HANDLE_UNMATCHED_MODES = new String[]{"remove", "prepend", "append"};
    public static final String ATTRIBUTE_SEPARATOR_REGEX = "\\|";

    public AttributeOrdering(OperatorDescription description) {
        super(description, true);
    }

    public List<ParameterType> getParameterTypes() {
        List parameterTypes = super.getParameterTypes();
        ParameterTypeCategory type = new ParameterTypeCategory(PARAMETER_ORDER_MODE, "Ordering method that should be applied.", ORDER_MODES_VALUES, 0, false);
        parameterTypes.add(type);
        type = new ParameterTypeAttributeOrderingRules(PARAMETER_ORDER_RULES, "Rules to order attributes.", (InputPort)this.getInputPorts().getPortByIndex(0), true);
        type.setExpert(false);
        type.setPrimary(true);
        type.registerDependencyCondition((ParameterCondition)new EqualTypeCondition((ParameterHandler)this, PARAMETER_ORDER_MODE, ORDER_MODES_VALUES, true, new int[]{0}));
        parameterTypes.add(type);
        type = new ParameterTypeBoolean(PARAMETER_USE_REGEXP, "If checked attribute orders will be evaluated as regular expressions.", false, true);
        type.registerDependencyCondition((ParameterCondition)new EqualTypeCondition((ParameterHandler)this, PARAMETER_ORDER_MODE, ORDER_MODES_VALUES, true, new int[]{0}));
        parameterTypes.add(type);
        type = new ParameterTypeCategory(PARAMETER_HANDLE_UNMATCHED_ATTRIBUTES, "Defines the behavior for unmatched attributes.", HANDLE_UNMATCHED_MODES, 2, false);
        type.setOptional(true);
        type.registerDependencyCondition((ParameterCondition)new EqualTypeCondition((ParameterHandler)this, PARAMETER_ORDER_MODE, ORDER_MODES_VALUES, false, new int[]{0}));
        parameterTypes.add(type);
        type = new ParameterTypeCategory(PARAMETER_SORT_UNMATCHED_DIRECTION, "Sort direction for unmatched attribute names.", SORT_UNMATCHED_DIRECTION_VALUES, 0, false);
        type.registerDependencyCondition((ParameterCondition)new EqualTypeCondition((ParameterHandler)this, PARAMETER_HANDLE_UNMATCHED_ATTRIBUTES, HANDLE_UNMATCHED_MODES, false, new int[]{2, 1}));
        parameterTypes.add(type);
        type = new ParameterTypeCategory(PARAMETER_SORT_DIRECTION, "Sort direction for attribute names.", SORT_DIRECTIONS_VALUES, 0, false);
        type.registerDependencyCondition((ParameterCondition)new EqualTypeCondition((ParameterHandler)this, PARAMETER_ORDER_MODE, ORDER_MODES_VALUES, false, new int[]{1}));
        parameterTypes.add(type);
        return parameterTypes;
    }

    @Override
    public DbStep buildDbStep(DbStep ... inputs) throws UndefinedParameterError, NestNotFoundException, ConnectionEntryNotFound, OperatorOrSetupError {
        List<String> finalColumns;
        DatabaseProvider provider = this.getProvider();
        List<Column> inputColumnRefs = inputs[0].getColumnRefs(provider);
        List<String> columns = inputColumnRefs.stream().map(Column::getDestCol).collect(Collectors.toList());
        Map<String, Column> inputCols = inputColumnRefs.stream().collect(Collectors.toMap(Column::getDestCol, Function.identity()));
        if (this.getParameterAsString(PARAMETER_ORDER_MODE).equals(ALPHABETICALLY_MODE)) {
            AttributeOrdering.sort(columns, this.getParameterAsString(PARAMETER_SORT_DIRECTION));
            finalColumns = columns;
        } else {
            List<String> rules = this.collectRules(columns, inputCols);
            if (rules.isEmpty()) {
                throw new OperatorOrSetupError().withUserError(new UserError((Operator)this, "205", new Object[]{PARAMETER_ORDER_RULES, ""}));
            }
            String handleUnmatched = this.getParameterAsString(PARAMETER_HANDLE_UNMATCHED_ATTRIBUTES);
            if (REMOVE_UNMATCHED_MODE.equals(handleUnmatched)) {
                finalColumns = rules;
            } else {
                String unmatchedOrder = this.getParameterAsString(PARAMETER_SORT_UNMATCHED_DIRECTION);
                finalColumns = new ArrayList<String>();
                rules.forEach(columns::remove);
                AttributeOrdering.sort(columns, unmatchedOrder);
                if (APPEND_UNMATCHED_MODE.equals(handleUnmatched)) {
                    rules.forEach(finalColumns::add);
                    columns.forEach(finalColumns::add);
                } else {
                    columns.forEach(finalColumns::add);
                    rules.forEach(finalColumns::add);
                }
            }
        }
        List<Column> selectCols = finalColumns.stream().map(inputCols::get).collect(Collectors.toList());
        return Select.builder().from(inputs[0]).columns(selectCols).build();
    }

    private List<String> collectRules(List<String> columns, Map<String, Column> inputCols) throws OperatorOrSetupError, UndefinedParameterError {
        ArrayList<String> rules = new ArrayList();
        String[] ruleEntries = this.getParameterAsString(PARAMETER_ORDER_RULES).split(ATTRIBUTE_SEPARATOR_REGEX);
        if (this.getParameterAsBoolean(PARAMETER_USE_REGEXP)) {
            for (String rule : ruleEntries) {
                try {
                    Pattern.compile(rule);
                }
                catch (PatternSyntaxException e) {
                    throw new OperatorOrSetupError().withUserError(new UserError((Operator)this, 206, new Object[]{rule, e.getMessage()})).withProcessSetupError(new ProcessSetupError[]{new SimpleProcessSetupError(ProcessSetupError.Severity.ERROR, this.getPortOwner(), "invalid_regex", new Object[]{rule})});
                }
                columns.stream().filter(c -> c.matches(rule)).forEachOrdered(rules::add);
            }
        } else {
            rules = Stream.of(ruleEntries).filter(a -> !a.isEmpty() && inputCols.containsKey(a)).collect(Collectors.toList());
        }
        return rules;
    }

    private static void sort(List<String> list, String sortOrder) {
        switch (sortOrder) {
            case "ascending": {
                Collections.sort(list);
                break;
            }
            case "descending": {
                Collections.sort(list, Collections.reverseOrder());
                break;
            }
        }
    }
}

