/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.indatabase.operator;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.extension.indatabase.data.DbTableExampleSet;
import com.rapidminer.extension.indatabase.db.object.Column;
import com.rapidminer.extension.indatabase.db.object.ColumnExpr;
import com.rapidminer.extension.indatabase.db.step.DbStep;
import com.rapidminer.extension.indatabase.db.step.Select;
import com.rapidminer.extension.indatabase.exceptions.ConnectionEntryNotFound;
import com.rapidminer.extension.indatabase.exceptions.NestNotFoundException;
import com.rapidminer.extension.indatabase.exceptions.OperatorOrSetupError;
import com.rapidminer.extension.indatabase.operator.AbstractNestedOperator;
import com.rapidminer.extension.indatabase.operator.Nest;
import com.rapidminer.extension.indatabase.provider.DatabaseProvider;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.SimpleProcessSetupError;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.tools.AttributeSubsetSelector;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeAttribute;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.ParameterTypeSuggestion;
import com.rapidminer.parameter.SuggestionProvider;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.parameter.conditions.ParameterCondition;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.ProgressListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConvertType
extends AbstractNestedOperator {
    public static final String PARAMETER_USE_DEFAULT_TYPE_CONVERSION = "use_default_type_conversion";
    public static final String PARAMETER_DEFAULT_TYPE_CONVERSION = "default_type_conversion";
    public static final String PARAMETER_TYPE_CONVERSIONS = "type_conversions";
    public static final String PARAMETER_NEW_TYPE = "new_type";
    private final AttributeSubsetSelector defaultAttributeSelector = new AbstractNestedOperator.DbColumnSubsetSelector((ParameterHandler)this, this.getInputPort());

    public ConvertType(OperatorDescription description) {
        super(description, true);
    }

    public List<ParameterType> getParameterTypes() {
        List types = super.getParameterTypes();
        ParameterTypeBoolean type = new ParameterTypeBoolean(PARAMETER_USE_DEFAULT_TYPE_CONVERSION, "If checked you can select a default type conversion for a subset of the attributes.", false, false);
        types.add(type);
        List attrSelectorParams = this.defaultAttributeSelector.getParameterTypes();
        attrSelectorParams.add(new ParameterTypeSuggestion(PARAMETER_DEFAULT_TYPE_CONVERSION, "Default Type Conversion", (SuggestionProvider)new TypeSuggestionProvider(), false));
        attrSelectorParams.forEach(t -> t.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_USE_DEFAULT_TYPE_CONVERSION, false, true)));
        types.addAll(attrSelectorParams);
        types.add(type);
        type = new ParameterTypeList(PARAMETER_TYPE_CONVERSIONS, "List of type conversions.", (ParameterType)new ParameterTypeAttribute("attribute", "Attribute", this.getInputPort(), false), (ParameterType)new ParameterTypeSuggestion(PARAMETER_NEW_TYPE, "Type", (SuggestionProvider)new TypeSuggestionProvider(), false));
        types.add(type);
        return types;
    }

    @Override
    public DbStep buildDbStep(DbStep ... inputs) throws UndefinedParameterError, NestNotFoundException, OperatorOrSetupError, ConnectionEntryNotFound {
        Map<String, String> conversions;
        DatabaseProvider provider = this.getProvider();
        DbTableExampleSet inputEs = new DbTableExampleSet(provider, inputs[0]);
        try {
            conversions = this.getConversions(inputEs);
        }
        catch (UserError e) {
            throw new OperatorOrSetupError().withUserError(e).withProcessSetupError(new ProcessSetupError[]{new SimpleProcessSetupError(ProcessSetupError.Severity.WARNING, this.getPortOwner(), "passthrough", new Object[]{e.getMessage()})});
        }
        ArrayList<Column> selCols = new ArrayList<Column>();
        for (Column col : inputs[0].getColumnRefs(provider)) {
            Column newCol;
            String newType = conversions.get(col.getDestCol());
            if (newType == null) {
                newCol = new Column(col.getDestCol(), col.getType());
            } else {
                if (!ConvertType.isTypeStringValid(provider, newType)) {
                    throw new OperatorOrSetupError().withProcessSetupError(new ProcessSetupError[]{new SimpleProcessSetupError(ProcessSetupError.Severity.ERROR, this.getPortOwner(), "wrong_data_type", new Object[]{newType})}).withUserError(new UserError((Operator)this, "wrong_data_type", new Object[]{newType}));
                }
                Integer newRmType = provider.getDataTypeSuggestions().get(newType);
                if (newRmType == null) {
                    newRmType = 0;
                }
                newCol = new ColumnExpr(String.format("CAST(%s AS %s)", col.toSql(provider), newType), col.getDestCol(), newRmType);
            }
            selCols.add(newCol);
        }
        return Select.builder().columns(selCols).from(inputs[0]).build();
    }

    private Map<String, String> getConversions(DbTableExampleSet inputEs) throws UserError {
        HashMap<String, String> res = new HashMap<String, String>();
        if (this.getParameterAsBoolean(PARAMETER_USE_DEFAULT_TYPE_CONVERSION)) {
            String defaultType = this.getParameterAsString(PARAMETER_DEFAULT_TYPE_CONVERSION);
            this.defaultAttributeSelector.getAttributeSubset((ExampleSet)inputEs, true).stream().map(Attribute::getName).forEach(a -> res.put((String)a, defaultType));
        }
        this.getParameterList(PARAMETER_TYPE_CONVERSIONS).forEach(e -> res.put(e[0], e[1]));
        return res;
    }

    private static boolean isTypeStringValid(DatabaseProvider provider, String typeStr) {
        return typeStr.replaceAll("[^(]", "").length() == typeStr.replaceAll("[^)]", "").length() && !typeStr.contains(provider.getEnclosingCharacter()) && !typeStr.contains(provider.getLiteralEnclosingCharacter());
    }

    private class TypeSuggestionProvider
    implements SuggestionProvider<String> {
        private TypeSuggestionProvider() {
        }

        public List<String> getSuggestions(Operator op, ProgressListener pl) {
            try {
                Nest nest = Nest.findParentNest(ConvertType.this);
                DatabaseProvider provider = nest.getProvider();
                return new ArrayList<String>(provider.getDataTypeSuggestions().keySet());
            }
            catch (NestNotFoundException | Nest.DatabaseProviderNotInitialized e) {
                LogService.getRoot().fine(() -> String.format("Failed to determine available data types: %s", e.getMessage()));
                return Collections.emptyList();
            }
        }
    }
}

