/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.indatabase.operator;

import com.rapidminer.extension.indatabase.DbTools;
import com.rapidminer.extension.indatabase.db.object.Column;
import com.rapidminer.extension.indatabase.db.object.Expression;
import com.rapidminer.extension.indatabase.db.step.Custom;
import com.rapidminer.extension.indatabase.db.step.DbStep;
import com.rapidminer.extension.indatabase.exceptions.NestNotFoundException;
import com.rapidminer.extension.indatabase.exceptions.OperatorOrSetupError;
import com.rapidminer.extension.indatabase.gui.ParameterTypeListWithAction;
import com.rapidminer.extension.indatabase.metadata.DbMetaDataTools;
import com.rapidminer.extension.indatabase.metadata.DbTableColumnMetaData;
import com.rapidminer.extension.indatabase.operator.AbstractNestedOperator;
import com.rapidminer.extension.indatabase.operator.Nest;
import com.rapidminer.extension.indatabase.provider.DatabaseProvider;
import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.tools.ProgressThread;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.SimpleProcessSetupError;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.IncompatibleMDClassException;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.InputPortExtender;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.Ports;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.table.TableMetaData;
import com.rapidminer.operator.ports.quickfix.ParameterSettingQuickFix;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.ParameterTypeStringCategory;
import com.rapidminer.parameter.ParameterTypeText;
import com.rapidminer.parameter.TextType;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.Ontology;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CustomSqlOperator
extends AbstractNestedOperator {
    private static final String SCRIPT_TEMPLATE = "SELECT t1.* \nFROM input1";
    private static final String INPUT_PLACEHOLDER = "input";
    private static final String PARAMETER_SCRIPT = "query";
    private static final String PARAMETER_METADATA = "metadata";
    private static final String PARAMETER_COLUMN = "column";
    private static final String PARAMETER_DATA_TYPE = "data_type";
    private static final Set<Integer> ATTRIBUTE_TYPE_UNUSED = new HashSet<Integer>(Arrays.asList(6, 7, 8));
    private static final String[] ATTRIBUTE_TYPE_USED = Stream.of(Ontology.VALUE_TYPE_NAMES).filter(t -> !ATTRIBUTE_TYPE_UNUSED.contains(Ontology.ATTRIBUTE_VALUE_TYPE.mapName(t))).collect(Collectors.toList()).toArray(new String[0]);
    private final InputPortExtender inputPortExtender = new InputPortExtender("example set input", (Ports)this.getInputPorts(), (MetaData)new TableMetaData(), false);
    private final OutputPort outputPort;

    public CustomSqlOperator(OperatorDescription description) {
        super(description, false);
        this.inputPortExtender.start();
        this.outputPort = (OutputPort)this.getOutputPorts().createPort("example set output");
        this.getTransformer().addRule(this::checkParametersAndPorts);
    }

    public List<ParameterType> getParameterTypes() {
        List types = super.getParameterTypes();
        Object type = new ParameterTypeText(PARAMETER_SCRIPT, "Custom SQL query to execute. The default query simply delivers the input data set on the output port. You may refer to any number of input data sets available using \"input1\", \"input2\", etc. Those strings are substituted by the input query during runtime. They get the alias \"t1\", \"t2\", respectively, that you can use in the column expressions. Note that you may need to use database specific quote characters when referring to case sensitive column names. Alternatively, you may use square brackets as well, they are automatically replaced by database specific quote characters, unless you uncheck the replace_square_brackets parameter.", TextType.SQL, SCRIPT_TEMPLATE);
        type.setPrimary(true);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeListWithAction(PARAMETER_METADATA, "Metadata that describes the expected output. As the result metadata of the custom query is not determined automatically, you can use this parameter to define the output metadata, and help configuring subsequent operators during design-time. Alternatively, hit the Read Metadata button next to the Edit List button to read the metadata from the database.", (ParameterType)new ParameterTypeString(PARAMETER_COLUMN, "Specifies the column in the result."), (ParameterType)new ParameterTypeStringCategory(PARAMETER_DATA_TYPE, "Specifies the data type of the column.", ATTRIBUTE_TYPE_USED, Ontology.VALUE_TYPE_NAMES[1]), false, new ResourceAction(true, "db.read_metadata", new Object[0]){
            private static final long serialVersionUID = 7726265949617682539L;

            protected void loggedActionPerformed(ActionEvent e) {
                ProgressThread t = new ProgressThread("db.read_metadata"){

                    public void run() {
                        try {
                            this.getProgressListener().setTotal(100);
                            this.getProgressListener().setCompleted(10);
                            try {
                                Nest nest = Nest.findParentNest(CustomSqlOperator.this);
                                CustomSqlOperator.this.setParameter(CustomSqlOperator.PARAMETER_METADATA, ParameterTypeList.transformList2String(nest.getProvider().getColumnMetaData(nest.getDbHandler(), CustomSqlOperator.this.buildDbStep(CustomSqlOperator.this.getDbStepsFromInputMD()).toSql(CustomSqlOperator.this.getProvider()))));
                            }
                            catch (OperatorOrSetupError | OperatorException | SQLException e) {
                                LogService.getRoot().warning("Could not get result metadata for the specified query: " + e.getMessage());
                            }
                            this.getProgressListener().setCompleted(50);
                            RapidMinerGUI.getMainFrame().validateProcess(true);
                        }
                        finally {
                            this.getProgressListener().complete();
                        }
                    }
                };
                t.start();
            }
        });
        types.add(type);
        type = new ParameterTypeBoolean("replace_square_brackets", "Replace square brackets. By default square brackets are replaced in function expressions by the database specific characters used for escaping special identifiers (e.g. with backticks(`) for Google BigQuery). In some situations you may not want to replace the square brackets in the expression. Uncheck this parameter to do so.", true, true);
        types.add(type);
        return types;
    }

    @Override
    public DbStep buildDbStep(DbStep ... inputs) throws UndefinedParameterError, NestNotFoundException, OperatorOrSetupError {
        List<AttributeMetaData> mdFromParameters = this.buildSpecifiedMetaData();
        List<Object> metadata = new ArrayList();
        DatabaseProvider provider = this.getProvider();
        String query = this.getSql(provider, inputs);
        if (this.isRunning()) {
            try {
                metadata = provider.getColumnMetaData(Nest.findParentNest(this).getDbHandler(), query).stream().map(a -> new Column(a[0], DbMetaDataTools.getSqlType(Ontology.ATTRIBUTE_VALUE_TYPE.mapName(a[1])))).collect(Collectors.toList());
            }
            catch (OperatorException e) {
                throw new OperatorOrSetupError().withOperatorException(e);
            }
            catch (SQLException e) {
                LogService.getRoot().warning(e.getMessage());
                throw new OperatorOrSetupError().withUserError(new UserError((Operator)this, "sql_error", new Object[]{DbTools.formatErrorMessage(e)})).withProcessSetupError(new ProcessSetupError[]{new SimpleProcessSetupError(ProcessSetupError.Severity.ERROR, this.getPortOwner(), "column_list", new Object[0])});
            }
        } else if (!mdFromParameters.isEmpty()) {
            metadata = mdFromParameters.stream().map(a -> new Column(a.getName(), DbMetaDataTools.getSqlType(a.getValueType()))).collect(Collectors.toList());
        } else if (inputs.length > 1) {
            metadata = inputs[0].getColumnRefs(provider);
        }
        return Custom.builder().sql(query).metadata(metadata).build();
    }

    private void checkParametersAndPorts() {
        DbStep[] inputs = this.getDbStepsFromInputMD();
        int inputsOnPorts = inputs.length;
        try {
            String queryKeyword;
            String query = this.getParameterAsString(PARAMETER_SCRIPT);
            for (int i = 0; i < inputsOnPorts; ++i) {
                if (query.contains(INPUT_PLACEHOLDER + (i + 1))) continue;
                this.addError((ProcessSetupError)new SimpleProcessSetupError(ProcessSetupError.Severity.WARNING, this.getPortOwner(), "custom_sql_input_unused", new Object[]{i + 1}));
            }
            if (query.contains(INPUT_PLACEHOLDER + (inputsOnPorts + 1))) {
                this.addError((ProcessSetupError)new SimpleProcessSetupError(ProcessSetupError.Severity.WARNING, this.getPortOwner(), "custom_sql_no_input", new Object[]{INPUT_PLACEHOLDER + (inputsOnPorts + 1)}));
            }
            if (!"SELECT".equals(queryKeyword = query.replace('(', ' ').trim().toUpperCase().split("\\s+")[0]) && !"WITH".equals(queryKeyword)) {
                this.addError((ProcessSetupError)new SimpleProcessSetupError(ProcessSetupError.Severity.WARNING, this.getPortOwner(), Collections.singletonList(new ParameterSettingQuickFix((Operator)this, PARAMETER_SCRIPT)), "custom_sql_select", new Object[0]));
            }
        }
        catch (UndefinedParameterError queryKeyword) {
            // empty catch block
        }
        if (this.getSpecifiedMetadata().isEmpty()) {
            this.addError((ProcessSetupError)new SimpleProcessSetupError(ProcessSetupError.Severity.WARNING, this.getPortOwner(), Collections.singletonList(new ParameterSettingQuickFix((Operator)this, PARAMETER_METADATA)), "no_metadata", new Object[0]));
        }
        TableMetaData outputMD = null;
        try {
            outputMD = DbMetaDataTools.buildTableMetaData(this.getProvider(), this.buildDbStep(inputs));
        }
        catch (NestNotFoundException | OperatorOrSetupError | UndefinedParameterError object) {
            // empty catch block
        }
        if (outputMD != null) {
            outputMD.addToHistory(this.outputPort);
            this.outputPort.deliverMD((MetaData)outputMD);
        }
    }

    private List<String[]> getSpecifiedMetadata() {
        ArrayList<String[]> metadata;
        try {
            metadata = this.getParameterList(PARAMETER_METADATA);
        }
        catch (UndefinedParameterError e) {
            metadata = new ArrayList<String[]>();
        }
        return metadata;
    }

    private List<AttributeMetaData> buildSpecifiedMetaData() {
        ArrayList<AttributeMetaData> res = new ArrayList<AttributeMetaData>();
        List<String[]> metadata = this.getSpecifiedMetadata();
        for (String[] p : metadata) {
            AttributeMetaData amd = new AttributeMetaData(p[0], Ontology.ATTRIBUTE_VALUE_TYPE.mapName(p[1]));
            amd.setNumberOfMissingValues(DbTableColumnMetaData.UNKNOWN_MDINTEGER);
            res.add(amd);
        }
        return res;
    }

    private DbStep[] getDbStepsFromInputMD() {
        ArrayList<DbStep> inputs = new ArrayList<DbStep>();
        for (InputPort i : this.getInputPorts().getAllPorts()) {
            try {
                TableMetaData m = (TableMetaData)i.getMetaData(TableMetaData.class);
                if (m == null) continue;
                inputs.add(DbMetaDataTools.readColumnMetaData(m).getDbStep());
            }
            catch (IncompatibleMDClassException incompatibleMDClassException) {}
        }
        return inputs.toArray(new DbStep[0]);
    }

    private String getSql(DatabaseProvider provider, DbStep ... inputs) throws UndefinedParameterError {
        String sql = this.getParameterAsString(PARAMETER_SCRIPT);
        boolean replacingSquareBrackets = this.getParameterAsBoolean("replace_square_brackets");
        for (int i = 0; i < inputs.length; ++i) {
            sql = sql.replace(INPUT_PLACEHOLDER + (i + 1), String.format("(%s) %s", inputs[i].toSql(provider), "t" + (i + 1)));
        }
        sql = new Expression(sql, replacingSquareBrackets).toSql(provider);
        return sql;
    }
}

