/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.indatabase.operator;

import com.rapidminer.extension.indatabase.db.object.Column;
import com.rapidminer.extension.indatabase.db.object.ColumnExpr;
import com.rapidminer.extension.indatabase.db.step.DbStep;
import com.rapidminer.extension.indatabase.db.step.Select;
import com.rapidminer.extension.indatabase.exceptions.NestNotFoundException;
import com.rapidminer.extension.indatabase.exceptions.OperatorOrSetupError;
import com.rapidminer.extension.indatabase.gui.ParameterTypeDbExpression;
import com.rapidminer.extension.indatabase.metadata.DbMetaDataTools;
import com.rapidminer.extension.indatabase.operator.AbstractFilteredProcessing;
import com.rapidminer.extension.indatabase.provider.DatabaseProvider;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.Port;
import com.rapidminer.operator.ports.metadata.MetaDataError;
import com.rapidminer.operator.ports.metadata.SimpleMetaDataError;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.EqualTypeCondition;
import com.rapidminer.parameter.conditions.ParameterCondition;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DeclareMissing
extends AbstractFilteredProcessing {
    private static final String[] VALUE_TYPES = Stream.of(ValueTypes.values()).map(Enum::name).map(String::toLowerCase).collect(Collectors.toList()).toArray(new String[0]);

    public DeclareMissing(OperatorDescription description) {
        super(description);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> parameters = super.getParameterTypes();
        Object type = new ParameterTypeCategory("mode", "Select the value type of the missing value", VALUE_TYPES, 0);
        type.setExpert(false);
        parameters.add((ParameterType)type);
        type = new ParameterTypeDouble("numeric_value", "This parameter defines the missing numerical value", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, true);
        type.registerDependencyCondition((ParameterCondition)new EqualTypeCondition((ParameterHandler)this, "mode", VALUE_TYPES, true, new int[]{0}));
        type.setExpert(false);
        parameters.add((ParameterType)type);
        type = new ParameterTypeString("nominal_value", "This parameter defines the missing nominal value", true, false);
        type.registerDependencyCondition((ParameterCondition)new EqualTypeCondition((ParameterHandler)this, "mode", VALUE_TYPES, false, new int[]{1}));
        type.setExpert(false);
        parameters.add((ParameterType)type);
        type = new ParameterTypeDbExpression("expression_value", "This parameter defines the expression which if true equals the missing value", this.getInputPort(), true, false);
        type.registerDependencyCondition((ParameterCondition)new EqualTypeCondition((ParameterHandler)this, "mode", VALUE_TYPES, true, new int[]{2}));
        type.setExpert(false);
        type.setPrimary(true);
        parameters.add((ParameterType)type);
        return parameters;
    }

    @Override
    public DbStep buildDbStepOnFilteredColumns(Set<String> columnSubset, DbStep input) throws OperatorOrSetupError, NestNotFoundException, UndefinedParameterError {
        DatabaseProvider provider = this.getProvider();
        ArrayList<Column> selectCols = new ArrayList<Column>();
        ValueTypes mode = ValueTypes.valueOf(this.getParameterAsString("mode").toUpperCase());
        boolean typeExistsInSubset = false;
        for (Column col : input.getColumnRefs(provider)) {
            if (!columnSubset.contains(col.getDestCol()) || !DeclareMissing.columnTypeMatchesMode(col, mode)) {
                selectCols.add(col);
                continue;
            }
            typeExistsInSubset = true;
            String condition = this.getCondition(provider, col, mode);
            selectCols.add(new ColumnExpr(String.format("CASE WHEN %s THEN NULL ELSE %s END", condition, col.toSql(provider)), col.getDestCol(), col.getType()));
        }
        if (!typeExistsInSubset && !this.isRunning()) {
            if (mode == ValueTypes.NUMERIC) {
                this.getInputPort().addError((MetaDataError)new SimpleMetaDataError(ProcessSetupError.Severity.ERROR, (Port)this.getInputPort(), "exampleset.must_contain_numerical_attribute", new Object[0]));
            } else if (mode == ValueTypes.NOMINAL) {
                this.getInputPort().addError((MetaDataError)new SimpleMetaDataError(ProcessSetupError.Severity.ERROR, (Port)this.getInputPort(), "exampleset.must_contain_nominal_attribute", new Object[0]));
            }
        }
        return Select.builder().columns(selectCols).from(input).build();
    }

    private static boolean columnTypeMatchesMode(Column col, ValueTypes mode) {
        int colType = DbMetaDataTools.getRapidMinerTypeIndex(col.getType());
        if (colType == 0) {
            return true;
        }
        if (mode == ValueTypes.NUMERIC) {
            switch (colType) {
                case 2: 
                case 3: 
                case 4: {
                    return true;
                }
            }
        } else if (mode == ValueTypes.NOMINAL) {
            switch (colType) {
                case 1: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    return true;
                }
            }
        } else if (mode == ValueTypes.EXPRESSION) {
            return true;
        }
        return false;
    }

    private String getCondition(DatabaseProvider provider, Column col, ValueTypes mode) throws UndefinedParameterError, OperatorOrSetupError {
        return switch (mode) {
            case ValueTypes.NUMERIC -> String.format("%s = %s", col.toSql(provider), String.valueOf(this.getParameterAsDouble("numeric_value")));
            case ValueTypes.NOMINAL -> String.format("%s = %s", col.toSql(provider), provider.literal(this.getParameterAsString("nominal_value")));
            case ValueTypes.EXPRESSION -> this.getParameterAsString("expression_value");
            default -> throw new OperatorOrSetupError().withUserError(new UserError((Operator)this, 116, new Object[]{"mode", String.valueOf((Object)mode)}));
        };
    }

    private static enum ValueTypes {
        NUMERIC,
        NOMINAL,
        EXPRESSION;

    }
}

