/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.indatabase.operator;

import com.rapidminer.MacroHandler;
import com.rapidminer.example.AttributeTypeException;
import com.rapidminer.example.set.CustomFilter;
import com.rapidminer.extension.indatabase.DbTools;
import com.rapidminer.extension.indatabase.db.object.Column;
import com.rapidminer.extension.indatabase.db.object.Expression;
import com.rapidminer.extension.indatabase.db.step.DbStep;
import com.rapidminer.extension.indatabase.db.step.Filter;
import com.rapidminer.extension.indatabase.exceptions.ConnectionEntryNotFound;
import com.rapidminer.extension.indatabase.exceptions.NestNotFoundException;
import com.rapidminer.extension.indatabase.exceptions.OperatorOrSetupError;
import com.rapidminer.extension.indatabase.gui.ParameterTypeDbExpression;
import com.rapidminer.extension.indatabase.metadata.DbMetaDataTools;
import com.rapidminer.extension.indatabase.operator.AbstractNestedOperator;
import com.rapidminer.extension.indatabase.provider.DatabaseProvider;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.SimpleProcessSetupError;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.quickfix.ParameterSettingQuickFix;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeFilter;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.ParameterTypeStringCategory;
import com.rapidminer.parameter.ParameterTypeTupel;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.EqualStringCondition;
import com.rapidminer.parameter.conditions.ParameterCondition;
import com.rapidminer.tools.I18N;
import com.rapidminer.tools.Ontology;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;

public class FilterOperator
extends AbstractNestedOperator {
    private static final String[] FILTER_TYPES = new String[]{"expression", "custom_filters"};
    public static final int INDEX_CONDITION_EXPRESSION = 0;
    public static final int INDEX_CONDITION_CUSTOM_FILTER = 1;
    private static final int CONDITION_ARRAY_REQUIRED_SIZE = 2;
    private static final int CONDITION_ARRAY_CONDITION_INDEX = 1;
    private static final int CONDITION_TUPEL_REQUIRED_SIZE = 3;
    private static final int CONDITION_TUPEL_ATT_INDEX = 0;
    private static final int CONDITION_TUPEL_FILTER_INDEX = 1;
    private static final int CONDITION_TUPEL_VALUE_INDEX = 2;
    private static final String DESCRIPTION_EXPRESSION = "Parameter string for the expression, e.g. 'attribute1 = attribute2'. Put identifiers containing reserved keywords or special characters into square brackets ([]). The square brackets will be replaced by database specific escaping characters (e.g. backticks(`) for Google BigQuery). Uncheck the 'replace square brackets' parameter to disable replacement.";
    private static final String PARAMETER_REPLACE_SQUARE_BRACKETS = "replace_square_brackets";
    private static final String DESCRIPTION_REPLACE_SQUARE_BRACKETS = "Replace square brackets. By default square brackets are replaced by the database specific characters used for escaping special identifiers (e.g. with backticks(`) for Google BigQuery). In some situations you may not want to replace the square brackets in the expression. Uncheck this parameter to do so.";

    public FilterOperator(OperatorDescription description) {
        super(description, true);
    }

    public List<ParameterType> getParameterTypes() {
        List types = super.getParameterTypes();
        Object type = new ParameterTypeStringCategory("condition_class", "Implementation of the condition.", FILTER_TYPES, FILTER_TYPES[1], false);
        type.setExpert(true);
        types.add(type);
        type = new ParameterTypeFilter("filters", "Defines the list of filters to apply.", this.getInputPort(), true);
        type.registerDependencyCondition((ParameterCondition)new EqualStringCondition((ParameterHandler)this, "condition_class", false, new String[]{FILTER_TYPES[1]}));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDbExpression("parameter_expression", DESCRIPTION_EXPRESSION, this.getInputPort(), true);
        type.registerDependencyCondition((ParameterCondition)new EqualStringCondition((ParameterHandler)this, "condition_class", true, new String[]{FILTER_TYPES[0]}));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeBoolean(PARAMETER_REPLACE_SQUARE_BRACKETS, DESCRIPTION_REPLACE_SQUARE_BRACKETS, true, true);
        type.registerDependencyCondition((ParameterCondition)new EqualStringCondition((ParameterHandler)this, "condition_class", true, new String[]{FILTER_TYPES[0]}));
        type.setExpert(true);
        types.add(type);
        type = new ParameterTypeList("filters_list", "The list of filters.", (ParameterType)new ParameterTypeString("PARAMETER_FILTERS_ENTRY_KEY", "A key entry of the filters list."), (ParameterType)new ParameterTypeString("PARAMETER_FILTERS_ENTRY_VALUE", "A value entry of the filters list."), false);
        type.setHidden(true);
        types.add(type);
        type = new ParameterTypeBoolean("filters_logic_and", "Logic operator for filters.", true, false);
        type.setHidden(true);
        types.add(type);
        type = new ParameterTypeBoolean("filters_check_metadata", "Check meta data for comparators.", true, false);
        type.setHidden(true);
        types.add(type);
        return types;
    }

    @Override
    public DbStep buildDbStep(DbStep ... inputs) throws UndefinedParameterError, OperatorOrSetupError, NestNotFoundException, ConnectionEntryNotFound {
        if (FILTER_TYPES[0].equals(this.getParameter("condition_class"))) {
            String expression = this.getParameterAsString("parameter_expression");
            if (expression == null || expression.isEmpty()) {
                throw new OperatorOrSetupError().withUserError(new UserError((Operator)this, 205, new Object[]{"parameter_expression", ""})).withProcessSetupError(new ProcessSetupError[]{new SimpleProcessSetupError(ProcessSetupError.Severity.ERROR, this.getPortOwner(), Collections.singletonList(new ParameterSettingQuickFix((Operator)this, "parameter_expression")), "undefined_parameter", new Object[]{"parameter_expression"})});
            }
            boolean replaceSquareBrackets = this.getParameterAsBoolean(PARAMETER_REPLACE_SQUARE_BRACKETS);
            return Filter.builder().from(inputs[0]).where(new Expression(expression, replaceSquareBrackets)).build();
        }
        if (FILTER_TYPES[1].equals(this.getParameter("condition_class"))) {
            try {
                return Filter.builder().from(inputs[0]).filters(this.buildFilterRows(this.getProvider(), inputs[0])).and(this.getParameterAsBoolean("filters_logic_and")).build();
            }
            catch (AttributeTypeException e) {
                throw new OperatorOrSetupError().withUserError(new UserError((Operator)this, (Throwable)e, "filter_wrong_type", new Object[]{e.getMessage()})).withCustomError((Exception)((Object)e), this.getPortOwner(), Collections.singletonList(new ParameterSettingQuickFix((Operator)this, "filters")));
            }
            catch (IllegalArgumentException e) {
                throw new OperatorOrSetupError().withUserError(new UserError((Operator)this, (Throwable)e, "custom_filters", new Object[]{e.getMessage()})).withCustomError(e, this.getPortOwner(), Collections.singletonList(new ParameterSettingQuickFix((Operator)this, "filters")));
            }
        }
        return inputs[0];
    }

    private List<Filter.FilterRow> buildFilterRows(DatabaseProvider provider, DbStep input) throws OperatorOrSetupError {
        ArrayList<Filter.FilterRow> res = new ArrayList<Filter.FilterRow>();
        HashMap inputCols = new HashMap();
        input.getColumnRefs(provider).forEach(c -> inputCols.put(c.getDestCol(), c));
        HashMap attrTypes = new HashMap();
        input.getColumns(provider).forEach(c -> attrTypes.put(c.getDestCol(), DbMetaDataTools.getRapidMinerTypeIndex(c.getType())));
        MacroHandler macroHandler = this.getProcess().getMacroHandler();
        String rawParameterString = this.getParameters().getParameterAsSpecified("filters_list");
        if (rawParameterString == null) {
            throw new OperatorOrSetupError().withUserError((UserError)((Object)new UndefinedParameterError("filters", (Operator)this))).withProcessSetupError(new ProcessSetupError[]{new SimpleProcessSetupError(ProcessSetupError.Severity.ERROR, this.getPortOwner(), Collections.singletonList(new ParameterSettingQuickFix((Operator)this, "filters")), "parameter_list_undefined", new Object[]{"filters".replace('_', ' ')})});
        }
        List conditions = ParameterTypeList.transformString2List((String)rawParameterString);
        if (conditions == null) {
            throw new IllegalArgumentException("typeList must not be null!");
        }
        if (conditions.isEmpty()) {
            throw new OperatorOrSetupError().withUserError(new UserError((Operator)this, "custom_filters_empty")).withProcessSetupError(new ProcessSetupError[]{new SimpleProcessSetupError(ProcessSetupError.Severity.ERROR, this.getPortOwner(), Collections.singletonList(new ParameterSettingQuickFix((Operator)this, "filters")), "parameter_list_undefined", new Object[]{"filters".replace('_', ' ')})});
        }
        for (String[] conditionArray : conditions) {
            if (conditionArray.length != 2) {
                throw new IllegalArgumentException("conditions must only consist of arrays of length 2!");
            }
            String condition = conditionArray[1];
            String[] conditionTupel = ParameterTypeTupel.transformString2Tupel((String)condition);
            if (conditionTupel.length != 3) {
                throw new IllegalArgumentException("Malformed condition tupels! Expected size 3 but was " + conditionTupel.length);
            }
            String attName = conditionTupel[0];
            if (!attrTypes.containsKey(attName)) {
                throw new IllegalArgumentException(I18N.getMessageOrNull((ResourceBundle)I18N.getErrorBundle(), (String)"custom_filters.attribute_not_found", (Object[])new Object[]{attName}));
            }
            int attrType = (Integer)attrTypes.get(attName);
            String filterSymbol = conditionTupel[1];
            CustomFilter.CustomFilters filter = CustomFilter.CustomFilters.getBySymbol((String)filterSymbol);
            String filterValue = conditionTupel[2];
            if (macroHandler != null) {
                filterValue = FilterOperator.substituteMacros(filterValue, macroHandler);
            }
            if (filterValue != null && filterValue.contains(String.valueOf(Double.POSITIVE_INFINITY))) {
                throw new OperatorOrSetupError().withProcessSetupError(new ProcessSetupError[]{new SimpleProcessSetupError(ProcessSetupError.Severity.ERROR, this.getPortOwner(), "custom_filter_infinity", new Object[0])});
            }
            if (filter == null) {
                throw new IllegalArgumentException(I18N.getMessageOrNull((ResourceBundle)I18N.getErrorBundle(), (String)"custom_filters.filter_not_found", (Object[])new Object[]{filterSymbol}));
            }
            if (filter.isNumericalFilter()) {
                if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(attrType, 1)) {
                    throw new AttributeTypeException(I18N.getMessageOrNull((ResourceBundle)I18N.getErrorBundle(), (String)"custom_filters.numerical_comparator_type_invalid", (Object[])new Object[]{filter.getLabel(), attrType}));
                }
                if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(attrType, 9)) {
                    if (filterValue == null || "".equals(filterValue)) {
                        throw new IllegalArgumentException(DbTools.notValidDateErrorMessage(provider, attrType, filterValue, attName));
                    }
                } else if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(attrType, 2) && (filterValue == null || "".equals(filterValue) || !this.isStringValidDoubleValue(filter, filterValue, attrType))) {
                    throw new IllegalArgumentException(I18N.getMessageOrNull((ResourceBundle)I18N.getErrorBundle(), (String)"custom_filters.illegal_numerical_value", (Object[])new Object[]{filterValue, attName}));
                }
            } else if (filter.isNominalFilter() && attrType != 0 && !Ontology.ATTRIBUTE_VALUE_TYPE.isA(attrType, 1)) {
                throw new AttributeTypeException(I18N.getMessageOrNull((ResourceBundle)I18N.getErrorBundle(), (String)"custom_filters.nominal_comparator_type_invalid", (Object[])new Object[]{filter.getLabel(), attName}));
            }
            res.add(new Filter.FilterRow((Column)inputCols.get(attName), Filter.FilterCondition.valueOf(filterSymbol.toUpperCase()), filterValue));
        }
        return res;
    }

    private boolean isStringValidDoubleValue(CustomFilter.CustomFilters filter, String value, int attrType) {
        try {
            Double.parseDouble(value);
        }
        catch (NumberFormatException e1) {
            if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(attrType, 10)) {
                if (filter.parseDate(value) == null) {
                    return false;
                }
            }
            if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(attrType, 11)) {
                if (filter.parseTime(value) == null) {
                    return false;
                }
            }
            if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(attrType, 9)) {
                if (filter.parseDateTime(value) == null) {
                    return false;
                }
            }
            return "?".equals(value);
        }
        return true;
    }

    private static String substituteMacros(String value, MacroHandler macroHandler) {
        int startIndex = value.indexOf("%{");
        if (startIndex == -1) {
            return value;
        }
        try {
            StringBuffer result = new StringBuffer();
            while (startIndex >= 0) {
                result.append(value.substring(0, startIndex));
                int endIndex = value.indexOf("}", startIndex + 2);
                String macroString = value.substring(startIndex + 2, endIndex);
                String macroValue = macroHandler.getMacro(macroString);
                if (macroValue != null) {
                    result.append(macroValue);
                } else {
                    result.append("%{" + macroString + "}");
                }
                value = value.substring(endIndex + 1);
                startIndex = value.indexOf("%{");
            }
            result.append(value);
            return result.toString();
        }
        catch (Exception e) {
            return value;
        }
    }
}

