/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.indatabase.operator;

import com.rapidminer.extension.indatabase.db.object.Column;
import com.rapidminer.extension.indatabase.db.object.ColumnExpr;
import com.rapidminer.extension.indatabase.db.object.Expression;
import com.rapidminer.extension.indatabase.db.step.DbStep;
import com.rapidminer.extension.indatabase.db.step.Select;
import com.rapidminer.extension.indatabase.exceptions.ConnectionEntryNotFound;
import com.rapidminer.extension.indatabase.exceptions.NestNotFoundException;
import com.rapidminer.extension.indatabase.exceptions.OperatorOrSetupError;
import com.rapidminer.extension.indatabase.gui.ParameterTypeDbExpression;
import com.rapidminer.extension.indatabase.operator.AbstractNestedOperator;
import com.rapidminer.extension.indatabase.provider.DatabaseProvider;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.SimpleProcessSetupError;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.quickfix.ParameterSettingQuickFix;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.UndefinedParameterError;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Stream;

public class GenerateAttributes
extends AbstractNestedOperator {
    public static final String PARAMETER_REPLACE_SQUARE_BRACKETS = "replace_square_brackets";
    public static final String DESCRIPTION_REPLACE_SQUARE_BRACKETS = "Replace square brackets. By default square brackets are replaced in function expressions by the database specific characters used for escaping special identifiers (e.g. with backticks(`) for Google BigQuery). In some situations you may not want to replace the square brackets in the expression. Uncheck this parameter to do so.";

    public GenerateAttributes(OperatorDescription description) {
        super(description, true);
    }

    public List<ParameterType> getParameterTypes() {
        List types = super.getParameterTypes();
        ParameterTypeList type = new ParameterTypeList("function_descriptions", "List of attributes to generate. You can both create new attributes, as well as overwrite existing ones. The second parameter in each row defines the expression that generate the value of the attribute. You can use other attributes, macros and database-specific operators and functions in these expressions. Use brackets ([]) around attributes (columns) that will automatically be replaced by db-specific quote characters to make sure that lowercase/uppercase and special characters are handled properly.", (ParameterType)new ParameterTypeString("attribute_name", "Specifies the name of the constructed attribute"), (ParameterType)new ParameterTypeDbExpression("function_expressions", "Expression to use for generation. Note that you need to use database-specific syntax here.", this.getInputPort()));
        type.setExpert(false);
        type.setPrimary(true);
        types.add(type);
        types.add(new ParameterTypeBoolean("keep_all", "If set to true, all the original attributes are kept, otherwise they are removed from the example set.", true));
        type = new ParameterTypeBoolean(PARAMETER_REPLACE_SQUARE_BRACKETS, DESCRIPTION_REPLACE_SQUARE_BRACKETS, true, true);
        types.add(type);
        return types;
    }

    @Override
    public DbStep buildDbStep(DbStep ... inputs) throws UndefinedParameterError, NestNotFoundException, ConnectionEntryNotFound, OperatorOrSetupError {
        if (this.getParameterList("function_descriptions").isEmpty() && !this.getParameterAsBoolean("keep_all")) {
            throw new OperatorOrSetupError().withUserError(new UserError((Operator)this, "generate_attributes.empty")).withProcessSetupError(new ProcessSetupError[]{new SimpleProcessSetupError(ProcessSetupError.Severity.ERROR, this.getPortOwner(), Collections.singletonList(new ParameterSettingQuickFix((Operator)this, "function_descriptions")), "generate_attributes.empty", new Object[0])});
        }
        return Select.builder().columns(this.buildColumnExpressions(inputs[0])).from(inputs[0]).build();
    }

    private List<Column> buildColumnExpressions(DbStep input) throws UndefinedParameterError, NestNotFoundException, OperatorOrSetupError {
        LinkedHashMap exprs = new LinkedHashMap();
        boolean replacingSquareBrackets = this.getParameterAsBoolean(PARAMETER_REPLACE_SQUARE_BRACKETS);
        this.getParameterList("function_descriptions").forEach(p -> exprs.put(p[0], new Expression(p[1], replacingSquareBrackets)));
        boolean keepAll = this.getParameterAsBoolean("keep_all");
        ArrayList<Column> res = new ArrayList<Column>();
        if (!this.isRunning() && replacingSquareBrackets) {
            DatabaseProvider provider = this.getProvider();
            String quote = provider.getEnclosingCharacter();
            if (exprs.values().stream().anyMatch(expr -> expr.getExpression().indexOf(quote) != expr.getExpression().lastIndexOf(quote))) {
                this.addError((ProcessSetupError)new SimpleProcessSetupError(ProcessSetupError.Severity.WARNING, this.getPortOwner(), "quoted_expression", new Object[]{provider.getLiteralEnclosingCharacter()}));
            }
        }
        input.getColumnRefs(this.getProvider()).stream().flatMap(c -> {
            if (exprs.containsKey(c.getDestCol())) {
                Stream<ColumnExpr> colExpr = Stream.of(new ColumnExpr((Expression)exprs.get(c.getDestCol()), c.getDestCol()));
                exprs.remove(c.getDestCol());
                return colExpr;
            }
            if (keepAll) {
                return Stream.of(c);
            }
            return Stream.empty();
        }).forEachOrdered(res::add);
        exprs.entrySet().forEach(e -> res.add(new ColumnExpr((Expression)e.getValue(), (String)e.getKey())));
        return res;
    }
}

