/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.indatabase.operator;

import com.rapidminer.extension.indatabase.db.object.AnalyticFunctionExpr;
import com.rapidminer.extension.indatabase.db.object.Column;
import com.rapidminer.extension.indatabase.db.step.DbStep;
import com.rapidminer.extension.indatabase.db.step.Select;
import com.rapidminer.extension.indatabase.db.step.Sort;
import com.rapidminer.extension.indatabase.exceptions.ConnectionEntryNotFound;
import com.rapidminer.extension.indatabase.exceptions.NestNotFoundException;
import com.rapidminer.extension.indatabase.exceptions.OperatorOrSetupError;
import com.rapidminer.extension.indatabase.operator.AbstractNestedOperator;
import com.rapidminer.extension.indatabase.provider.DatabaseProvider;
import com.rapidminer.gui.tools.VersionNumber;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorVersion;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.UndefinedParameterSetupError;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.error.AttributeNotFoundError;
import com.rapidminer.operator.ports.Port;
import com.rapidminer.operator.ports.metadata.MetaDataError;
import com.rapidminer.operator.ports.metadata.SimpleMetaDataError;
import com.rapidminer.operator.ports.quickfix.ParameterSettingQuickFix;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeAttribute;
import com.rapidminer.parameter.ParameterTypeAttributes;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.UndefinedParameterError;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class GenerateRank
extends AbstractNestedOperator {
    public static final String PARAMETER_ATTRIBUTE_NAME = "attribute_name";
    public static final String PARAMETER_PARTITION_BY = "partition_by";
    public static final String PARAMETER_ORDER_BY = "order_by";
    public static final String PARAMETER_SORT_ATTRIBUTE = "sort_attribute";
    public static final String PARAMETER_SORT_DIRECTION = "sort_direction";
    public static final String PARAMETER_DENSE_RANK = "dense_rank";
    public static final String DIRECTION_ASCENDING = "ascending";
    public static final int DIRECTION_ASCENDING_INDEX = 0;
    public static final String DIRECTION_DESCENDING = "descending";
    public static final int DIRECTION_DESCENDING_INDEX = 1;
    public static final String ATTRIBUTE_SEPARATOR_REGEX = "\\|";
    public static final String[] SORT_DIRECTIONS_VALUES = new String[]{"ascending", "descending"};
    private static OperatorVersion VERSION_RANK_DATA_TYPE_REAL = new OperatorVersion(10, 2, 0);

    public GenerateRank(OperatorDescription description) {
        super(description, true);
    }

    public List<ParameterType> getParameterTypes() {
        List parameterTypes = super.getParameterTypes();
        ParameterTypeString attributeName = new ParameterTypeString(PARAMETER_ATTRIBUTE_NAME, "Name of the attribute.", false, false);
        attributeName.setPrimary(true);
        parameterTypes.add(attributeName);
        ParameterTypeAttributes partitionBy = new ParameterTypeAttributes(PARAMETER_PARTITION_BY, "Ordered list of the partitioning attributes.", this.getInputPort(), true, false);
        parameterTypes.add(partitionBy);
        ParameterTypeList orderBy = new ParameterTypeList(PARAMETER_ORDER_BY, "The attributes and sorting directions which should be used to determine the order of the data before the ranking is applied.", (ParameterType)new ParameterTypeAttribute(PARAMETER_SORT_ATTRIBUTE, "The name of the attribute.", this.getInputPort(), false), (ParameterType)new ParameterTypeCategory(PARAMETER_SORT_DIRECTION, "The direction of sorting.", SORT_DIRECTIONS_VALUES, 0, false), false);
        parameterTypes.add(orderBy);
        ParameterTypeBoolean denseRank = new ParameterTypeBoolean(PARAMETER_DENSE_RANK, "Dense Rank returns the rank of rows, within the partition of a result set, without any gaps in the ranking.", false, true);
        parameterTypes.add(denseRank);
        return parameterTypes;
    }

    @Override
    public DbStep buildDbStep(DbStep ... inputs) throws UndefinedParameterError, NestNotFoundException, ConnectionEntryNotFound, OperatorOrSetupError {
        DatabaseProvider provider = this.getProvider();
        String function = this.getParameterAsBoolean(PARAMETER_DENSE_RANK) ? "DENSE_RANK" : "RANK";
        String attributeName = this.getParameterAsString(PARAMETER_ATTRIBUTE_NAME);
        LinkedHashMap<String, Column> inputCols = new LinkedHashMap<String, Column>();
        inputs[0].getColumnRefs(provider).forEach(c -> inputCols.put(c.getDestCol(), (Column)c));
        ArrayList partitionKeys = new ArrayList();
        List<Column> partitionBy = Stream.of(this.getParameterAsString(PARAMETER_PARTITION_BY).split(ATTRIBUTE_SEPARATOR_REGEX)).filter(a -> {
            if (!a.isEmpty()) {
                partitionKeys.add(a);
            }
            return !a.isEmpty() && inputCols.containsKey(a);
        }).map(inputCols::get).collect(Collectors.toList());
        for (String key : partitionKeys) {
            if (inputCols.containsKey(key)) continue;
            throw new OperatorOrSetupError().withUserError((UserError)new AttributeNotFoundError((Operator)this, PARAMETER_PARTITION_BY, key)).withMetaDataError(new MetaDataError[]{new SimpleMetaDataError(ProcessSetupError.Severity.WARNING, (Port)this.getInputPort(), Collections.singletonList(new ParameterSettingQuickFix((Operator)this, PARAMETER_PARTITION_BY)), "missing_attribute", new Object[]{key})});
        }
        ArrayList<Sort.SortColumn> orderBy = new ArrayList<Sort.SortColumn>();
        List orderColumns = this.getParameterList(PARAMETER_ORDER_BY);
        if (orderColumns.isEmpty()) {
            throw new OperatorOrSetupError().withUserError(new UserError((Operator)this, 205, new Object[]{PARAMETER_ORDER_BY, ""})).withProcessSetupError(new ProcessSetupError[]{new UndefinedParameterSetupError((Operator)this, PARAMETER_ORDER_BY)});
        }
        for (String[] c2 : orderColumns) {
            if (inputCols.containsKey(c2[0])) continue;
            throw new OperatorOrSetupError().withUserError((UserError)new AttributeNotFoundError((Operator)this, PARAMETER_SORT_ATTRIBUTE, c2[0])).withMetaDataError(new MetaDataError[]{new SimpleMetaDataError(ProcessSetupError.Severity.WARNING, (Port)this.getInputPort(), Collections.singletonList(new ParameterSettingQuickFix((Operator)this, PARAMETER_ORDER_BY)), "missing_attribute", new Object[]{c2[0]})});
        }
        orderColumns.forEach(e -> orderBy.add(new Sort.SortColumn((Column)inputCols.get(e[0]), e[1].equals(DIRECTION_ASCENDING) ? Sort.SortType.ASCENDING : Sort.SortType.DESCENDING)));
        ArrayList<Column> finalColumns = new ArrayList<Column>();
        inputCols.forEach((k, v) -> finalColumns.add((Column)v));
        int rankColumnType = this.getCompatibilityLevel().isAtMost((VersionNumber)VERSION_RANK_DATA_TYPE_REAL) ? 3 : provider.getRankFunctionReturnType();
        finalColumns.add(((AnalyticFunctionExpr.AnalyticFunctionExprBuilder)((AnalyticFunctionExpr.AnalyticFunctionExprBuilder)((AnalyticFunctionExpr.AnalyticFunctionExprBuilder)((AnalyticFunctionExpr.AnalyticFunctionExprBuilder)((AnalyticFunctionExpr.AnalyticFunctionExprBuilder)AnalyticFunctionExpr.builder().destCol(attributeName)).type(rankColumnType)).function(function)).partitionBy(partitionBy)).sortBy(orderBy)).build());
        return Select.builder().from(inputs[0]).columns(finalColumns).build();
    }

    public OperatorVersion[] getIncompatibleVersionChanges() {
        ArrayList<OperatorVersion> res = new ArrayList<OperatorVersion>();
        res.addAll(Arrays.asList(super.getIncompatibleVersionChanges()));
        res.add(VERSION_RANK_DATA_TYPE_REAL);
        return res.toArray(new OperatorVersion[0]);
    }
}

