/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.indatabase.operator;

import com.rapidminer.extension.concurrency.operator.preprocessing.join.BeltTableJoin;
import com.rapidminer.extension.indatabase.db.step.DbStep;
import com.rapidminer.extension.indatabase.db.step.Join;
import com.rapidminer.extension.indatabase.exceptions.ConnectionEntryNotFound;
import com.rapidminer.extension.indatabase.exceptions.NestNotFoundException;
import com.rapidminer.extension.indatabase.exceptions.OperatorOrSetupError;
import com.rapidminer.extension.indatabase.metadata.DbMetaDataTools;
import com.rapidminer.extension.indatabase.metadata.DbTableColumnMetaData;
import com.rapidminer.extension.indatabase.operator.AbstractNestedOperator;
import com.rapidminer.extension.indatabase.provider.DatabaseProvider;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.SimpleProcessSetupError;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.Port;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.MetaDataError;
import com.rapidminer.operator.ports.metadata.SimpleMetaDataError;
import com.rapidminer.operator.ports.metadata.table.TableMetaData;
import com.rapidminer.operator.ports.metadata.table.TableUnionRule;
import com.rapidminer.operator.ports.quickfix.ParameterSettingQuickFix;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeAttribute;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.Ontology;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Stream;

public class JoinOperator
extends AbstractNestedOperator {
    private static final String LEFT_EXAMPLE_SET_INPUT = "left";
    private static final String RIGHT_EXAMPLE_SET_INPUT = "right";
    private InputPort leftInput = this.createInputPortWithPrecondition("left");
    private InputPort rightInput = this.createInputPortWithPrecondition("right");
    private OutputPort joinOutput = (OutputPort)this.getOutputPorts().createPort("join");

    public JoinOperator(OperatorDescription description) {
        super(description, false);
        this.getTransformer().addRule((MDTransformationRule)new TableUnionRule(this.leftInput, this.rightInput, this.joinOutput, "_from_es2"){

            protected String getPostfix() {
                return JoinOperator.this.getParameterAsBoolean("remove_double_attributes") ? null : "_from_es2";
            }

            protected TableMetaData modifyMetaData(TableMetaData leftMD, TableMetaData rightMD) {
                DbTableColumnMetaData leftDbcmd = DbMetaDataTools.readColumnMetaData(leftMD);
                DbTableColumnMetaData rightDbcmd = DbMetaDataTools.readColumnMetaData(rightMD);
                TableMetaData defaultOutput = new TableMetaData();
                if (leftDbcmd != null && rightDbcmd != null) {
                    try {
                        DbStep dbStep = JoinOperator.this.buildDbStep(leftDbcmd.getDbStep(), rightDbcmd.getDbStep());
                        TableMetaData md = DbMetaDataTools.buildTableMetaData(JoinOperator.this.getProvider(), dbStep);
                        md.addToHistory(JoinOperator.this.getOutputPort());
                        return md;
                    }
                    catch (ConnectionEntryNotFound | NestNotFoundException | UndefinedParameterError e) {
                        return defaultOutput;
                    }
                    catch (OperatorOrSetupError e) {
                        e.addSetupError(JoinOperator.this);
                        return defaultOutput;
                    }
                }
                return defaultOutput;
            }
        });
    }

    @Override
    protected OutputPort getOutputPort() {
        return this.joinOutput;
    }

    public List<ParameterType> getParameterTypes() {
        List types = super.getParameterTypes();
        types.add(new ParameterTypeBoolean("remove_double_attributes", "Indicates if double attributes should be removed or renamed", true));
        types.add(new ParameterTypeCategory("join_type", "Specifies which join should be executed.", BeltTableJoin.JOIN_TYPES, 0, false));
        ParameterTypeList joinAttributes = new ParameterTypeList("key_attributes", "The attributes which shall be used for join. Attributes which shall be matched must be of the same type.", (ParameterType)new ParameterTypeAttribute("left_key_attributes", "The attribute in the left example set to be used for the join.", (InputPort)this.getInputPorts().getPortByName(LEFT_EXAMPLE_SET_INPUT), true), (ParameterType)new ParameterTypeAttribute("right_key_attributes", "The attribute in the left example set to be used for the join.", (InputPort)this.getInputPorts().getPortByName(RIGHT_EXAMPLE_SET_INPUT), true), false);
        joinAttributes.setOptional(false);
        types.add(joinAttributes);
        ParameterTypeBoolean keepBoth = new ParameterTypeBoolean("keep_both_join_attributes", "If checked, both columns of a join pair will be kept. Usually this is unneccessary since both attributes are identical.", false, true);
        types.add(keepBoth);
        return types;
    }

    @Override
    public DbStep buildDbStep(DbStep ... inputs) throws UndefinedParameterError, NestNotFoundException, ConnectionEntryNotFound, OperatorOrSetupError {
        this.checkParameters(this.getProvider(), inputs[0], inputs[1]);
        return Join.builder().left(inputs[0]).right(inputs[1]).keepBothKeys(this.getParameterAsBoolean("keep_both_join_attributes")).keepAll(!this.getParameterAsBoolean("remove_double_attributes")).type(Join.JoinType.valueOf(this.getParameterAsString("join_type").toUpperCase())).keys((String[])this.getParameterList("key_attributes").stream().flatMap(pair -> Stream.of(pair[0], pair[1])).toArray(String[]::new)).build();
    }

    private void checkParameters(DatabaseProvider provider, DbStep left, DbStep right) throws OperatorOrSetupError, UndefinedParameterError {
        List keys = this.getParameterList("key_attributes");
        if (keys.isEmpty()) {
            throw new OperatorOrSetupError().withProcessSetupError(new ProcessSetupError[]{new SimpleProcessSetupError(ProcessSetupError.Severity.ERROR, this.getPortOwner(), Collections.singletonList(new ParameterSettingQuickFix((Operator)this, "key_attributes")), "parameter.required_missing", new Object[]{"key_attributes"})}).withUserError(new UserError((Operator)this, "join.no_key_attributes_list"));
        }
        HashMap leftColumns = new HashMap();
        left.getColumns(provider).forEach(c -> leftColumns.put(c.getDestCol(), c.getType()));
        HashMap rightColumns = new HashMap();
        right.getColumns(provider).forEach(c -> rightColumns.put(c.getDestCol(), c.getType()));
        for (String[] p : keys) {
            int rightType;
            if (!leftColumns.containsKey(p[0])) {
                throw new OperatorOrSetupError().withMetaDataError(new MetaDataError[]{new SimpleMetaDataError(ProcessSetupError.Severity.ERROR, (Port)this.leftInput, "missing_attribute", new Object[]{p[0]})}).withUserError(new UserError((Operator)this, "join.illegal_key_attribute", new Object[]{p[0], LEFT_EXAMPLE_SET_INPUT, p[1], RIGHT_EXAMPLE_SET_INPUT}));
            }
            if (!rightColumns.containsKey(p[1])) {
                throw new OperatorOrSetupError().withMetaDataError(new MetaDataError[]{new SimpleMetaDataError(ProcessSetupError.Severity.ERROR, (Port)this.rightInput, "missing_attribute", new Object[]{p[1]})}).withUserError(new UserError((Operator)this, "join.illegal_key_attribute", new Object[]{p[1], RIGHT_EXAMPLE_SET_INPUT, p[0], LEFT_EXAMPLE_SET_INPUT}));
            }
            int leftType = DbMetaDataTools.getRapidMinerTypeIndex((Integer)leftColumns.get(p[0]));
            if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(leftType, rightType = DbMetaDataTools.getRapidMinerTypeIndex((Integer)rightColumns.get(p[1]))) || Ontology.ATTRIBUTE_VALUE_TYPE.isA(rightType, leftType)) continue;
            this.addError((ProcessSetupError)new SimpleProcessSetupError(ProcessSetupError.Severity.ERROR, this.getPortOwner(), "attributes_type_mismatch", new Object[]{p[0], LEFT_EXAMPLE_SET_INPUT, p[1], RIGHT_EXAMPLE_SET_INPUT}));
            throw new OperatorOrSetupError().withUserError(new UserError((Operator)this, "join.illegal_key_attribute", new Object[]{p[1], RIGHT_EXAMPLE_SET_INPUT, p[0], LEFT_EXAMPLE_SET_INPUT}));
        }
    }
}

