/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.indatabase.operator;

import com.rapidminer.extension.indatabase.data.DbTableExampleSet;
import com.rapidminer.extension.indatabase.data.SampleDbTableExampleSet;
import com.rapidminer.extension.indatabase.db.step.DbStep;
import com.rapidminer.extension.indatabase.exceptions.OperatorOrSetupError;
import com.rapidminer.extension.indatabase.operator.AbstractNestedOperator;
import com.rapidminer.extension.indatabase.operator.Nest;
import com.rapidminer.extension.indatabase.provider.DatabaseProvider;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.OutputPortExtender;
import com.rapidminer.operator.ports.Ports;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.MetaData;

public class Multiply
extends AbstractNestedOperator {
    private final InputPort inputPort = this.createInputPortWithPrecondition("input");
    private final OutputPortExtender outputExtender = new OutputPortExtender("output", (Ports)this.getOutputPorts());

    public Multiply(OperatorDescription description) {
        super(description, false);
        this.outputExtender.start();
        this.getTransformer().addRule(new MDTransformationRule(){

            public void transformMD() {
                for (OutputPort outputPort : Multiply.this.outputExtender.getManagedPorts()) {
                    MetaData md = Multiply.this.inputPort.getMetaDataAsOrNull(MetaData.class);
                    if (md != null) {
                        md = md.clone();
                        md.addToHistory(outputPort);
                        outputPort.deliverMD(md);
                        continue;
                    }
                    outputPort.deliverMD(null);
                }
            }
        });
    }

    @Override
    public void doWork() throws OperatorException {
        super.doWork();
        DbStep output = this.buildDbStep(((DbTableExampleSet)this.inputPort.getData(DbTableExampleSet.class)).getDbStep());
        DatabaseProvider provider = null;
        try {
            provider = this.getProvider();
        }
        catch (OperatorOrSetupError e) {
            e.throwOperatorException();
        }
        boolean first = true;
        SampleDbTableExampleSet breakPointSample = null;
        for (OutputPort outputPort : this.outputExtender.getManagedPorts()) {
            if (!first) {
                DbTableExampleSet outputEs = new DbTableExampleSet(provider, output);
                if (this.hasBreakpoint(1) || outputPort.isConnected() && outputPort.getDestination().getPorts().getOwner().getOperator().hasBreakpoint(0)) {
                    if (breakPointSample == null) {
                        breakPointSample = outputEs.exploreTable(Nest.findParentNest(this));
                    }
                    outputEs = breakPointSample;
                }
                outputPort.deliver((IOObject)outputEs);
                continue;
            }
            breakPointSample = (SampleDbTableExampleSet)outputPort.getDataAsOrNull(SampleDbTableExampleSet.class);
            first = false;
        }
    }

    @Override
    public DbStep buildDbStep(DbStep ... inputs) {
        return inputs[0];
    }
}

