/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.indatabase.operator;

import com.google.api.client.util.Strings;
import com.rapidminer.MacroHandler;
import com.rapidminer.Process;
import com.rapidminer.RapidMiner;
import com.rapidminer.connection.ConnectionInformation;
import com.rapidminer.connection.adapter.ConnectionAdapterHandler;
import com.rapidminer.connection.util.ConnectionInformationSelector;
import com.rapidminer.connection.util.ConnectionSelectionProvider;
import com.rapidminer.extension.cloud.connectivity.operator.google.GoogleServiceConnectionTypeInformationSelector;
import com.rapidminer.extension.cloud.connectivity.operator.google.bigquery.GoogleBigQueryService;
import com.rapidminer.extension.indatabase.DbTools;
import com.rapidminer.extension.indatabase.OperatorMap;
import com.rapidminer.extension.indatabase.db.CachedDatabaseHandler;
import com.rapidminer.extension.indatabase.db.object.Column;
import com.rapidminer.extension.indatabase.db.object.Table;
import com.rapidminer.extension.indatabase.exceptions.NestNotFoundException;
import com.rapidminer.extension.indatabase.exceptions.OperatorOrSetupError;
import com.rapidminer.extension.indatabase.operator.NestPortPairExtender;
import com.rapidminer.extension.indatabase.operator.RetrieveOperator;
import com.rapidminer.extension.indatabase.operator.StoreOperator;
import com.rapidminer.extension.indatabase.provider.DatabaseProvider;
import com.rapidminer.extension.indatabase.provider.DatabaseProviderFactory;
import com.rapidminer.extension.indatabase.provider.other.GenericProvider;
import com.rapidminer.extension.indatabase.quickfix.ReplaceWithIndatabaseOperator;
import com.rapidminer.extension.jdbc.connection.JDBCConnectionHandler;
import com.rapidminer.gui.properties.ExpressionPropertyDialog;
import com.rapidminer.operator.ExecutionUnit;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ProcessRootOperator;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.SimpleProcessSetupError;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.SubprocessTransformRule;
import com.rapidminer.operator.ports.quickfix.AbstractQuickFix;
import com.rapidminer.operator.ports.quickfix.ParameterSettingQuickFix;
import com.rapidminer.operator.ports.quickfix.QuickFix;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeConnectionLocation;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.parameter.conditions.ParameterCondition;
import com.rapidminer.parameter.conditions.PortConnectedCondition;
import com.rapidminer.repository.RepositoryException;
import com.rapidminer.repository.RepositoryLocation;
import com.rapidminer.repository.local.SimpleConnectionEntry;
import com.rapidminer.tools.I18N;
import com.rapidminer.tools.config.ConfigurationException;
import com.rapidminer.tools.container.Pair;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.stream.IntStream;
import javax.swing.JOptionPane;

public class Nest
extends OperatorChain
implements ConnectionSelectionProvider {
    public static final String PARAMETER_LIMIT_SAMPLE_SIZE = "limit_sample_size";
    public static final String MACRO_PROCESS_TIME_DB_SPECIFIC = "process_start_db";
    public static final String MACRO_TIME_DB_SPECIFIC = "t_db";
    public static final String MACRO_DB_TYPE = "db_id";
    private static final String PARAMETER_USE_DEFAULT_DIALECT = "autodetect_SQL_dialect";
    private static final String PARAMETER_DIALECT = "SQL_dialect";
    private static final String PARAMETER_PARALLELIZE = "parallelize";
    private static final String PARAMETER_PARALLELIZATION_LIMIT = "parallelization_limit";
    private static final String PARAMETER_PARALLELIZATION_DELAY = "parallelization_delay";
    private static final String PARAMETER_ALLOW_ALL_OPERATORS = "allow_all_operators";
    private static String PARAMETER_CONNECTION_ENTRY = "connection_entry";
    public static final String SUBPROCESS_NAME = "SQL Steps";
    private final NestPortPairExtender outExtender = new NestPortPairExtender((Operator)this, "example set", this.getSubprocess(0).getInnerSinks(), this.getOutputPorts());
    private volatile CachedDatabaseHandler dbHandler = null;
    private volatile ExpressionEditorCacheMap expressionEditorCacheMap = new ExpressionEditorCacheMap();
    private volatile ConnectionInformationSelector selector = new GoogleServiceConnectionTypeInformationSelector((Operator)this, Collections.singletonList(GoogleBigQueryService.INSTANCE), new String[]{JDBCConnectionHandler.INSTANCE.getType()});

    public Nest(OperatorDescription description) {
        this(description, SUBPROCESS_NAME);
    }

    public Nest(OperatorDescription description, String ... subprocessNames) {
        super(description, subprocessNames);
        this.outExtender.start();
        this.getTransformer().addRule(ConnectionAdapterHandler.createProcessSetupRule((Operator)this));
        this.getTransformer().addRule(() -> {
            try {
                this.initHandler();
                if (this.dbHandler != null && this.getParameterAsBoolean(PARAMETER_USE_DEFAULT_DIALECT) && GenericProvider.INSTANCE.getId().equals(this.dbHandler.getProvider().getId())) {
                    this.addError((ProcessSetupError)new SimpleProcessSetupError(ProcessSetupError.Severity.ERROR, this.getPortOwner(), "unknown_db_type", new Object[0]));
                }
            }
            catch (OperatorOrSetupError e) {
                e.addSetupError((Operator)this);
            }
            catch (CouldNotRetrieveConnectionInformation couldNotRetrieveConnectionInformation) {
                // empty catch block
            }
        });
        SubprocessTransformRule subprocessTransformRule = new SubprocessTransformRule(this.getSubprocess(0));
        this.getTransformer().addRule(() -> this.lambda$new$1((MDTransformationRule)subprocessTransformRule));
        this.getTransformer().addRule(this.outExtender.makePassThroughRule());
        this.selector.makeDefaultPortTransformation();
    }

    public InputStream getGrammarStream() throws OperatorException {
        try {
            return this.getCurrentProvider().getGrammarStream();
        }
        catch (CouldNotRetrieveConnectionInformation e) {
            throw new UserError((Operator)this, "could_not_retrieve_connection_information");
        }
    }

    public ExpressionEditorCacheMap getExpressionEditorCacheMap() {
        return this.expressionEditorCacheMap;
    }

    public CachedDatabaseHandler getDbHandler() throws DatabaseHandlerNotInitialized {
        if (this.dbHandler == null) {
            throw new DatabaseHandlerNotInitialized();
        }
        return this.dbHandler;
    }

    public DatabaseProvider getProvider() throws DatabaseProviderNotInitialized {
        if (this.dbHandler == null) {
            throw new DatabaseProviderNotInitialized();
        }
        return this.dbHandler.getProvider();
    }

    public DatabaseProvider getCurrentProvider() throws OperatorException, CouldNotRetrieveConnectionInformation {
        if (this.getParameterAsBoolean(PARAMETER_USE_DEFAULT_DIALECT)) {
            if (this.isConnectionSpecified()) {
                ConnectionInformation connectionInformation;
                this.selector.passDataThrough();
                try {
                    connectionInformation = this.selector.getConnection();
                }
                catch (UserError e) {
                    throw new CouldNotRetrieveConnectionInformation(e);
                }
                return DatabaseProviderFactory.detectProvider(connectionInformation);
            }
            throw new CouldNotRetrieveConnectionInformation();
        }
        return DatabaseProviderFactory.getProvider(this.getParameterAsString(PARAMETER_DIALECT));
    }

    private DatabaseProvider getCurrentProvider(ConnectionInformation connectionInformation) throws UndefinedParameterError {
        if (this.getParameterAsBoolean(PARAMETER_USE_DEFAULT_DIALECT)) {
            return DatabaseProviderFactory.detectProvider(connectionInformation);
        }
        return DatabaseProviderFactory.getProvider(this.getParameterAsString(PARAMETER_DIALECT));
    }

    protected List<QuickFix> checkInnerOperators(Nest parent, Operator op, boolean applyAutoFixes, boolean throwOperatorError) throws UserError {
        ArrayList<QuickFix> autoFixes = new ArrayList<QuickFix>();
        if (!op.isEnabled()) {
            return autoFixes;
        }
        if (!this.getParameterAsBoolean(PARAMETER_ALLOW_ALL_OPERATORS) && parent != op && !OperatorMap.isExecutableInIndatabase(op)) {
            if (throwOperatorError) {
                throw new UserError(op, "bad_operator_indb_nest", new Object[]{op.getName(), PARAMETER_ALLOW_ALL_OPERATORS});
            }
            if (OperatorMap.canConvertToIndatabase(op)) {
                autoFixes.add((QuickFix)new ReplaceWithIndatabaseOperator(op));
            } else {
                ArrayList<RemoveNonIndbOperatorQuickfix> quickFixes = new ArrayList<RemoveNonIndbOperatorQuickfix>();
                quickFixes.add(new RemoveNonIndbOperatorQuickfix(op));
                quickFixes.add((RemoveNonIndbOperatorQuickfix)new ParameterSettingQuickFix((Operator)this, PARAMETER_ALLOW_ALL_OPERATORS, String.valueOf(true)));
                op.addError((ProcessSetupError)new SimpleProcessSetupError(ProcessSetupError.Severity.ERROR, op.getPortOwner(), quickFixes, "bad_operator_indb_nest", new Object[]{op.getOperatorClassName(), PARAMETER_ALLOW_ALL_OPERATORS}));
            }
            return autoFixes;
        }
        if (op instanceof OperatorChain) {
            HashMap<Table, Operator> tablesinRetrieves = new HashMap<Table, Operator>();
            HashMap<Table, Operator> tablesinStores = new HashMap<Table, Operator>();
            for (ExecutionUnit executionUnit : ((OperatorChain)op).getSubprocesses()) {
                for (Operator innerOp : executionUnit.getOperators()) {
                    autoFixes.addAll(this.checkInnerOperators(parent, innerOp, applyAutoFixes, throwOperatorError));
                    if (!(innerOp instanceof RetrieveOperator) && !(innerOp instanceof StoreOperator)) continue;
                    this.checkIfSameTableIsStoredAndRetrieved(innerOp, tablesinRetrieves, tablesinStores, throwOperatorError);
                }
            }
        }
        if (applyAutoFixes && op.equals((Object)parent)) {
            for (QuickFix fix : autoFixes) {
                fix.apply();
            }
            autoFixes.clear();
        }
        return autoFixes;
    }

    private void checkIfSameTableIsStoredAndRetrieved(Operator innerOp, Map<Table, Operator> tablesinRetrieves, Map<Table, Operator> tablesinStores, boolean throwOperatorError) throws UserError {
        String schema;
        try {
            schema = innerOp.getParameter("schema_name");
        }
        catch (UndefinedParameterError e) {
            schema = "";
        }
        try {
            String tableName = innerOp.getParameter("table_name");
            Table table = new Table(schema, tableName);
            if (innerOp instanceof StoreOperator && (tablesinRetrieves.containsKey(table) || tablesinStores.containsKey(table)) || innerOp instanceof RetrieveOperator && tablesinStores.containsKey(table)) {
                String otherOperator = tablesinRetrieves.containsKey(table) ? tablesinRetrieves.get(table).getName() : tablesinStores.get(table).getName();
                if (throwOperatorError) {
                    throw new UserError(innerOp, "retrieve_and_store_for_same_table", new Object[]{innerOp.getName(), table.toString(), otherOperator});
                }
                ArrayList<ParameterSettingQuickFix> quickFixes = new ArrayList<ParameterSettingQuickFix>();
                quickFixes.add(new ParameterSettingQuickFix(innerOp, "table_name"));
                quickFixes.add(new ParameterSettingQuickFix(innerOp, "schema_name"));
                innerOp.addError((ProcessSetupError)new SimpleProcessSetupError(ProcessSetupError.Severity.ERROR, innerOp.getPortOwner(), quickFixes, "retrieve_and_store_for_same_table", new Object[]{innerOp.getName(), table.toString(), otherOperator}));
            } else if (innerOp instanceof RetrieveOperator) {
                tablesinRetrieves.put(table, innerOp);
            } else {
                tablesinStores.put(table, innerOp);
            }
        }
        catch (UndefinedParameterError undefinedParameterError) {
            // empty catch block
        }
    }

    private void initHandler() throws OperatorOrSetupError, CouldNotRetrieveConnectionInformation {
        this.dbHandler = null;
        this.setParameter("connection_source", "repository");
        ProcessSetupError error = this.selector.checkConnectionTypeMatch((Operator)this);
        if (error != null) {
            throw new OperatorOrSetupError().withUserError(new UserError((Operator)this, "google.configuration_type", new Object[]{error.getMessage()}));
        }
        try {
            this.dbHandler = this.getCurrentDbHandler();
        }
        catch (UserError e) {
            String message = DbTools.getReadableRootCause(e);
            throw new OperatorOrSetupError().withUserError(e).withProcessSetupError(new ProcessSetupError[]{new SimpleProcessSetupError(ProcessSetupError.Severity.ERROR, this.getPortOwner(), "indb_error_while_connecting", new Object[]{message})});
        }
        catch (OperatorException | ConfigurationException e) {
            throw new OperatorOrSetupError().withCustomError((Exception)e, this.getPortOwner(), new ArrayList<QuickFix>());
        }
    }

    public void doWork() throws OperatorException {
        try {
            this.initHandler();
        }
        catch (OperatorOrSetupError e) {
            e.throwOperatorException();
        }
        catch (CouldNotRetrieveConnectionInformation e) {
            throw new UserError((Operator)this, "could_not_retrieve_connection_information", new Object[]{this.getName()});
        }
        this.checkInnerOperators(this, (Operator)this, false, true);
        MacroHandler macroHandler = this.getProcess().getMacroHandler();
        DatabaseProvider provider = this.getProvider();
        macroHandler.addMacro(MACRO_PROCESS_TIME_DB_SPECIFIC, provider.format(DbTools.RAPIDMINER_FORMAT_DATE_TIME.get().format(new Date(this.getProcess().getRootOperator().getStartTime())), new Column("dummy", 93)));
        macroHandler.addMacro(MACRO_TIME_DB_SPECIFIC, provider.format(DbTools.RAPIDMINER_FORMAT_DATE_TIME.get().format(new Date()), new Column("dummy", 93)));
        macroHandler.addMacro(MACRO_DB_TYPE, provider.getId());
        try {
            if (!this.getParameter(PARAMETER_LIMIT_SAMPLE_SIZE).isEmpty() && Integer.valueOf(this.getParameter(PARAMETER_LIMIT_SAMPLE_SIZE)) < 0) {
                throw new UserError((Operator)this, "sql_error", new Object[]{"The value of the limit sample size parameter must be a positive number"});
            }
        }
        catch (NumberFormatException e) {
            throw new UserError((Operator)this, "sql_error", new Object[]{"The value of the limit sample size parameter must be a valid number"});
        }
        super.doWork();
        this.outExtender.passDataThrough();
    }

    protected void performAdditionalChecks() {
        super.performAdditionalChecks();
        try {
            this.checkInnerOperators(this, (Operator)this, true, false);
        }
        catch (UserError userError) {
            throw new IllegalStateException(userError);
        }
    }

    public List<ParameterType> getParameterTypes() {
        List types = super.getParameterTypes();
        ParameterTypeConnectionLocation repositoryConnectionSource = new ParameterTypeConnectionLocation(PARAMETER_CONNECTION_ENTRY, "Indicates how the database connection should be specified.", new String[]{"cloud_connectivity:google-cloud-storage", JDBCConnectionHandler.INSTANCE.getType()});
        repositoryConnectionSource.setPrimary(true);
        repositoryConnectionSource.setOptional(false);
        types.add(repositoryConnectionSource);
        repositoryConnectionSource.registerDependencyCondition((ParameterCondition)new PortConnectedCondition((ParameterHandler)this, () -> ((ConnectionInformationSelector)this.getConnectionSelector()).getInput(), false, false));
        ParameterTypeString type = new ParameterTypeString(PARAMETER_LIMIT_SAMPLE_SIZE, "Limit sample size. Must be empty (no limit) or a positive integer", "", true);
        types.add(type);
        types.add(new ParameterTypeBoolean(PARAMETER_USE_DEFAULT_DIALECT, "Detect the SQL dialect automatically from the connection settings. If unchecked, you must select the dialect in another parameter.", true, true));
        String[] providers = DatabaseProviderFactory.getOrderedProviderIdList();
        ParameterTypeCategory databaseType = new ParameterTypeCategory(PARAMETER_DIALECT, "SQL dialect that the database uses. This can be automatically detected for supported databases by checking autodetect_SQL_dialect. For officially not supported databases, you must choose the dialect via this parameter explicitly.", providers, IntStream.range(0, providers.length).filter(i -> providers[i].equals(GenericProvider.INSTANCE.getId())).findFirst().getAsInt());
        databaseType.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_USE_DEFAULT_DIALECT, true, false));
        types.add(databaseType);
        types.addAll(this.getDatabaseProviderParameterTypes());
        types.add(new ParameterTypeBoolean(PARAMETER_PARALLELIZE, "Set to true to submit multiple queries concurrently to the database. Multiple Nest outputs require multiple queries, and setting this parameter to true makes them run in parallel. Note that this may increase the load on your source database significantly.", false, true));
        type = new ParameterTypeInt(PARAMETER_PARALLELIZATION_LIMIT, "Maximum number of queries to submit to the database concurrently. Minimum is 2, but you can disable parallelization entirely by unchecking parallelize parameter.", 2, Integer.MAX_VALUE, 2, true);
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_PARALLELIZE, true, true));
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_PARALLELIZATION_DELAY, "Time in milliseconds to wait between submitting concurrent queries. The goal here is to avoid hitting API limits in case of cloud sources, or any other database limitations. Please consult your database administrator on what limitations apply in your environment.", 0, Integer.MAX_VALUE, 500, true);
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_PARALLELIZE, true, true));
        types.add(type);
        types.add(new ParameterTypeBoolean(PARAMETER_ALLOW_ALL_OPERATORS, "Set to true to allow using any type of operators inside the Nest, not just In-Database operators. Note that this option should only be considered as a last resort. These operators may not behave the originally intended way, their behaviour may depend on inner implementation details, and no backward compatibility is guaranteed if such operators are used inside the Nest. Also note that automatic replacement of non-In-Database operators when they are drag&dropped into the Nest is disabled if this parameter is set to true. Please only use this option if you know what you are doing, and ready to experiment.", false, true));
        return types;
    }

    private List<ParameterType> getDatabaseProviderParameterTypes() {
        ArrayList<ParameterType> res = new ArrayList<ParameterType>();
        for (final String id : DatabaseProviderFactory.getOrderedProviderIdList()) {
            DatabaseProvider p = DatabaseProviderFactory.getProvider(id);
            for (ParameterType dbParam : p.getParameterTypes()) {
                dbParam.registerDependencyCondition(new ParameterCondition((ParameterHandler)this, false){

                    public boolean isConditionFullfilled() {
                        try {
                            DatabaseProvider provider = Nest.this.getCurrentProvider();
                            return provider != null && id.equals(provider.getId());
                        }
                        catch (CouldNotRetrieveConnectionInformation | OperatorException e) {
                            return false;
                        }
                    }
                });
                res.add(dbParam);
            }
        }
        return res;
    }

    public static Nest findParentNest(Operator o) throws NestNotFoundException {
        if (o instanceof Nest) {
            return (Nest)o;
        }
        OperatorChain parent = o.getParent();
        if (parent == null || parent instanceof ProcessRootOperator) {
            throw new NestNotFoundException(o);
        }
        return Nest.findParentNest((Operator)parent);
    }

    public boolean isConnectionSpecified() {
        try {
            if (this.selector.getInput().isConnected() || !Strings.isNullOrEmpty((String)this.getParameter(PARAMETER_CONNECTION_ENTRY))) {
                return true;
            }
        }
        catch (UndefinedParameterError undefinedParameterError) {
            // empty catch block
        }
        return false;
    }

    public CachedDatabaseHandler getCurrentDbHandler() throws ConfigurationException, OperatorException, CouldNotRetrieveConnectionInformation {
        if (this.isConnectionSpecified()) {
            ConnectionInformation connectionInformation;
            this.selector.passDataThrough();
            try {
                connectionInformation = this.selector.getConnection();
            }
            catch (UserError e) {
                throw new CouldNotRetrieveConnectionInformation();
            }
            return CachedDatabaseHandler.getOrCreate(connectionInformation, (Operator)this, this.getCurrentProvider(connectionInformation));
        }
        throw new CouldNotRetrieveConnectionInformation();
    }

    public ConnectionInformationSelector getConnectionSelector() {
        return this.selector;
    }

    public void setConnectionSelector(ConnectionInformationSelector selector) {
        this.selector = selector;
    }

    int getParallelizationLimit() {
        boolean defaultValue = true;
        if (!this.getParameterAsBoolean(PARAMETER_PARALLELIZE)) {
            return 1;
        }
        try {
            return this.getParameterAsInt(PARAMETER_PARALLELIZATION_LIMIT);
        }
        catch (UndefinedParameterError e) {
            return 1;
        }
    }

    int getParallelizationDelay() {
        boolean defaultValue = false;
        if (!this.getParameterAsBoolean(PARAMETER_PARALLELIZE)) {
            return 0;
        }
        try {
            return this.getParameterAsInt(PARAMETER_PARALLELIZATION_DELAY);
        }
        catch (UndefinedParameterError e) {
            return 0;
        }
    }

    public void setConnection(SimpleConnectionEntry connectionEntry) {
        String location;
        try {
            RepositoryLocation loc = this.getProcess().getRepositoryLocation();
            location = loc != null && loc.getRepository().equals(connectionEntry.getLocation().getRepository()) ? connectionEntry.getLocation().makeRelative(loc) : connectionEntry.getLocation().getAbsoluteLocation();
        }
        catch (RepositoryException e) {
            location = connectionEntry.getLocation().getAbsoluteLocation();
        }
        try {
            if (!this.getParameter(PARAMETER_CONNECTION_ENTRY).equals(location)) {
                this.setParameter(PARAMETER_CONNECTION_ENTRY, location);
            }
        }
        catch (UndefinedParameterError undefinedParameterError) {
            this.setParameter(PARAMETER_CONNECTION_ENTRY, location);
        }
    }

    private /* synthetic */ void lambda$new$1(MDTransformationRule subprocessTransformRule) {
        if (this.dbHandler != null) {
            subprocessTransformRule.transformMD();
        }
    }

    public static class ExpressionEditorCacheMap
    extends DbTools.LimitedSizeHashMap<DialectAndMetaDataKey, ExpressionEditorCache> {
        private static final long serialVersionUID = -8810885777208988874L;

        public ExpressionEditorCacheMap() {
            super(10);
        }

        public ExpressionEditorCache getOrCreate(DialectAndMetaDataKey key) {
            return super.computeIfAbsent(key, k -> new ExpressionEditorCache());
        }
    }

    public static class CouldNotRetrieveConnectionInformation
    extends Exception {
        private static final long serialVersionUID = 7653475814038793336L;

        public CouldNotRetrieveConnectionInformation() {
            super("Could not retrieve connection information for the In-Database connection.");
        }

        public CouldNotRetrieveConnectionInformation(UserError e) {
            super("Could not retrieve connection information for the In-Database connection.", e);
        }
    }

    public class DatabaseHandlerNotInitialized
    extends UserError {
        private static final long serialVersionUID = 3773268764753545679L;

        public DatabaseHandlerNotInitialized() {
            super((Operator)Nest.this, "database_handler_init");
        }

        public OperatorOrSetupError throwUserOrSetupError() {
            return new OperatorOrSetupError().withUserError(this).withProcessSetupError(new ProcessSetupError[]{new SimpleProcessSetupError(ProcessSetupError.Severity.ERROR, Nest.this.getPortOwner(), "database_handler_init", new Object[0])});
        }
    }

    public class DatabaseProviderNotInitialized
    extends UserError {
        private static final long serialVersionUID = 3773268764753545679L;

        public DatabaseProviderNotInitialized() {
            super((Operator)Nest.this, "database_provider_init");
        }

        public OperatorOrSetupError throwUserOrSetupError() {
            return new OperatorOrSetupError().withUserError(this).withProcessSetupError(new ProcessSetupError[]{new SimpleProcessSetupError(ProcessSetupError.Severity.ERROR, Nest.this.getPortOwner(), "database_provider_init", new Object[0])});
        }
    }

    private static class RemoveNonIndbOperatorQuickfix
    extends AbstractQuickFix {
        private final Operator operator;

        public RemoveNonIndbOperatorQuickfix(Operator op) {
            super(5, true, "remove_non_indb_operator", new Object[]{op.getName()});
            this.operator = op;
        }

        private static void removeOp(Operator op) {
            ArrayList<OutputPort> incomingPorts = new ArrayList<OutputPort>();
            for (Object inputPort : op.getInputPorts().getAllPorts()) {
                if (!inputPort.isConnected()) continue;
                incomingPorts.add(inputPort.getSource());
                inputPort.getSource().disconnect();
            }
            ArrayList<InputPort> outgoingPorts = new ArrayList<InputPort>();
            for (OutputPort outputPort : op.getOutputPorts().getAllPorts()) {
                if (!outputPort.isConnected()) continue;
                outgoingPorts.add(outputPort.getDestination());
                outputPort.disconnect();
            }
            for (int i = 0; i < incomingPorts.size() && i < outgoingPorts.size(); ++i) {
                ((OutputPort)incomingPorts.get(i)).connectTo((InputPort)outgoingPorts.get(i));
            }
            op.remove();
        }

        public void apply() {
            if (!RapidMiner.getExecutionMode().isHeadless()) {
                String title = I18N.getMessage((ResourceBundle)I18N.getErrorBundle(), (String)"metadata.quickfix.remove_operator.question.title", (Object[])new Object[0]);
                String message = I18N.getMessage((ResourceBundle)I18N.getErrorBundle(), (String)"metadata.quickfix.remove_operator.question.message", (Object[])new Object[]{this.operator.getName()});
                int answer = JOptionPane.showConfirmDialog(null, message, title, 0);
                if (answer == 0) {
                    RemoveNonIndbOperatorQuickfix.removeOp(this.operator);
                }
            }
        }
    }

    public static class DialectAndMetaDataKey {
        final String dialect;
        final List<Pair<String, Integer>> attributes;

        public static DialectAndMetaDataKey fromExampleSetMetaData(String dialect, ExampleSetMetaData esmd) {
            ArrayList<Pair<String, Integer>> attrs = new ArrayList<Pair<String, Integer>>();
            esmd.getAllAttributes().forEach(a -> attrs.add(new Pair((Object)a.getName(), (Object)a.getValueType())));
            return new DialectAndMetaDataKey(dialect, attrs);
        }

        public DialectAndMetaDataKey(String dialect, List<Pair<String, Integer>> attributes) {
            this.dialect = dialect;
            this.attributes = attributes;
        }

        public String getDialect() {
            return this.dialect;
        }

        public List<Pair<String, Integer>> getAttributes() {
            return this.attributes;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DialectAndMetaDataKey)) {
                return false;
            }
            DialectAndMetaDataKey other = (DialectAndMetaDataKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$dialect = this.getDialect();
            String other$dialect = other.getDialect();
            if (this$dialect == null ? other$dialect != null : !this$dialect.equals(other$dialect)) {
                return false;
            }
            List<Pair<String, Integer>> this$attributes = this.getAttributes();
            List<Pair<String, Integer>> other$attributes = other.getAttributes();
            return !(this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DialectAndMetaDataKey;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $dialect = this.getDialect();
            result = result * 59 + ($dialect == null ? 43 : $dialect.hashCode());
            List<Pair<String, Integer>> $attributes = this.getAttributes();
            result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
            return result;
        }

        public String toString() {
            return "Nest.DialectAndMetaDataKey(dialect=" + this.getDialect() + ", attributes=" + String.valueOf(this.getAttributes()) + ")";
        }
    }

    public static class ExpressionEditorCache {
        ExpressionPropertyDialog currentDialog = null;
        Process controllingProcess = null;

        public ExpressionPropertyDialog getCurrentDialog() {
            return this.currentDialog;
        }

        public Process getControllingProcess() {
            return this.controllingProcess;
        }

        public void setCurrentDialog(ExpressionPropertyDialog currentDialog) {
            this.currentDialog = currentDialog;
        }

        public void setControllingProcess(Process controllingProcess) {
            this.controllingProcess = controllingProcess;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ExpressionEditorCache)) {
                return false;
            }
            ExpressionEditorCache other = (ExpressionEditorCache)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ExpressionPropertyDialog this$currentDialog = this.getCurrentDialog();
            ExpressionPropertyDialog other$currentDialog = other.getCurrentDialog();
            if (this$currentDialog == null ? other$currentDialog != null : !this$currentDialog.equals(other$currentDialog)) {
                return false;
            }
            Process this$controllingProcess = this.getControllingProcess();
            Process other$controllingProcess = other.getControllingProcess();
            return !(this$controllingProcess == null ? other$controllingProcess != null : !this$controllingProcess.equals(other$controllingProcess));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ExpressionEditorCache;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ExpressionPropertyDialog $currentDialog = this.getCurrentDialog();
            result = result * 59 + ($currentDialog == null ? 43 : $currentDialog.hashCode());
            Process $controllingProcess = this.getControllingProcess();
            result = result * 59 + ($controllingProcess == null ? 43 : $controllingProcess.hashCode());
            return result;
        }

        public String toString() {
            return "Nest.ExpressionEditorCache(currentDialog=" + String.valueOf(this.getCurrentDialog()) + ", controllingProcess=" + String.valueOf(this.getControllingProcess()) + ")";
        }
    }
}

