/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.indatabase.operator;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.extension.indatabase.DbTools;
import com.rapidminer.extension.indatabase.data.DbTableExampleSet;
import com.rapidminer.extension.indatabase.exceptions.NestNotFoundException;
import com.rapidminer.extension.indatabase.metadata.DbMetaDataTools;
import com.rapidminer.extension.indatabase.operator.AbstractNestedOperator;
import com.rapidminer.extension.indatabase.operator.Nest;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.ProcessStoppedException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.WrapperOperatorRuntimeException;
import com.rapidminer.operator.ports.InputPorts;
import com.rapidminer.operator.ports.OutputPorts;
import com.rapidminer.operator.ports.Port;
import com.rapidminer.operator.ports.PortPairExtender;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.MetaDataErrorWithoutI18n;
import com.rapidminer.operator.ports.metadata.table.TableMetaData;
import com.rapidminer.operator.ports.metadata.table.TableMetaDataBuilder;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.belt.BeltConversionTools;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class NestPortPairExtender
extends PortPairExtender {
    private final Operator operator;

    public NestPortPairExtender(Operator op, String name, InputPorts inPorts, OutputPorts outPorts) {
        super(name, inPorts, outPorts);
        this.operator = op;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void passDataThrough() {
        block9: {
            Nest nest;
            try {
                nest = Nest.findParentNest(this.operator);
            }
            catch (NestNotFoundException e) {
                throw new WrapperOperatorRuntimeException((OperatorException)((Object)e));
            }
            int parallelizationLimit = nest.getParallelizationLimit();
            ExecutorService executor = Executors.newFixedThreadPool(parallelizationLimit);
            try {
                List portPairs = this.getManagedPairs().stream().filter(pp -> pp.getOutputPort().isConnected()).collect(Collectors.toList());
                Date now = new Date();
                if (parallelizationLimit == 1) {
                    try {
                        executor.submit(() -> portPairs.forEach(pair -> this.processPortPair((PortPairExtender.PortPair)pair, nest))).get();
                        break block9;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        break block9;
                    }
                    catch (ExecutionException e) {
                        throw NestPortPairExtender.buildWrapperOperatorRuntimeException(e);
                    }
                }
                IntStream.range(0, portPairs.size()).parallel().forEach(i -> {
                    try {
                        int ms = i * nest.getParallelizationDelay();
                        while (new Date().before(new Date(now.getTime() + (long)ms))) {
                            Thread.sleep(500L);
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                    try {
                        nest.checkForStop();
                    }
                    catch (ProcessStoppedException e1) {
                        return;
                    }
                    try {
                        executor.submit(() -> this.processPortPair((PortPairExtender.PortPair)portPairs.get(i), nest)).get();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    catch (ExecutionException e) {
                        throw NestPortPairExtender.buildWrapperOperatorRuntimeException(e);
                    }
                });
            }
            finally {
                executor.shutdown();
            }
        }
    }

    protected MetaData transformMetaData(MetaData md) {
        TableMetaData tmd = BeltConversionTools.asTableMetaDataOrNull((MetaData)md);
        if (tmd != null && DbMetaDataTools.readColumnMetaData(tmd) != null) {
            TableMetaDataBuilder builder = new TableMetaDataBuilder(tmd);
            DbMetaDataTools.resetColumnMetaData(builder);
            return builder.build();
        }
        return super.transformMetaData(md);
    }

    private void processPortPair(final PortPairExtender.PortPair pair, final Nest nest) {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws OperatorException {
                    NestPortPairExtender.this.processPortPairAction(pair, nest);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw NestPortPairExtender.buildWrapperOperatorRuntimeException(e);
        }
    }

    private void processPortPairAction(PortPairExtender.PortPair pair, Nest nest) {
        try {
            ExampleSet materializedEs;
            Operator o;
            DbTableExampleSet ex = (DbTableExampleSet)pair.getInputPort().getData(DbTableExampleSet.class);
            if (pair.getInputPort().isConnected() && (o = pair.getInputPort().getSource().getPorts().getOwner().getOperator()) instanceof AbstractNestedOperator) {
                ((AbstractNestedOperator)o).propagateQueryIsRunning();
            }
            if ((materializedEs = ex.materialize(nest)) == null) {
                return;
            }
            LogService.getRoot().fine(() -> String.format("Retrieved %d rows into the memory.", materializedEs.size()));
            if (materializedEs.getAnnotations().containsKey((Object)"DB Warnings")) {
                this.operator.addError((ProcessSetupError)new MetaDataErrorWithoutI18n(ProcessSetupError.Severity.WARNING, (Port)pair.getOutputPort(), "DB Warnings: " + materializedEs.getAnnotations().getAnnotation("DB Warnings")));
            }
            pair.getOutputPort().deliver((IOObject)materializedEs);
        }
        catch (OperatorException e) {
            throw new WrapperOperatorRuntimeException(e);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new WrapperOperatorRuntimeException((OperatorException)((Object)new UserError((Operator)nest, "sql_error", new Object[]{DbTools.formatErrorMessage(e)})));
        }
        finally {
            Operator o;
            if (pair.getInputPort().isConnected() && (o = pair.getInputPort().getSource().getPorts().getOwner().getOperator()) instanceof AbstractNestedOperator) {
                ((AbstractNestedOperator)o).propagateQueryIsDone();
            }
        }
    }

    public static WrapperOperatorRuntimeException buildWrapperOperatorRuntimeException(Exception e) {
        if (e.getCause() instanceof WrapperOperatorRuntimeException) {
            return (WrapperOperatorRuntimeException)e.getCause();
        }
        String message = e.getCause() == null ? e.getMessage() : e.getCause().getMessage();
        return new WrapperOperatorRuntimeException(new OperatorException(message, e.getCause()));
    }
}

