/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.indatabase.operator;

import com.rapidminer.extension.indatabase.OperatorMap;
import com.rapidminer.extension.indatabase.exceptions.NestNotFoundException;
import com.rapidminer.extension.indatabase.exceptions.OperatorOrSetupError;
import com.rapidminer.extension.indatabase.operator.Nest;
import com.rapidminer.extension.indatabase.provider.DatabaseProvider;
import com.rapidminer.extension.indatabase.quickfix.ReplaceWithStandardOperator;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.SimpleProcessSetupError;
import com.rapidminer.operator.ports.quickfix.AbstractQuickFix;
import com.rapidminer.operator.ports.quickfix.QuickFix;
import com.rapidminer.tools.I18N;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;

public interface NestedOperator {
    default public List<QuickFix> checkIsInIndatabaseNest(boolean applyAutoFixes) {
        ArrayList<QuickFix> autoFixes = new ArrayList<QuickFix>();
        final Operator op = (Operator)this;
        try {
            Nest.findParentNest(op);
        }
        catch (NestNotFoundException e) {
            if (OperatorMap.canConvertToStandard(op)) {
                ReplaceWithStandardOperator fix = new ReplaceWithStandardOperator(op);
                if (applyAutoFixes) {
                    fix.apply();
                } else {
                    autoFixes.add((QuickFix)fix);
                }
            }
            ArrayList<1> quickFixes = new ArrayList<1>();
            final Operator opToRemove = op;
            quickFixes.add(new AbstractQuickFix(5, true, "remove_indb_operator", new Object[]{op.getName()}){

                public void apply() {
                    String title = I18N.getMessage((ResourceBundle)I18N.getErrorBundle(), (String)"metadata.quickfix.remove_operator.question.title", (Object[])new Object[0]);
                    String message = I18N.getMessage((ResourceBundle)I18N.getErrorBundle(), (String)"metadata.quickfix.remove_operator.question.message", (Object[])new Object[]{op.getName()});
                    int answer = JOptionPane.showConfirmDialog(null, message, title, 0);
                    if (answer == 0) {
                        opToRemove.remove();
                    }
                }
            });
            op.addError((ProcessSetupError)new SimpleProcessSetupError(ProcessSetupError.Severity.ERROR, op.getPortOwner(), quickFixes, "indb_operator_outside_nest", new Object[]{op.getOperatorClassName()}));
        }
        return autoFixes;
    }

    default public DatabaseProvider getProvider() throws NestNotFoundException, OperatorOrSetupError {
        try {
            return Nest.findParentNest((Operator)this).getProvider();
        }
        catch (Nest.DatabaseProviderNotInitialized e) {
            throw e.throwUserOrSetupError();
        }
    }
}

