/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.indatabase.operator;

import com.rapidminer.extension.indatabase.db.object.Column;
import com.rapidminer.extension.indatabase.db.object.RenamedColumn;
import com.rapidminer.extension.indatabase.db.step.DbStep;
import com.rapidminer.extension.indatabase.db.step.Select;
import com.rapidminer.extension.indatabase.exceptions.NestNotFoundException;
import com.rapidminer.extension.indatabase.exceptions.OperatorOrSetupError;
import com.rapidminer.extension.indatabase.operator.AbstractFilteredProcessing;
import com.rapidminer.extension.indatabase.provider.DatabaseProvider;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.UserError;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeRegexp;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.UndefinedParameterError;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public class RenameByReplacing
extends AbstractFilteredProcessing {
    public RenameByReplacing(OperatorDescription description) {
        super(description);
    }

    @Override
    public DbStep buildDbStepOnFilteredColumns(Set<String> columnSubset, DbStep input) throws OperatorOrSetupError, NestNotFoundException, UndefinedParameterError {
        Pattern replaceWhatPattern = Pattern.compile(this.getParameterAsString("replace_what"));
        String replaceByString = this.isParameterSet("replace_by") ? this.getParameterAsString("replace_by") : "";
        DatabaseProvider provider = this.getProvider();
        ArrayList<Column> newCols = new ArrayList<Column>();
        try {
            for (Column col : input.getColumnRefs(provider)) {
                String newName = col.getDestCol();
                if (columnSubset.contains(col.getDestCol())) {
                    newName = replaceWhatPattern.matcher(col.getDestCol()).replaceAll(replaceByString);
                }
                newCols.add(newName.equals(col.getDestCol()) ? new Column(col.getDestCol(), col.getType()) : RenamedColumn.rename(col, newName));
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new OperatorOrSetupError().withUserError(new UserError((Operator)this, 215, new Object[]{replaceByString, "replace_what"}));
        }
        return Select.builder().columns(newCols).from(input).build();
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeRegexp regexp = new ParameterTypeRegexp("replace_what", "A regular expression defining what should be replaced in the attribute names.", "\\W");
        regexp.setShowRange(false);
        regexp.setExpert(false);
        regexp.setPrimary(true);
        types.add((ParameterType)regexp);
        ParameterTypeString replacement = new ParameterTypeString("replace_by", "This string is used as replacement for all parts of the matching attributes where the parameter 'replace_what' matches.", true, false);
        regexp.setReplacementParameter(replacement);
        types.add((ParameterType)replacement);
        return types;
    }
}

