/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.indatabase.operator;

import com.rapidminer.extension.indatabase.db.object.Column;
import com.rapidminer.extension.indatabase.db.object.RenamedColumn;
import com.rapidminer.extension.indatabase.db.step.DbStep;
import com.rapidminer.extension.indatabase.db.step.Select;
import com.rapidminer.extension.indatabase.exceptions.ConnectionEntryNotFound;
import com.rapidminer.extension.indatabase.exceptions.NestNotFoundException;
import com.rapidminer.extension.indatabase.exceptions.OperatorOrSetupError;
import com.rapidminer.extension.indatabase.operator.AbstractNestedOperator;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.error.AttributeNotFoundError;
import com.rapidminer.operator.ports.Port;
import com.rapidminer.operator.ports.metadata.AttributeSetPrecondition;
import com.rapidminer.operator.ports.metadata.MetaDataError;
import com.rapidminer.operator.ports.metadata.Precondition;
import com.rapidminer.operator.ports.metadata.SimpleMetaDataError;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeAttribute;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.UndefinedParameterError;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class RenameOperator
extends AbstractNestedOperator {
    public RenameOperator(OperatorDescription description) {
        super(description, true);
        this.getInputPort().addPrecondition((Precondition)new AttributeSetPrecondition(this.getInputPort(), AttributeSetPrecondition.getAttributesByParameter((ParameterHandler)this, (String[])new String[]{"old_name"}), new String[0]));
        this.getInputPort().addPrecondition((Precondition)new AttributeSetPrecondition(this.getInputPort(), AttributeSetPrecondition.getAttributesByParameterListEntry((ParameterHandler)this, (String)"rename_additional_attributes", (int)0), new String[0]));
    }

    public List<ParameterType> getParameterTypes() {
        List types = super.getParameterTypes();
        types.add(new ParameterTypeAttribute("old_name", "The old name of the attribute.", this.getInputPort(), false));
        types.add(new ParameterTypeString("new_name", "The new name of the attribute.", false));
        types.add(new ParameterTypeList("rename_additional_attributes", "A list that can be used to define additional attributes that should be renamed.", (ParameterType)new ParameterTypeAttribute("old_name", "The old name of the attribute.", this.getInputPort(), false), (ParameterType)new ParameterTypeString("new_name", "The new name of the attribute.", false), false));
        return types;
    }

    @Override
    public DbStep buildDbStep(DbStep ... inputs) throws UndefinedParameterError, NestNotFoundException, OperatorOrSetupError, ConnectionEntryNotFound {
        LinkedHashMap inputCols = new LinkedHashMap();
        inputs[0].getColumnRefs(this.getProvider()).forEach(c -> inputCols.put(c.getDestCol(), c));
        LinkedHashMap<String, String> renamings = new LinkedHashMap<String, String>();
        renamings.put(this.getParameterAsString("old_name"), this.getParameterAsString("new_name"));
        this.getParameterList("rename_additional_attributes").forEach(p -> renamings.put(p[0], p[1]));
        HashSet<String> processedRenamingTargets = new HashSet<String>();
        for (Map.Entry p2 : renamings.entrySet()) {
            if (!inputCols.containsKey(p2.getKey())) {
                throw new OperatorOrSetupError().withUserError((UserError)new AttributeNotFoundError((Operator)this, "old_name", (String)p2.getKey()));
            }
            if ((inputCols.containsKey(p2.getValue()) || processedRenamingTargets.contains(p2.getValue())) && (!renamings.containsKey(p2.getValue()) || ((String)renamings.get(p2.getValue())).equals(p2.getValue()))) {
                throw new OperatorOrSetupError().withUserError(new UserError((Operator)this, 152, new Object[]{p2.getValue()})).withMetaDataError(new MetaDataError[]{new SimpleMetaDataError(ProcessSetupError.Severity.ERROR, (Port)this.getInputPort(), "already_contains_attribute", new Object[]{p2.getValue()})});
            }
            processedRenamingTargets.add((String)p2.getValue());
        }
        List<Column> cols = inputCols.entrySet().stream().map(e -> renamings.containsKey(e.getKey()) ? RenamedColumn.rename((Column)e.getValue(), (String)renamings.get(e.getKey())) : (Column)e.getValue()).collect(Collectors.toList());
        return Select.builder().from(inputs[0]).columns(cols).build();
    }
}

