/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.indatabase.operator;

import com.rapidminer.extension.indatabase.DbTools;
import com.rapidminer.extension.indatabase.db.object.Column;
import com.rapidminer.extension.indatabase.db.object.ColumnExpr;
import com.rapidminer.extension.indatabase.db.object.Expression;
import com.rapidminer.extension.indatabase.db.object.SourceColumn;
import com.rapidminer.extension.indatabase.db.step.AggregationSubquery;
import com.rapidminer.extension.indatabase.db.step.DbStep;
import com.rapidminer.extension.indatabase.db.step.Select;
import com.rapidminer.extension.indatabase.exceptions.ConnectionEntryNotFound;
import com.rapidminer.extension.indatabase.exceptions.NestNotFoundException;
import com.rapidminer.extension.indatabase.exceptions.OperatorOrSetupError;
import com.rapidminer.extension.indatabase.metadata.DbMetaDataTools;
import com.rapidminer.extension.indatabase.operator.AbstractFilteredProcessing;
import com.rapidminer.extension.indatabase.provider.DatabaseProvider;
import com.rapidminer.gui.tools.VersionNumber;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorVersion;
import com.rapidminer.operator.UserError;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeAttribute;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.ParameterTypeStringCategory;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.ParameterCondition;
import com.rapidminer.tools.Ontology;
import com.rapidminer.tools.container.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ReplaceMissing
extends AbstractFilteredProcessing {
    private static OperatorVersion VERSION_COLUMNS_OUTSIDE_ATTRIBUTE_FILTER = new OperatorVersion(9, 10, 0);
    private static final String[] REPLENISHMENT_NAMES = Stream.of(ReplenishmentType.values()).map(Enum::name).map(String::toLowerCase).collect(Collectors.toList()).toArray(new String[0]);

    public ReplaceMissing(OperatorDescription description) {
        super(description);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        String[] functionNames = REPLENISHMENT_NAMES;
        ParameterTypeCategory type = new ParameterTypeCategory("default", "Function to apply to all columns that are not explicitly specified by parameter 'columns'.", functionNames, ReplenishmentType.AVERAGE.ordinal());
        type.setExpert(false);
        types.add((ParameterType)type);
        ParameterTypeStringCategory categories = new ParameterTypeStringCategory("replace_with", "Selects the function, which is used to determine the replacement for the missing values of this attribute.", functionNames, functionNames[ReplenishmentType.AVERAGE.ordinal()], false);
        categories.setEditable(false);
        types.add((ParameterType)new ParameterTypeList("columns", "List of replacement functions for each column.", (ParameterType)new ParameterTypeAttribute("attribute", "Specifies the attribute, which missing values are replaced.", this.getInputPort()), (ParameterType)categories));
        type = new ParameterTypeString("replenishment_value", "This value is used for some of the replenishment types.", true, false);
        type.registerDependencyCondition(new ParameterCondition((ParameterHandler)this, "default", true){

            public boolean isConditionFullfilled() {
                try {
                    if (ReplaceMissing.this.getParameterAsInt("default") == ReplenishmentType.VALUE.ordinal()) {
                        return true;
                    }
                    List pairs = ReplaceMissing.this.getParameterList("columns");
                    if (pairs != null) {
                        for (String[] pair : pairs) {
                            if (!pair[1].equals("value") && !pair[1].equals(ReplenishmentType.VALUE.name())) continue;
                            return true;
                        }
                    }
                }
                catch (UndefinedParameterError undefinedParameterError) {
                    // empty catch block
                }
                return false;
            }
        });
        types.add((ParameterType)type);
        return types;
    }

    @Override
    public DbStep buildDbStepOnFilteredColumns(Set<String> columnSubset, DbStep input) throws OperatorOrSetupError, NestNotFoundException, UndefinedParameterError, ConnectionEntryNotFound {
        DatabaseProvider provider = this.getProvider();
        ArrayList<Column> aggCols = new ArrayList<Column>();
        ArrayList<Column> selectCols = new ArrayList<Column>();
        for (Pair<Column, ReplenishmentType> repl : this.getReplenishments(provider, columnSubset, input)) {
            int rmType;
            Column col = (Column)repl.getFirst();
            ReplenishmentType type = (ReplenishmentType)((Object)repl.getSecond());
            if (!ReplaceMissing.doesReplenishmentSupportValueType(type, rmType = DbMetaDataTools.getRapidMinerTypeIndex(col.getType()))) {
                if (this.isRunning()) {
                    this.logWarning("Function \"" + String.valueOf((Object)type) + "\" does not support attribute \"" + col.getDestCol() + "\" of type \"" + Ontology.ATTRIBUTE_VALUE_TYPE.mapIndex(rmType) + "\". Ignoring missing values of this attribute.");
                }
                selectCols.add(col);
                continue;
            }
            this.addColumnExpr(provider, aggCols, selectCols, col, type);
        }
        if (aggCols.isEmpty()) {
            return Select.builder().columns(selectCols).from(input).build();
        }
        return AggregationSubquery.builder().aggregations(aggCols).columns(selectCols).from(input).build();
    }

    public OperatorVersion[] getIncompatibleVersionChanges() {
        ArrayList<OperatorVersion> res = new ArrayList<OperatorVersion>();
        res.addAll(Arrays.asList(super.getIncompatibleVersionChanges()));
        res.add(VERSION_COLUMNS_OUTSIDE_ATTRIBUTE_FILTER);
        return res.toArray(new OperatorVersion[0]);
    }

    private void addColumnExpr(DatabaseProvider provider, List<Column> aggCols, List<Column> selectCols, Column col, ReplenishmentType type) throws OperatorOrSetupError {
        String aggFunc = type.aggregateFunction;
        SourceColumn originalCol = new SourceColumn("t1", col.getDestCol(), col.getType());
        if (!aggFunc.isEmpty()) {
            String aggColAlias = String.format("%s%d", "a", aggCols.size());
            aggCols.add(new ColumnExpr(new Expression(String.format("%s(%s)", aggFunc, col.toSql(provider))), aggColAlias));
            selectCols.add(DbTools.buildFirstNonNullExpr(provider, originalCol, new SourceColumn("agg1", aggColAlias, col.getType())));
        } else if (ReplenishmentType.ZERO == type) {
            String valStr = "0.0";
            int exprType = 8;
            if (4 == col.getType()) {
                valStr = "0";
                exprType = 4;
            }
            selectCols.add(new ColumnExpr(provider.generateFirstNonNullExpr(((Column)originalCol).toSql(provider), valStr), col.getDestCol(), exprType));
        } else if (ReplenishmentType.VALUE == type) {
            try {
                selectCols.add(new ColumnExpr(provider.generateFirstNonNullExpr(((Column)originalCol).toSql(provider), this.generateValueLiteral(provider, col.getType())), col.getDestCol(), col.getType()));
            }
            catch (UserError e) {
                throw new OperatorOrSetupError().withUserError(e);
            }
        } else {
            selectCols.add(originalCol);
        }
    }

    private static boolean doesReplenishmentSupportValueType(ReplenishmentType type, int valueType) {
        if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(valueType, 1)) {
            switch (type) {
                case MINIMUM: 
                case MAXIMUM: 
                case AVERAGE: 
                case ZERO: {
                    return false;
                }
            }
        } else if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(valueType, 9)) {
            switch (type) {
                case AVERAGE: {
                    return false;
                }
            }
        }
        return true;
    }

    private List<Pair<Column, ReplenishmentType>> getReplenishments(DatabaseProvider provider, Set<String> columnSubset, DbStep input) throws UndefinedParameterError {
        ArrayList<Pair<Column, ReplenishmentType>> repls = new ArrayList<Pair<Column, ReplenishmentType>>();
        HashMap replTypes = new HashMap();
        this.getParameterList("columns").forEach(pair -> replTypes.put(pair[0], pair[1]));
        ReplenishmentType defaultType = ReplenishmentType.valueOf(this.getParameterAsString("default").toUpperCase());
        for (Column c : input.getColumnRefs(provider)) {
            String replType = (String)replTypes.get(c.getDestCol());
            ReplenishmentType type = replType != null && (this.getCompatibilityLevel().isAtMost((VersionNumber)VERSION_COLUMNS_OUTSIDE_ATTRIBUTE_FILTER) || columnSubset.contains(c.getDestCol())) ? ReplenishmentType.valueOf(replType.toUpperCase()) : (columnSubset.contains(c.getDestCol()) ? defaultType : ReplenishmentType.NONE);
            repls.add((Pair<Column, ReplenishmentType>)new Pair((Object)c, (Object)type));
        }
        return repls;
    }

    private String generateValueLiteral(DatabaseProvider provider, int columnType) throws UserError {
        String valueLiteral;
        String parameterValue = this.getParameterAsString("replenishment_value");
        int rmType = DbMetaDataTools.getRapidMinerTypeIndex(columnType);
        if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(rmType, 2)) {
            if (4 == columnType) {
                try {
                    valueLiteral = String.valueOf(Integer.parseInt(parameterValue));
                }
                catch (NumberFormatException e) {
                    throw new UserError((Operator)this, 225, new Object[]{"replenishment_value", parameterValue});
                }
            } else {
                try {
                    valueLiteral = String.valueOf(Double.parseDouble(parameterValue));
                }
                catch (NumberFormatException e) {
                    throw new UserError((Operator)this, 211, new Object[]{"replenishment_value", parameterValue});
                }
            }
        } else {
            valueLiteral = Ontology.ATTRIBUTE_VALUE_TYPE.isA(rmType, 9) ? provider.literal(DbTools.defaultFormat(parameterValue, rmType)) : provider.literal(parameterValue);
        }
        return valueLiteral;
    }

    public static enum ReplenishmentType {
        NONE(""),
        MINIMUM("MIN"),
        MAXIMUM("MAX"),
        AVERAGE("AVG"),
        ZERO(""),
        VALUE("");

        String aggregateFunction;

        private ReplenishmentType(String aggregateFunction) {
            this.aggregateFunction = aggregateFunction;
        }
    }
}

