/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.indatabase.operator;

import com.rapidminer.extension.indatabase.db.object.Column;
import com.rapidminer.extension.indatabase.db.object.ColumnExpr;
import com.rapidminer.extension.indatabase.db.step.DbStep;
import com.rapidminer.extension.indatabase.db.step.Select;
import com.rapidminer.extension.indatabase.exceptions.ConnectionEntryNotFound;
import com.rapidminer.extension.indatabase.exceptions.NestNotFoundException;
import com.rapidminer.extension.indatabase.exceptions.OperatorOrSetupError;
import com.rapidminer.extension.indatabase.metadata.DbMetaDataTools;
import com.rapidminer.extension.indatabase.operator.AbstractFilteredProcessing;
import com.rapidminer.extension.indatabase.provider.DatabaseProvider;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.SimpleProcessSetupError;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.Ontology;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class ReplaceValue
extends AbstractFilteredProcessing {
    private static final String REGEXP_CHARACTERS = ".+*[]()|{}\\$^";

    public ReplaceValue(OperatorDescription description) {
        super(description);
    }

    @Override
    public DbStep buildDbStepOnFilteredColumns(Set<String> columnSubset, DbStep input) throws OperatorOrSetupError, NestNotFoundException, UndefinedParameterError, ConnectionEntryNotFound {
        String replaceWhat = this.getParameterAsString("replace_what");
        String replaceBy = "";
        if (this.isParameterSet("replace_by")) {
            replaceBy = this.getParameterAsString("replace_by");
        }
        DatabaseProvider provider = this.getProvider();
        ArrayList<Column> selCols = new ArrayList<Column>();
        for (Column c : input.getColumnRefs(provider)) {
            boolean isNominal;
            int type = DbMetaDataTools.getRapidMinerTypeIndex(c.getType());
            boolean bl = isNominal = Ontology.ATTRIBUTE_VALUE_TYPE.isA(type, 1) || type == 0;
            if (isNominal && columnSubset.contains(c.getDestCol())) {
                selCols.add(new ColumnExpr(provider.generateReplaceExpr(c.getDestCol(), replaceWhat, replaceBy), c.getDestCol(), c.getType()));
                continue;
            }
            selCols.add(c);
        }
        return Select.builder().columns(selCols).from(input).build();
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeString type = new ParameterTypeString("replace_what", "A regular expression specifying what should be replaced.", false, false);
        type.setPrimary(true);
        types.add((ParameterType)type);
        type = new ParameterTypeString("replace_by", "The replacement for the region matched by the regular expression. Possibly including capturing groups.", true, false);
        types.add((ParameterType)type);
        return types;
    }

    @Override
    protected void performAdditionalChecks() {
        super.performAdditionalChecks();
        try {
            boolean containsSpecChar;
            DatabaseProvider provider = this.getProvider();
            String replaceWhat = this.getParameterAsString("replace_what");
            if (!provider.supportsRegexpInReplace() && (containsSpecChar = REGEXP_CHARACTERS.chars().anyMatch(c -> replaceWhat.indexOf((char)c) >= 0))) {
                this.addError((ProcessSetupError)new SimpleProcessSetupError(ProcessSetupError.Severity.WARNING, this.getPortOwner(), "indb.regexp_in_replace", new Object[]{"replace_what"}));
            }
        }
        catch (NestNotFoundException | OperatorOrSetupError | UndefinedParameterError object) {
            // empty catch block
        }
    }
}

