/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.indatabase.operator;

import com.google.api.client.util.Strings;
import com.rapidminer.example.Attribute;
import com.rapidminer.extension.indatabase.DbTools;
import com.rapidminer.extension.indatabase.db.object.Column;
import com.rapidminer.extension.indatabase.db.object.ForeignTable;
import com.rapidminer.extension.indatabase.db.object.Table;
import com.rapidminer.extension.indatabase.db.step.DbStep;
import com.rapidminer.extension.indatabase.db.step.Select;
import com.rapidminer.extension.indatabase.exceptions.NestNotFoundException;
import com.rapidminer.extension.indatabase.exceptions.OperatorOrSetupError;
import com.rapidminer.extension.indatabase.gui.TableParameterChooser;
import com.rapidminer.extension.indatabase.metadata.DbMetaDataTools;
import com.rapidminer.extension.indatabase.metadata.DbTableColumnMetaData;
import com.rapidminer.extension.indatabase.operator.AbstractNestedOperator;
import com.rapidminer.extension.indatabase.operator.Nest;
import com.rapidminer.extension.indatabase.provider.DatabaseProvider;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.SimpleProcessSetupError;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.ToTableMetaDataConverter;
import com.rapidminer.operator.ports.metadata.table.TableMetaData;
import com.rapidminer.operator.ports.metadata.table.TableMetaDataBuilder;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.LogService;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class RetrieveOperator
extends AbstractNestedOperator {
    private final OutputPort exampleSetOutput = (OutputPort)this.getOutputPorts().createPort("example set output");
    private final TableParameterChooser tableParameterChooser;
    private volatile MetaData cachedMetaData = null;
    private final Object MD_CACHE_LOCK = new Object();
    private volatile String cachedProjectName = "";
    private volatile String cachedSchemaName = "";
    private volatile String cachedTableName = "";

    public RetrieveOperator(OperatorDescription description) {
        super(description, false);
        this.tableParameterChooser = new TableParameterChooser(this, true);
        this.getTransformer().addRule(new MDTransformationRule(){

            public void transformMD() {
                RetrieveOperator.this.exampleSetOutput.deliverMD(RetrieveOperator.this.getGeneratedMetaData());
            }
        });
    }

    @Override
    protected OutputPort getOutputPort() {
        return this.exampleSetOutput;
    }

    public List<ParameterType> getParameterTypes() {
        List types = super.getParameterTypes();
        types.addAll(this.tableParameterChooser.getParameterTypes("Input table."));
        return types;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MetaData getGeneratedMetaData() {
        try {
            DatabaseProvider provider = this.getProvider();
            String currentProjectName = provider.supportsProjects() ? this.tableParameterChooser.getProjectName() : "";
            String currentSchemaName = this.getParameterAsString("schema_name");
            String currentTableName = this.getParameterAsString("table_name");
            boolean tableExists = this.tableParameterChooser.addProcessSetupErrors();
            if (!(!tableExists || this.cachedMetaData != null && this.cachedProjectName.equals(currentProjectName) && this.cachedSchemaName.equals(currentSchemaName) && this.cachedTableName.equals(currentTableName))) {
                Object object = this.MD_CACHE_LOCK;
                synchronized (object) {
                    if (!(this.cachedMetaData != null && this.cachedProjectName.equals(currentProjectName) && this.cachedSchemaName.equals(currentSchemaName) && this.cachedTableName.equals(currentTableName))) {
                        this.refreshMetaDataCache(currentProjectName, currentSchemaName, currentTableName);
                    }
                }
            } else if (!tableExists) {
                this.clearMetaDataCache();
            }
            return this.cachedMetaData;
        }
        catch (OperatorException provider) {
        }
        catch (OperatorOrSetupError e) {
            e.addSetupError(this);
        }
        return new TableMetaData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearMetaDataCache() {
        if (this.cachedMetaData != null) {
            Object object = this.MD_CACHE_LOCK;
            synchronized (object) {
                if (this.cachedMetaData != null) {
                    this.cachedMetaData = null;
                    this.cachedProjectName = "";
                    this.cachedSchemaName = "";
                    this.cachedTableName = "";
                }
            }
        }
    }

    private void refreshMetaDataCache(String currentProjectName, String currentSchemaName, String currentTableName) throws OperatorException {
        Nest nest = Nest.findParentNest(this);
        try {
            ExampleSetMetaData md = new ExampleSetMetaData();
            List<Attribute> attributes = Strings.isNullOrEmpty((String)currentProjectName) ? nest.getDbHandler().getColumnMetaData(currentSchemaName, currentTableName, false) : nest.getDbHandler().getColumnMetaData(currentProjectName, currentSchemaName, currentTableName, false);
            for (Attribute attribute : attributes) {
                AttributeMetaData amd = new AttributeMetaData(attribute.getName(), attribute.getValueType());
                amd.setNumberOfMissingValues(DbTableColumnMetaData.UNKNOWN_MDINTEGER);
                md.addAttribute(amd);
            }
            TableMetaData convertedMD = ToTableMetaDataConverter.convert((ExampleSetMetaData)md);
            convertedMD.addToHistory(this.exampleSetOutput);
            TableMetaDataBuilder builder = new TableMetaDataBuilder(convertedMD);
            DbMetaDataTools.writeColumnMetaData(builder, new DbTableColumnMetaData(this.getProvider(), this.buildDbStep(new DbStep[0])));
            this.cachedMetaData = builder.build();
            this.cachedProjectName = currentProjectName == null ? "" : currentProjectName;
            this.cachedSchemaName = currentSchemaName == null ? "" : currentSchemaName;
            this.cachedTableName = currentTableName == null ? "" : currentTableName;
        }
        catch (SQLException e) {
            LogService.getRoot().warning(e.getMessage());
            this.addError((ProcessSetupError)new SimpleProcessSetupError(ProcessSetupError.Severity.ERROR, this.getPortOwner(), Collections.emptyList(), "column_list", new Object[0]));
        }
        catch (OperatorOrSetupError e) {
            e.addSetupError(this);
        }
    }

    @Override
    public DbStep buildDbStep(DbStep ... inputs) throws UndefinedParameterError, NestNotFoundException, OperatorOrSetupError {
        Nest nest = Nest.findParentNest(this);
        try {
            Table sourceTable;
            List<Attribute> columnMetaData;
            DatabaseProvider provider = this.getProvider();
            String project = provider.supportsProjects() ? this.tableParameterChooser.getProjectName() : "";
            String schema = this.getParameterAsString("schema_name");
            String table = this.getParameterAsString("table_name");
            if (Strings.isNullOrEmpty((String)project)) {
                columnMetaData = nest.getDbHandler().getColumnMetaData(schema, table, this.isRunning());
                sourceTable = new Table(schema, table);
            } else {
                columnMetaData = nest.getDbHandler().getColumnMetaData(project, schema, table, this.isRunning());
                sourceTable = new ForeignTable(project, schema, table);
            }
            List<Column> columns = columnMetaData.stream().map(a -> new Column(a.getName(), DbMetaDataTools.getSqlType(a.getValueType()))).collect(Collectors.toList());
            return Select.builder().columns(columns).source(sourceTable).build();
        }
        catch (OperatorException e) {
            throw new OperatorOrSetupError().withOperatorException(e);
        }
        catch (SQLException e) {
            LogService.getRoot().warning(e.getMessage());
            throw new OperatorOrSetupError().withUserError(new UserError((Operator)this, "sql_error", new Object[]{DbTools.formatErrorMessage(e)})).withProcessSetupError(new ProcessSetupError[]{new SimpleProcessSetupError(ProcessSetupError.Severity.ERROR, this.getPortOwner(), "column_list", new Object[0])});
        }
    }
}

