/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.indatabase.operator;

import com.rapidminer.extension.indatabase.db.step.DbStep;
import com.rapidminer.extension.indatabase.db.step.Sample;
import com.rapidminer.extension.indatabase.operator.AbstractNestedOperator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeLong;
import com.rapidminer.parameter.UndefinedParameterError;
import java.util.List;

public class SampleOperator
extends AbstractNestedOperator {
    private static final String PARAMETER_OFFSET = "offset";

    public SampleOperator(OperatorDescription description) {
        super(description, true);
    }

    public List<ParameterType> getParameterTypes() {
        List types = super.getParameterTypes();
        ParameterTypeLong type = new ParameterTypeLong("sample_size", "The number of examples which should be sampled", 1L, Long.MAX_VALUE, 100L);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeLong(PARAMETER_OFFSET, "Offset of the first row to return. Indexing starts at 0, there is no offset by default.", 0L, Long.MAX_VALUE, 0L, true));
        return types;
    }

    @Override
    public DbStep buildDbStep(DbStep ... inputs) throws UndefinedParameterError {
        return Sample.builder().from(inputs[0]).limit(this.getParameterAsLong("sample_size")).offset(this.getParameterAsLong(PARAMETER_OFFSET)).build();
    }
}

