/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.indatabase.operator;

import com.rapidminer.extension.indatabase.db.step.AbsoluteSample;
import com.rapidminer.extension.indatabase.db.step.DbStep;
import com.rapidminer.extension.indatabase.db.step.ProbabilitySample;
import com.rapidminer.extension.indatabase.db.step.Select;
import com.rapidminer.extension.indatabase.exceptions.ConnectionEntryNotFound;
import com.rapidminer.extension.indatabase.exceptions.NestNotFoundException;
import com.rapidminer.extension.indatabase.exceptions.OperatorOrSetupError;
import com.rapidminer.extension.indatabase.operator.AbstractNestedOperator;
import com.rapidminer.extension.indatabase.provider.DatabaseProvider;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.SimpleProcessSetupError;
import com.rapidminer.operator.UserError;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeLong;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.EqualTypeCondition;
import com.rapidminer.parameter.conditions.ParameterCondition;
import com.rapidminer.tools.RandomGenerator;
import java.util.List;

public class SamplingOperator
extends AbstractNestedOperator {
    public static final String PARAMETER_SAMPLE_TYPE = "sample";
    public static final int ABSOLUTE_INDEX = 0;
    public static final int PROBABILITY_INDEX = 1;
    public static final String PARAMETER_SAMPLE_SIZE = "sample_size";
    public static final String PARAMETER_PROBABILITY = "sample_probability";
    public static final long DEFAULT_SAMPLE = 100L;
    public static final double DEFAULT_PROBABILITY = 0.1;
    protected static final String[] PARAMETER_SAMPLE_TYPE_VALUES = new String[]{"absolute", "probability"};

    public SamplingOperator(OperatorDescription description) {
        super(description, true);
    }

    public List<ParameterType> getParameterTypes() {
        List parameterTypes = super.getParameterTypes();
        ParameterTypeCategory sampleSelector = new ParameterTypeCategory(PARAMETER_SAMPLE_TYPE, "This parameter determines how the amount of data is specified.", PARAMETER_SAMPLE_TYPE_VALUES, 0, false);
        parameterTypes.add(sampleSelector);
        ParameterTypeLong sampleSize = new ParameterTypeLong(PARAMETER_SAMPLE_SIZE, "The number of examples which should be sampled.", 1L, Long.MAX_VALUE, 100L, false);
        sampleSize.setPrimary(true);
        sampleSize.registerDependencyCondition((ParameterCondition)new EqualTypeCondition((ParameterHandler)this, PARAMETER_SAMPLE_TYPE, PARAMETER_SAMPLE_TYPE_VALUES, true, new int[]{0}));
        parameterTypes.add(sampleSize);
        ParameterTypeDouble sampleProbability = new ParameterTypeDouble(PARAMETER_PROBABILITY, "This parameter specifies the sample probability. Note that neither the sample nor the sample size is guaranteed to be deterministic without a seed value.", 0.0, 1.0, 0.1, false);
        sampleProbability.setPrimary(true);
        sampleProbability.registerDependencyCondition((ParameterCondition)new EqualTypeCondition((ParameterHandler)this, PARAMETER_SAMPLE_TYPE, PARAMETER_SAMPLE_TYPE_VALUES, true, new int[]{1}));
        parameterTypes.add(sampleProbability);
        List seedTypes = RandomGenerator.getRandomGeneratorParameters((Operator)this);
        seedTypes.forEach(t -> t.registerDependencyCondition((ParameterCondition)new EqualTypeCondition((ParameterHandler)this, PARAMETER_SAMPLE_TYPE, PARAMETER_SAMPLE_TYPE_VALUES, true, new int[]{1})));
        parameterTypes.addAll(seedTypes);
        return parameterTypes;
    }

    @Override
    public DbStep buildDbStep(DbStep ... inputs) throws UndefinedParameterError, NestNotFoundException, ConnectionEntryNotFound, OperatorOrSetupError {
        boolean useSeed;
        DatabaseProvider provider = this.getProvider();
        String sampleType = this.getParameterAsString(PARAMETER_SAMPLE_TYPE);
        boolean bl = useSeed = PARAMETER_SAMPLE_TYPE_VALUES[1].equals(sampleType) && this.getParameterAsBoolean("use_local_random_seed");
        if (useSeed && !provider.supportsRandomSeed()) {
            throw new OperatorOrSetupError().withProcessSetupError(new ProcessSetupError[]{new SimpleProcessSetupError(ProcessSetupError.Severity.ERROR, this.getPortOwner(), "no_seed_in_provider", new Object[]{provider.getId()})}).withUserError(new UserError((Operator)this, "no_seed_in_provider", new Object[]{provider.getId()}));
        }
        if (PARAMETER_SAMPLE_TYPE_VALUES[0].equals(sampleType)) {
            return AbsoluteSample.builder().from(inputs[0]).limit(this.getParameterAsLong(PARAMETER_SAMPLE_SIZE)).build();
        }
        long seed = useSeed ? this.getParameterAsLong("local_random_seed") : 2001L;
        double probability = this.getParameterAsDouble(PARAMETER_PROBABILITY);
        if (probability == 0.0) {
            return AbsoluteSample.builder().from(inputs[0]).limit(0L).build();
        }
        if (probability == 1.0) {
            return Select.builder().columns(inputs[0].getColumnRefs(provider)).from(inputs[0]).build();
        }
        return ProbabilitySample.builder().from(inputs[0]).probability(probability).useSeed(useSeed).seed(seed).build();
    }
}

