/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.indatabase.operator;

import com.rapidminer.example.set.SortedExampleSet;
import com.rapidminer.extension.indatabase.db.object.Column;
import com.rapidminer.extension.indatabase.db.step.DbStep;
import com.rapidminer.extension.indatabase.db.step.Sort;
import com.rapidminer.extension.indatabase.exceptions.ConnectionEntryNotFound;
import com.rapidminer.extension.indatabase.exceptions.NestNotFoundException;
import com.rapidminer.extension.indatabase.exceptions.OperatorOrSetupError;
import com.rapidminer.extension.indatabase.operator.AbstractNestedOperator;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.SimpleProcessSetupError;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.error.AttributeNotFoundError;
import com.rapidminer.operator.ports.metadata.AttributeSetPrecondition;
import com.rapidminer.operator.ports.metadata.Precondition;
import com.rapidminer.operator.ports.quickfix.ParameterSettingQuickFix;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeAttribute;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.UndefinedParameterError;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class SortOperator
extends AbstractNestedOperator {
    public static final String PARAMETER_SORTING_ATTRIBUTES = "sorting_attributes";

    public SortOperator(OperatorDescription description) {
        super(description, true);
        this.getInputPort().addPrecondition((Precondition)new AttributeSetPrecondition(this.getInputPort(), AttributeSetPrecondition.getAttributesByParameterListEntry((ParameterHandler)this, (String)PARAMETER_SORTING_ATTRIBUTES, (int)0), new String[0]));
    }

    public List<ParameterType> getParameterTypes() {
        List types = super.getParameterTypes();
        ParameterTypeList type = new ParameterTypeList(PARAMETER_SORTING_ATTRIBUTES, "List of the additional sorting attributes and the corresponding sorting directions", (ParameterType)new ParameterTypeAttribute("attribute_name", "Attribute", this.getInputPort(), false), (ParameterType)new ParameterTypeCategory("sorting_direction", "Sorting direction", SortedExampleSet.SORTING_DIRECTIONS, 0, false), false);
        types.add(type);
        return types;
    }

    @Override
    public DbStep buildDbStep(DbStep ... inputs) throws UndefinedParameterError, NestNotFoundException, ConnectionEntryNotFound, OperatorOrSetupError {
        List sortColumns = this.getParameterList(PARAMETER_SORTING_ATTRIBUTES);
        if (sortColumns.isEmpty()) {
            throw new OperatorOrSetupError().withUserError(new UserError((Operator)this, "sort.no_params")).withProcessSetupError(new ProcessSetupError[]{new SimpleProcessSetupError(ProcessSetupError.Severity.ERROR, this.getPortOwner(), Collections.singletonList(new ParameterSettingQuickFix((Operator)this, PARAMETER_SORTING_ATTRIBUTES)), "sort.no_params", new Object[0])});
        }
        Set inputAttrs = inputs[0].getColumns(this.getProvider()).stream().map(Column::getDestCol).collect(Collectors.toSet());
        for (String[] c2 : sortColumns) {
            if (inputAttrs.contains(c2[0])) continue;
            throw new OperatorOrSetupError().withUserError((UserError)new AttributeNotFoundError((Operator)this, "attribute_name", c2[0]));
        }
        return Sort.builder().from(inputs[0]).by(sortColumns.stream().map(c -> new Sort.SortColumn(new Column(c[0]), SortedExampleSet.SORTING_DIRECTIONS[0].equals(c[1]) ? Sort.SortType.ASCENDING : Sort.SortType.DESCENDING)).collect(Collectors.toList())).build();
    }
}

