/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.indatabase.operator;

import com.rapidminer.Process;
import com.rapidminer.extension.indatabase.DbTools;
import com.rapidminer.extension.indatabase.data.DbTableExampleSet;
import com.rapidminer.extension.indatabase.data.OverwriteMode;
import com.rapidminer.extension.indatabase.db.CachedDatabaseHandler;
import com.rapidminer.extension.indatabase.db.object.Column;
import com.rapidminer.extension.indatabase.db.object.Table;
import com.rapidminer.extension.indatabase.db.step.DbStep;
import com.rapidminer.extension.indatabase.db.step.Select;
import com.rapidminer.extension.indatabase.exceptions.NestNotFoundException;
import com.rapidminer.extension.indatabase.exceptions.OperatorOrSetupError;
import com.rapidminer.extension.indatabase.gui.TableParameterChooser;
import com.rapidminer.extension.indatabase.metadata.DbMetaDataTools;
import com.rapidminer.extension.indatabase.operator.AbstractNestedOperator;
import com.rapidminer.extension.indatabase.operator.Nest;
import com.rapidminer.extension.indatabase.provider.DatabaseProvider;
import com.rapidminer.extension.indatabase.provider.impala.ImpalaProvider;
import com.rapidminer.extension.indatabase.provider.impala.ImpalaStorageFormat;
import com.rapidminer.extension.indatabase.provider.impala.KuduPrimaryKeyException;
import com.rapidminer.extension.indatabase.provider.storage.CreateTableOptions;
import com.rapidminer.extension.indatabase.provider.storage.StorageFormat;
import com.rapidminer.gui.tools.VersionNumber;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.OperatorVersion;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.SimpleProcessSetupError;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.quickfix.ParameterSettingQuickFix;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeAttributeSubset;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.ParameterTypeText;
import com.rapidminer.parameter.TextType;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.AboveOperatorVersionCondition;
import com.rapidminer.parameter.conditions.BelowOrEqualOperatorVersionCondition;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.parameter.conditions.EqualStringCondition;
import com.rapidminer.parameter.conditions.NonEqualStringCondition;
import com.rapidminer.parameter.conditions.ParameterCondition;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.Tools;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class StoreOperator
extends AbstractNestedOperator {
    private static final String PARAMETER_OVERWRITE = "overwrite";
    private static final String PARAMETER_OVERWRITE_MODE = "overwrite_mode";
    private static final String PARAMETER_STORAGE_FORMAT = "storage_format";
    private static final String PARAMETER_CUSTOMIZE_STORAGE = "customize_storage";
    private static final String PARAMETER_PARTITION_BY = "partition_by";
    private static final String PARAMETER_PRIMARY_KEY = "primary_key";
    private static final String PARAMETER_NON_UNIQUE_PK = "non_unique_primary_key";
    private static final String PARAMETER_TABLE_COMMENT = "table_comment";
    private static final String PARAMETER_TBL_PROPERTIES = "table_properties";
    private static final String PARAMETER_SERDE_PROPERTIES = "serde_properties";
    private static final String PARAMETER_LOCATION = "location";
    private static final String PARAMETER_EXTERNAL = "external";
    private static final String PARAMETER_ROW_FORMAT = "row_format";
    private static final String[] OVERWRITE_MODES = (String[])Arrays.stream(OverwriteMode.values()).map(val -> val.name().toLowerCase(Locale.ENGLISH)).toArray(String[]::new);
    private static final int OVERWRITE_MODE_NONE = OverwriteMode.NONE.ordinal();
    private static final int OVERWRITE_MODE_OVERWRITE = OverwriteMode.OVERWRITE.ordinal();
    public static final OperatorVersion VERSION_WITHOUT_APPEND = new OperatorVersion(10, 3, 0);
    private final TableParameterChooser tableParameterChooser = new TableParameterChooser(this, false);

    protected void registerOperator(Process process) {
        super.registerOperator(process);
    }

    public StoreOperator(OperatorDescription description) {
        super(description, true);
    }

    public List<ParameterType> getParameterTypes() {
        List types = super.getParameterTypes();
        types.addAll(this.tableParameterChooser.getParameterTypes("Output table."));
        types.add(new ParameterTypeCategory(PARAMETER_OVERWRITE_MODE, "Indicates if an existing table should be overwritten or if data should be appended.", OVERWRITE_MODES, OVERWRITE_MODE_NONE));
        ParameterTypeBoolean overwriteParam = new ParameterTypeBoolean(PARAMETER_OVERWRITE, "If it's enabled, the operator will drop the table and recreate it using the input data. If it's disabled, and the specified table already exists, then the execution will fail. WARNING: enabling this parameter may result in data loss.", false, true);
        overwriteParam.registerDependencyCondition((ParameterCondition)new BelowOrEqualOperatorVersionCondition((Operator)this, (VersionNumber)VERSION_WITHOUT_APPEND));
        types.add(overwriteParam);
        ParameterTypeCategory overwriteModeParam = new ParameterTypeCategory(PARAMETER_OVERWRITE_MODE, "Indicates if an existing table should be overwritten or if data should be appended.", OVERWRITE_MODES, OVERWRITE_MODE_NONE);
        overwriteModeParam.registerDependencyCondition((ParameterCondition)new AboveOperatorVersionCondition((Operator)this, (VersionNumber)VERSION_WITHOUT_APPEND));
        types.add(overwriteModeParam);
        types.addAll(this.getStorageParamTypes());
        return types;
    }

    private List<ParameterType> getStorageParamTypes() {
        List<String> storageFormatNamesList = this.getStorageFormatNames();
        int defaultIndex = storageFormatNamesList.indexOf(StorageFormat.DEFAULT.getName());
        ParameterTypeCategory storageFormatParam = new ParameterTypeCategory(PARAMETER_STORAGE_FORMAT, "Storage format", (String[])storageFormatNamesList.toArray(String[]::new), defaultIndex);
        ParameterTypeBoolean customizeStorageParam = new ParameterTypeBoolean(PARAMETER_CUSTOMIZE_STORAGE, "Enable custom storage format options.", false, true);
        ParameterTypeAttributeSubset primaryKeyParam = new ParameterTypeAttributeSubset(PARAMETER_PRIMARY_KEY, "Kudu primary key", this.getInputPort(), true){

            protected boolean isFilteredOut(AttributeMetaData amd) {
                return !ImpalaProvider.isAllowedKuduPkType(DbMetaDataTools.getSqlType(amd.getValueType()));
            }
        };
        primaryKeyParam.setExpert(true);
        ParameterTypeBoolean nonUniquePKParam = new ParameterTypeBoolean(PARAMETER_NON_UNIQUE_PK, "Non-uniqe Kudu primaru key", false, true);
        nonUniquePKParam.setExpert(true);
        ParameterTypeText partitionByParam = new ParameterTypeText(PARAMETER_PARTITION_BY, "Partition by clause", TextType.SQL, true);
        partitionByParam.setExpert(true);
        ParameterTypeString tableCommentParam = new ParameterTypeString(PARAMETER_TABLE_COMMENT, "Table comment", "", true);
        tableCommentParam.setExpert(true);
        ParameterTypeList tblPropertiesParam = new ParameterTypeList(PARAMETER_TBL_PROPERTIES, "Table properties", (ParameterType)new ParameterTypeString("key", "key"), (ParameterType)new ParameterTypeString("value", "value"));
        tblPropertiesParam.setExpert(true);
        ParameterTypeList serdePropertiesParam = new ParameterTypeList(PARAMETER_SERDE_PROPERTIES, "SerDe properties", (ParameterType)new ParameterTypeString("key", "key"), (ParameterType)new ParameterTypeString("value", "value"), true);
        serdePropertiesParam.setExpert(true);
        serdePropertiesParam.setOptional(true);
        ParameterTypeString locationParam = new ParameterTypeString(PARAMETER_LOCATION, "LOCATION clause", "", true);
        locationParam.setExpert(true);
        ParameterTypeBoolean externalParam = new ParameterTypeBoolean(PARAMETER_EXTERNAL, "EXTERNAL table", false, true);
        externalParam.setExpert(true);
        ParameterTypeString rowFormatParam = new ParameterTypeString(PARAMETER_ROW_FORMAT, "ROW FORMAT clause", "", true);
        rowFormatParam.setExpert(true);
        List<ParameterType> storageParams = List.of(storageFormatParam, primaryKeyParam, nonUniquePKParam, customizeStorageParam, externalParam, partitionByParam, locationParam, rowFormatParam, serdePropertiesParam, tblPropertiesParam, tableCommentParam);
        ParameterCondition isCreateTableCondition = new ParameterCondition((ParameterHandler)this, false){

            public boolean isConditionFullfilled() {
                try {
                    return StoreOperator.this.isCreateNewTable();
                }
                catch (UndefinedParameterError e) {
                    return false;
                }
            }
        };
        BooleanParameterCondition isCustomCondition = new BooleanParameterCondition((ParameterHandler)this, PARAMETER_CUSTOMIZE_STORAGE, false, true);
        EqualStringCondition isKuduCondition = new EqualStringCondition((ParameterHandler)this, PARAMETER_STORAGE_FORMAT, false, new String[]{ImpalaStorageFormat.KUDU.getName()});
        NonEqualStringCondition notKuduCondition = new NonEqualStringCondition((ParameterHandler)this, PARAMETER_STORAGE_FORMAT, false, new String[]{ImpalaStorageFormat.KUDU.getName()});
        ParameterCondition isCustomFormatEnabledCondition = new ParameterCondition((ParameterHandler)this, false){

            public boolean isConditionFullfilled() {
                try {
                    DatabaseProvider provider = StoreOperator.this.getActualOrDeclaredProvider();
                    return provider.isCustomFormatEnabled();
                }
                catch (NestNotFoundException | Nest.DatabaseProviderNotInitialized e) {
                    return false;
                }
            }
        };
        storageParams.forEach(p -> {
            p.registerDependencyCondition(isCreateTableCondition);
            p.registerDependencyCondition(isCustomFormatEnabledCondition);
        });
        List.of(tblPropertiesParam, tableCommentParam, partitionByParam, serdePropertiesParam, locationParam, externalParam, rowFormatParam).forEach(arg_0 -> StoreOperator.lambda$getStorageParamTypes$4((ParameterCondition)isCustomCondition, arg_0));
        List.of(primaryKeyParam, nonUniquePKParam).forEach(arg_0 -> StoreOperator.lambda$getStorageParamTypes$5((ParameterCondition)isKuduCondition, arg_0));
        List.of(externalParam, serdePropertiesParam, locationParam, rowFormatParam).forEach(arg_0 -> StoreOperator.lambda$getStorageParamTypes$6((ParameterCondition)notKuduCondition, arg_0));
        return storageParams;
    }

    @Override
    protected void performAdditionalChecks() {
        block5: {
            super.performAdditionalChecks();
            this.checkIfTableExistsAndOverwriteModeIsOff();
            try {
                if (!this.isKuduStorage() || !this.isCreateNewTable()) break block5;
                try {
                    this.checkKuduPrimaryKey(Nest.findParentNest(this).getProvider());
                }
                catch (KuduPrimaryKeyException e) {
                    if (e.isMissing()) {
                        this.addError((ProcessSetupError)new SimpleProcessSetupError(ProcessSetupError.Severity.ERROR, this.getPortOwner(), List.of(new ParameterSettingQuickFix((Operator)this, PARAMETER_PRIMARY_KEY), new ParameterSettingQuickFix((Operator)this, PARAMETER_PARTITION_BY)), "kudu_pk_missing", new Object[0]));
                        break block5;
                    }
                    String str = e.getInvalidColumns().stream().map(col -> String.format("'%s' (%s)", col.getDestCol(), ImpalaProvider.getImpalaTypeString(col.getType()))).collect(Collectors.joining(", "));
                    this.addError((ProcessSetupError)new SimpleProcessSetupError(ProcessSetupError.Severity.ERROR, this.getPortOwner(), List.of(new ParameterSettingQuickFix((Operator)this, PARAMETER_PRIMARY_KEY)), "kudu_pk", new Object[]{str, ImpalaProvider.getInvalidKuduPkTypesString()}));
                }
            }
            catch (NestNotFoundException | Nest.DatabaseProviderNotInitialized | UndefinedParameterError throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public void doWork() throws OperatorException {
        CachedDatabaseHandler dbHandler;
        Nest nest;
        DbTableExampleSet input;
        block8: {
            this.getProgress().setIndeterminate(true);
            input = (DbTableExampleSet)this.getInputPort().getData(DbTableExampleSet.class);
            nest = Nest.findParentNest(this);
            DatabaseProvider provider = nest.getProvider();
            dbHandler = nest.getDbHandler();
            if (provider instanceof ImpalaProvider) {
                try {
                    this.checkKuduPrimaryKey(provider);
                }
                catch (KuduPrimaryKeyException e) {
                    if (e.isMissing() && this.isPartitionByDefined()) break block8;
                    throw new UserError((Operator)this, "kudu_pk", new Object[]{e.getInvalidColumnsString(), ImpalaProvider.getInvalidKuduPkTypesString()});
                }
            }
        }
        String schema = this.getParameterAsString("schema_name");
        String tableName = this.getParameterAsString("table_name");
        try {
            try {
                boolean exists = dbHandler.tableExists(schema, tableName, true);
                int overwriteMode = this.getOverwriteMode();
                if (exists && overwriteMode == OVERWRITE_MODE_NONE) {
                    throw new SQLException("Table with name '" + tableName + "' already exists and overwriting mode is not activated." + Tools.getLineSeparator() + "Please change table name or activate overwriting mode.");
                }
                Table table = new Table(schema, tableName);
                input.materializeAs(nest, table, OverwriteMode.values()[overwriteMode], this.getCreateTableOptions());
                List<Column> columns = dbHandler.getColumnMetaData(schema, tableName, true).stream().map(a -> new Column(a.getName(), DbMetaDataTools.getSqlType(a.getValueType()))).collect(Collectors.toList());
                this.getOutputPort().deliver((IOObject)this.handleBreakpoints(this.getOutputPort(), new DbTableExampleSet(this.getProvider(), Select.builder().columns(columns).source(table).build())));
            }
            catch (OperatorOrSetupError e) {
                e.throwOperatorException();
            }
        }
        catch (SQLException e) {
            throw new UserError((Operator)this, (Throwable)e, "sql_error", new Object[]{DbTools.formatErrorMessage(e)});
        }
    }

    @Override
    public DbStep buildDbStep(DbStep ... inputs) {
        return inputs[0];
    }

    private CreateTableOptions getCreateTableOptions() throws UndefinedParameterError, NestNotFoundException, UserError {
        String storageFormat = this.getParameterAsString(PARAMETER_STORAGE_FORMAT);
        boolean isCustom = this.getParameterAsBoolean(PARAMETER_CUSTOMIZE_STORAGE);
        if (StorageFormat.DEFAULT.getName().equals(storageFormat) && !isCustom) {
            return CreateTableOptions.DEFAULT;
        }
        CreateTableOptions.CreateTableOptionsBuilder tableBuilder = CreateTableOptions.builder();
        if (isCustom) {
            String comment = this.getParameterAsString(PARAMETER_TABLE_COMMENT);
            String location = this.getParameterAsString(PARAMETER_LOCATION);
            String rowFormat = this.getParameterAsString(PARAMETER_ROW_FORMAT);
            tableBuilder.storedAs(storageFormat).partitionBy(this.getParameterAsString(PARAMETER_PARTITION_BY)).comment(comment != null && !comment.trim().isEmpty() ? comment : null).location(location != null && !location.trim().isEmpty() ? location : null).rowFormat(rowFormat != null && !rowFormat.trim().isEmpty() ? rowFormat : null).external(this.getParameterAsBoolean(PARAMETER_EXTERNAL)).tblProperties(this.getPropertyMap(PARAMETER_TBL_PROPERTIES)).serdeProperties(this.getPropertyMap(PARAMETER_SERDE_PROPERTIES));
        } else {
            tableBuilder.storedAs(storageFormat);
        }
        if (this.isKuduStorage()) {
            tableBuilder.primaryKeyColumns(this.getPrimaryKeyColumns()).nonUniquePK(this.getParameterAsBoolean(PARAMETER_NON_UNIQUE_PK));
        }
        return tableBuilder.build();
    }

    private Map<String, String> getPropertyMap(String parameterKey) throws UndefinedParameterError {
        return this.getParameterList(parameterKey).stream().filter(property -> property[0] != null && !property[0].trim().isEmpty()).collect(Collectors.toMap(p -> p[0], p -> p[1] != null ? p[1] : "", (v1, v2) -> v1, LinkedHashMap::new));
    }

    private int getOverwriteMode() throws UndefinedParameterError {
        int overwriteMode = this.getCompatibilityLevel().isAbove((VersionNumber)VERSION_WITHOUT_APPEND) ? this.getParameterAsInt(PARAMETER_OVERWRITE_MODE) : (this.getParameterAsBoolean(PARAMETER_OVERWRITE) ? OVERWRITE_MODE_OVERWRITE : OVERWRITE_MODE_NONE);
        return overwriteMode;
    }

    private boolean isPartitionByDefined() {
        try {
            if (this.getParameterAsBoolean(PARAMETER_CUSTOMIZE_STORAGE)) {
                String partitionBy = this.getParameterAsString(PARAMETER_PARTITION_BY);
                return partitionBy != null && !partitionBy.trim().isEmpty();
            }
        }
        catch (UndefinedParameterError undefinedParameterError) {
            // empty catch block
        }
        return false;
    }

    private boolean isKuduStorage() throws UndefinedParameterError {
        return ImpalaStorageFormat.KUDU.getName().equals(this.getParameterAsString(PARAMETER_STORAGE_FORMAT));
    }

    private List<String> getPrimaryKeyColumns() throws UndefinedParameterError {
        return Arrays.asList(this.getParameterAsString(PARAMETER_PRIMARY_KEY).split("\u241e")).stream().filter(col -> col != null && !col.isEmpty()).collect(Collectors.toList());
    }

    private boolean isCreateNewTable() throws UndefinedParameterError {
        return Set.of(Integer.valueOf(OVERWRITE_MODE_OVERWRITE), Integer.valueOf(OVERWRITE_MODE_NONE)).contains(this.getOverwriteMode());
    }

    private List<String> getStorageFormatNames() {
        try {
            DatabaseProvider provider = this.getActualOrDeclaredProvider();
            return provider.getSupportedStorageFormats().stream().map(StorageFormat::getName).collect(Collectors.toList());
        }
        catch (NestNotFoundException | Nest.DatabaseProviderNotInitialized ignored) {
            return List.of(StorageFormat.DEFAULT.getName());
        }
    }

    public OperatorVersion[] getIncompatibleVersionChanges() {
        return new OperatorVersion[]{VERSION_WITHOUT_APPEND};
    }

    public void setCompatibilityLevel(OperatorVersion compatibilityLevel) {
        if (this.getCompatibilityLevel() != null && !this.getCompatibilityLevel().equals((Object)compatibilityLevel)) {
            if (compatibilityLevel != null && compatibilityLevel.isAbove((VersionNumber)VERSION_WITHOUT_APPEND) && this.getParameterAsBoolean(PARAMETER_OVERWRITE)) {
                this.setParameter(PARAMETER_OVERWRITE_MODE, OverwriteMode.OVERWRITE.name().toLowerCase(Locale.ENGLISH));
            }
            if (compatibilityLevel != null && !compatibilityLevel.isAbove((VersionNumber)VERSION_WITHOUT_APPEND)) {
                try {
                    if (this.getParameterAsInt(PARAMETER_OVERWRITE_MODE) == OVERWRITE_MODE_OVERWRITE) {
                        this.setParameter(PARAMETER_OVERWRITE, "true");
                    } else {
                        this.setParameter(PARAMETER_OVERWRITE, "false");
                    }
                }
                catch (UndefinedParameterError e) {
                    LogService.getRoot().finest(String.format("Parameter '%s' does not exist in current workflow", PARAMETER_OVERWRITE_MODE));
                }
            }
        }
        super.setCompatibilityLevel(compatibilityLevel);
    }

    private void checkIfTableExistsAndOverwriteModeIsOff() {
        int overwriteMode;
        try {
            overwriteMode = this.getParameterAsInt(PARAMETER_OVERWRITE_MODE);
        }
        catch (UndefinedParameterError e) {
            throw new RuntimeException(e);
        }
        if (overwriteMode == OVERWRITE_MODE_NONE) {
            Nest nest = null;
            try {
                String schema;
                nest = Nest.findParentNest(this);
                try {
                    schema = this.getParameterAsString("schema_name");
                }
                catch (UndefinedParameterError undefinedParameterError) {
                    schema = "";
                }
                try {
                    String table = this.getParameterAsString("table_name");
                    if (nest.getDbHandler().tableExists(schema, table, false)) {
                        this.addOverwriteNotEnabledAndTableExistsWarning(schema, table);
                    }
                }
                catch (UndefinedParameterError table) {
                }
                catch (OperatorException | SQLException e) {
                    LogService.getRoot().finest("During process validation the following error is raised: '" + e.getMessage());
                }
            }
            catch (NestNotFoundException e) {
                LogService.getRoot().finest("During process validation the following error is raised: '" + e.getMessage());
            }
        }
    }

    private void addOverwriteNotEnabledAndTableExistsWarning(String schema, String table) {
        ArrayList<ParameterSettingQuickFix> quickFixes = new ArrayList<ParameterSettingQuickFix>();
        quickFixes.add(new ParameterSettingQuickFix((Operator)this, PARAMETER_OVERWRITE_MODE));
        quickFixes.add(new ParameterSettingQuickFix((Operator)this, "table_name"));
        quickFixes.add(new ParameterSettingQuickFix((Operator)this, "schema_name"));
        this.addError((ProcessSetupError)new SimpleProcessSetupError(ProcessSetupError.Severity.WARNING, this.getPortOwner(), quickFixes, "table_already_exists", new Object[]{schema, table}));
    }

    private void checkKuduPrimaryKey(DatabaseProvider provider) throws KuduPrimaryKeyException {
        try {
            if (this.isKuduStorage() && this.isCreateNewTable()) {
                List<Column> columns;
                Set invalidColumns;
                List<String> pkColumnNames = this.getPrimaryKeyColumns();
                if (pkColumnNames.isEmpty() && !this.isPartitionByDefined()) {
                    throw new KuduPrimaryKeyException();
                }
                DbTableExampleSet input = (DbTableExampleSet)this.getInputPort().getData(DbTableExampleSet.class);
                if (input != null && !(invalidColumns = (Set)(columns = input.getDbStep().getColumns(provider)).stream().filter(column -> pkColumnNames.contains(column.getDestCol())).filter(column -> !ImpalaProvider.isAllowedKuduPkType(column.getType())).collect(Collectors.toCollection(LinkedHashSet::new))).isEmpty()) {
                    throw new KuduPrimaryKeyException(invalidColumns);
                }
            }
        }
        catch (UserError e) {
            LogService.getRoot().finest("During process validation the following error is raised: " + e.getMessage());
        }
    }

    private DatabaseProvider getActualOrDeclaredProvider() throws NestNotFoundException, Nest.DatabaseProviderNotInitialized {
        try {
            return Nest.findParentNest(this).getProvider();
        }
        catch (Nest.DatabaseProviderNotInitialized e) {
            try {
                return Nest.findParentNest(this).getCurrentProvider();
            }
            catch (Nest.CouldNotRetrieveConnectionInformation | OperatorException e1) {
                throw new Nest.DatabaseProviderNotInitialized(Nest.findParentNest(this));
            }
        }
    }

    private static /* synthetic */ void lambda$getStorageParamTypes$6(ParameterCondition notKuduCondition, ParameterType p) {
        p.registerDependencyCondition(notKuduCondition);
    }

    private static /* synthetic */ void lambda$getStorageParamTypes$5(ParameterCondition isKuduCondition, ParameterTypeSingle p) {
        p.registerDependencyCondition(isKuduCondition);
    }

    private static /* synthetic */ void lambda$getStorageParamTypes$4(ParameterCondition isCustomCondition, ParameterType p) {
        p.registerDependencyCondition(isCustomCondition);
    }
}

