/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.indatabase.operator;

import com.rapidminer.extension.indatabase.db.step.DbStep;
import com.rapidminer.extension.indatabase.db.step.Union;
import com.rapidminer.extension.indatabase.exceptions.ConnectionEntryNotFound;
import com.rapidminer.extension.indatabase.exceptions.NestNotFoundException;
import com.rapidminer.extension.indatabase.exceptions.OperatorOrSetupError;
import com.rapidminer.extension.indatabase.metadata.DbMetaDataTools;
import com.rapidminer.extension.indatabase.metadata.DbTableColumnMetaData;
import com.rapidminer.extension.indatabase.operator.AbstractNestedOperator;
import com.rapidminer.extension.indatabase.provider.DatabaseProvider;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.SimpleProcessSetupError;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.table.TableMetaData;
import com.rapidminer.operator.ports.metadata.table.TableUnionRule;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.UndefinedParameterError;
import java.util.List;

public class UnionOperator
extends AbstractNestedOperator {
    private InputPort exampleSet1Input = this.createInputPortWithPrecondition("example set 1");
    private InputPort exampleSet2Input = this.createInputPortWithPrecondition("example set 2");
    private OutputPort unionOutput = (OutputPort)this.getOutputPorts().createPort("union");
    private static final String PARAMETER_REMOVE_DUPLICATES = "remove_duplicates";

    public UnionOperator(OperatorDescription description) {
        super(description, false);
        this.getTransformer().addRule((MDTransformationRule)new TableUnionRule(this.exampleSet1Input, this.exampleSet2Input, this.unionOutput, null){

            protected TableMetaData modifyMetaData(TableMetaData firstMD, TableMetaData secondMD) {
                DbTableColumnMetaData firstDbcmd = DbMetaDataTools.readColumnMetaData(firstMD);
                DbTableColumnMetaData secondDbcmd = DbMetaDataTools.readColumnMetaData(secondMD);
                TableMetaData defaultOutput = new TableMetaData();
                if (firstDbcmd != null && secondDbcmd != null) {
                    try {
                        DbStep dbStep = UnionOperator.this.buildDbStep(firstDbcmd.getDbStep(), secondDbcmd.getDbStep());
                        TableMetaData md = DbMetaDataTools.buildTableMetaData(UnionOperator.this.getProvider(), dbStep);
                        md.addToHistory(UnionOperator.this.getOutputPort());
                        return md;
                    }
                    catch (ConnectionEntryNotFound | NestNotFoundException | UndefinedParameterError e) {
                        return defaultOutput;
                    }
                    catch (OperatorOrSetupError e) {
                        e.addSetupError(UnionOperator.this);
                        return defaultOutput;
                    }
                }
                return defaultOutput;
            }
        });
    }

    @Override
    protected OutputPort getOutputPort() {
        return this.unionOutput;
    }

    public List<ParameterType> getParameterTypes() {
        List types = super.getParameterTypes();
        types.add(new ParameterTypeBoolean(PARAMETER_REMOVE_DUPLICATES, "Check to remove duplicates examples while creating the union.", false, false));
        return types;
    }

    @Override
    public DbStep buildDbStep(DbStep ... inputs) throws OperatorOrSetupError, UndefinedParameterError, NestNotFoundException, ConnectionEntryNotFound {
        this.checkCompatibility(this.getProvider(), inputs[0], inputs[1]);
        return Union.builder().left(inputs[0]).right(inputs[1]).all(!this.getParameterAsBoolean(PARAMETER_REMOVE_DUPLICATES)).build();
    }

    private void checkCompatibility(DatabaseProvider provider, DbStep first, DbStep second) throws OperatorOrSetupError {
        if (first.getColumns(provider).size() != second.getColumns(provider).size()) {
            throw new OperatorOrSetupError().withProcessSetupError(new ProcessSetupError[]{new SimpleProcessSetupError(ProcessSetupError.Severity.ERROR, this.getPortOwner(), "union.sets_incompatible", new Object[0])}).withUserError(new UserError((Operator)this, 925, new Object[]{"numbers of attributes are different"}));
        }
    }
}

