/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.indatabase.operator.function;

import com.rapidminer.Process;
import com.rapidminer.extension.indatabase.operator.function.SQLExpressionParser;
import com.rapidminer.tools.I18N;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.expression.Constant;
import com.rapidminer.tools.expression.ExpressionContext;
import com.rapidminer.tools.expression.ExpressionEvaluator;
import com.rapidminer.tools.expression.ExpressionParserModule;
import com.rapidminer.tools.expression.ExpressionType;
import com.rapidminer.tools.expression.Function;
import com.rapidminer.tools.expression.FunctionDescription;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;

public class DatabaseFunctionRegistry {
    private static final String FUNCTION_GUI_KEY_PREFIX = "gui.dialog.function.";
    private static final String CONSTANT_GUI_KEY_PREFIX = "gui.dialog.functionconstants.";
    private static final String KEY_SUFFIX_NAME = ".name";
    private static final String KEY_SUFFIX_RETURN_TYPE = ".returns";
    private static final String KEY_SUFFIX_GROUP = ".group";
    private static final String FUNCTION_INPUT_GUI_KEY_PREFIX = "gui.dialog.function_input.";
    private static final String KEY_SUFFIX_CONSTANT_CATEGORY = ".constant_category";
    private static Map<String, ExpressionParserModules> modulesPerDb = new HashMap<String, ExpressionParserModules>();

    private DatabaseFunctionRegistry() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ExpressionParserModule> getAllExpressionParserModules(String providerKey) {
        if (modulesPerDb.get(providerKey) == null) {
            Map<String, ExpressionParserModules> map = modulesPerDb;
            synchronized (map) {
                modulesPerDb.computeIfAbsent(providerKey, k -> ExpressionParserModules.loadFunctionsFor(k));
            }
        }
        return new ArrayList<ExpressionParserModule>(modulesPerDb.get(providerKey).getModulesPerGroup().values());
    }

    public static SQLExpressionParser getParser(Process controllingProcess, ExpressionContext context, String parameterKey, InputStream grammar) {
        return new SQLExpressionParser(controllingProcess, context, parameterKey, grammar);
    }

    private static class ExpressionParserModules {
        private Map<String, ExpressionParserModule> modulesPerGroup = new LinkedHashMap<String, ExpressionParserModule>();
        private static final UnaryOperator<String> REMOVE_SUFFIX = t -> t.replaceFirst("\\.[^.]*$", "");

        private ExpressionParserModules() {
        }

        private static ExpressionParserModules loadFunctionsFor(String dbKey) {
            LogService.getRoot().fine("Initializing functions for database " + dbKey);
            long start = System.currentTimeMillis();
            String constantKeyPrefix = DatabaseFunctionRegistry.CONSTANT_GUI_KEY_PREFIX + dbKey + ".";
            String functionKeyPrefix = DatabaseFunctionRegistry.FUNCTION_GUI_KEY_PREFIX + dbKey + ".";
            ExpressionParserModules obj = new ExpressionParserModules();
            ArrayList<String> i18nKeys = Collections.list(I18N.getGUIBundle().getKeys());
            LinkedHashMap constantsPerGroup = new LinkedHashMap();
            LinkedHashMap functionsPerGroup = new LinkedHashMap();
            i18nKeys.stream().filter(k -> k.startsWith(DatabaseFunctionRegistry.FUNCTION_INPUT_GUI_KEY_PREFIX) && k.endsWith(DatabaseFunctionRegistry.KEY_SUFFIX_CONSTANT_CATEGORY)).map(k -> k.replaceFirst(DatabaseFunctionRegistry.FUNCTION_INPUT_GUI_KEY_PREFIX, "").replaceFirst(".constant_category$", "")).distinct().forEachOrdered(g -> constantsPerGroup.put(g, new ArrayList()));
            i18nKeys.stream().filter(k -> k.startsWith(functionKeyPrefix) && k.endsWith(DatabaseFunctionRegistry.KEY_SUFFIX_GROUP)).map(k -> I18N.getGUIBundle().getString((String)k)).distinct().forEachOrdered(g -> functionsPerGroup.put(g, new ArrayList()));
            i18nKeys.stream().filter(k -> k.startsWith(constantKeyPrefix)).map(REMOVE_SUFFIX).distinct().forEachOrdered(k -> ((List)constantsPerGroup.get(REMOVE_SUFFIX.apply(k.replaceFirst(constantKeyPrefix, "")))).add(SimpleConstant.buildConstant(k)));
            i18nKeys.stream().filter(k -> k.startsWith(functionKeyPrefix)).map(REMOVE_SUFFIX).distinct().forEachOrdered(k -> ((List)functionsPerGroup.get(I18N.getGUIBundle().getString(k + DatabaseFunctionRegistry.KEY_SUFFIX_GROUP))).add(SimpleFunction.buildFunction(k)));
            constantsPerGroup.values().forEach(v -> Collections.sort(v, (c1, c2) -> c1.getName().compareTo(c2.getName())));
            functionsPerGroup.values().forEach(v -> Collections.sort(v, (o1, o2) -> o1.getFunctionName().compareTo(o2.getFunctionName())));
            LinkedHashSet groupsAndCategories = new LinkedHashSet();
            groupsAndCategories.addAll(constantsPerGroup.keySet());
            groupsAndCategories.addAll(functionsPerGroup.keySet());
            groupsAndCategories.forEach(g -> obj.modulesPerGroup.put((String)g, new ExpressionParserModule(){
                final /* synthetic */ String val$g;
                final /* synthetic */ Map val$constantsPerGroup;
                final /* synthetic */ Map val$functionsPerGroup;
                {
                    this.val$g = string;
                    this.val$constantsPerGroup = map;
                    this.val$functionsPerGroup = map2;
                }

                public String getKey() {
                    return this.val$g;
                }

                public List<Constant> getConstants() {
                    return (List)this.val$constantsPerGroup.get(this.val$g);
                }

                public List<Function> getFunctions() {
                    return (List)this.val$functionsPerGroup.get(this.val$g);
                }
            }));
            long end = System.currentTimeMillis();
            LogService.getRoot().fine(String.format("Database function list initialization for %s took %dms", dbKey, end - start));
            return obj;
        }

        public Map<String, ExpressionParserModule> getModulesPerGroup() {
            return Collections.unmodifiableMap(this.modulesPerGroup);
        }
    }

    private static class SimpleFunction
    implements Function {
        private final String key;

        private SimpleFunction(String k) {
            this.key = k;
        }

        public static SimpleFunction buildFunction(String key) {
            return new SimpleFunction(key);
        }

        public String getFunctionName() {
            return I18N.getGUIBundle().getString(this.key + DatabaseFunctionRegistry.KEY_SUFFIX_NAME);
        }

        public int getReturnType() {
            String returnType = I18N.getGUIBundle().getString(this.key + DatabaseFunctionRegistry.KEY_SUFFIX_RETURN_TYPE).toUpperCase();
            if (returnType.contains("<MISSING>")) {
                return 0;
            }
            return ExpressionType.valueOf((String)returnType).getAttributeType();
        }

        public FunctionDescription getFunctionDescription() {
            return new FunctionDescription(this.key.replaceFirst(DatabaseFunctionRegistry.FUNCTION_GUI_KEY_PREFIX, ""), -1, this.getReturnType());
        }

        public ExpressionEvaluator compute(ExpressionEvaluator ... inputEvaluators) {
            throw new UnsupportedOperationException("Database functions should not be used in this context");
        }
    }

    private static class SimpleConstant
    implements Constant {
        private final String key;

        private SimpleConstant(String k) {
            this.key = k;
        }

        public static SimpleConstant buildConstant(String key) {
            return new SimpleConstant(key);
        }

        public boolean isInvisible() {
            return false;
        }

        public ExpressionType getType() {
            return ExpressionType.valueOf((String)I18N.getGUIBundle().getString(this.key + DatabaseFunctionRegistry.KEY_SUFFIX_RETURN_TYPE).toUpperCase());
        }

        public String getStringValue() {
            return I18N.getGUIBundle().getString(this.key + DatabaseFunctionRegistry.KEY_SUFFIX_NAME);
        }

        public String getName() {
            return this.getStringValue();
        }

        public double getDoubleValue() {
            throw new UnsupportedOperationException("Not supported for database constants");
        }

        public Date getDateValue() {
            throw new UnsupportedOperationException("Not supported for database constants");
        }

        public boolean getBooleanValue() {
            throw new UnsupportedOperationException("Not supported for database constants");
        }

        public String getAnnotation() {
            return null;
        }
    }
}

