/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.indatabase.operator.function;

import com.rapidminer.Process;
import com.rapidminer.parameter.UndefinedMacroError;
import com.rapidminer.tools.expression.Expression;
import com.rapidminer.tools.expression.ExpressionContext;
import com.rapidminer.tools.expression.ExpressionException;
import com.rapidminer.tools.expression.ExpressionParser;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.BitSet;
import java.util.LinkedList;
import java.util.Scanner;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.LexerInterpreter;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.ParserInterpreter;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.atn.ATNConfigSet;
import org.antlr.v4.runtime.dfa.DFA;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.tool.Grammar;
import org.antlr.v4.tool.LexerGrammar;

public class SQLExpressionParser
implements ExpressionParser {
    private boolean USE_ANTLR_PARSER = false;
    private Process controllingProcess;
    private ExpressionContext context;
    private String parameterKey;
    private String grammarSourceCode;
    private Grammar grammar;
    private LexerGrammar lexerGrammar;

    public SQLExpressionParser(Process controllingProcess, String parameterKey, InputStream grammar) {
        this(controllingProcess, null, parameterKey, grammar);
    }

    public SQLExpressionParser(Process controllingProcess, ExpressionContext context, String parameterKey, InputStream grammar) {
        this.controllingProcess = controllingProcess;
        this.context = context;
        this.parameterKey = parameterKey;
        if (this.USE_ANTLR_PARSER) {
            this.grammarSourceCode = null;
            try (Scanner scanner = new Scanner(grammar, StandardCharsets.UTF_8.name());){
                scanner.useDelimiter("\\A");
                this.grammarSourceCode = scanner.hasNext() ? scanner.next() : "";
                try {
                    this.grammar = new Grammar(this.grammarSourceCode);
                }
                catch (org.antlr.runtime.RecognitionException e) {
                    e.printStackTrace();
                }
                try {
                    this.lexerGrammar = new LexerGrammar(this.grammarSourceCode);
                }
                catch (org.antlr.runtime.RecognitionException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected LexerGrammar getLexerGrammar() throws ExpressionException {
        if (this.lexerGrammar == null) {
            throw new ExpressionException("Parser does not have a proper grammar description. Error during parser initialization.");
        }
        return this.lexerGrammar;
    }

    public Grammar getGrammar() throws ExpressionException {
        if (this.grammar == null) {
            throw new ExpressionException("Parser does not have a proper grammar description. Error during parser initialization.");
        }
        return this.grammar;
    }

    public ParseTree getParseTree(String expression) throws ExpressionException {
        if (!this.USE_ANTLR_PARSER) {
            return null;
        }
        if (this.controllingProcess != null) {
            try {
                expression = this.controllingProcess.getMacroHandler().resolveMacros(this.parameterKey, expression);
            }
            catch (UndefinedMacroError e) {
                throw new ExpressionException(e.getMessage());
            }
        }
        try {
            ByteArrayInputStream input = new ByteArrayInputStream(expression.getBytes(StandardCharsets.UTF_8));
            LexerInterpreter lexEngine = this.getLexerGrammar().createLexerInterpreter((CharStream)new ANTLRInputStream((InputStream)input));
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexEngine);
            ParserInterpreter parser = this.getGrammar().createParserInterpreter((TokenStream)tokens);
            parser.removeErrorListeners();
            final LinkedList errors = new LinkedList();
            parser.addErrorListener(new ANTLRErrorListener(){

                public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
                    errors.add(line + ":" + charPositionInLine + " -- " + msg);
                }

                public void reportAmbiguity(Parser recognizer, DFA dfa, int startIndex, int stopIndex, boolean exact, BitSet ambigAlts, ATNConfigSet configs) {
                }

                public void reportAttemptingFullContext(Parser recognizer, DFA dfa, int startIndex, int stopIndex, BitSet conflictingAlts, ATNConfigSet configs) {
                }

                public void reportContextSensitivity(Parser recognizer, DFA dfa, int startIndex, int stopIndex, int prediction, ATNConfigSet configs) {
                }
            });
            ParserRuleContext t = parser.parse(this.getGrammar().getRule((String)"expression").index);
            if (errors.size() > 0) {
                throw new ExpressionException((String)errors.get(0));
            }
            return t;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new ExpressionException(e.toString());
        }
    }

    public Expression parse(String expression) throws ExpressionException {
        throw new UnsupportedOperationException("Database expression parsing not supported");
    }

    public Expression parse(String expression, boolean prettyErrors) throws ExpressionException {
        throw new UnsupportedOperationException("Database expression parsing not supported");
    }

    public ExpressionContext getExpressionContext() {
        return this.context;
    }

    public void checkSyntax(String expression) throws ExpressionException {
        this.getParseTree(expression);
    }

    public void checkSyntax(String expression, boolean prettyErrors) throws ExpressionException {
        this.getParseTree(expression);
    }
}

