/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.indatabase.provider;

import com.rapidminer.Process;
import com.rapidminer.ProcessStateListener;
import com.rapidminer.ProcessStoppedListener;
import com.rapidminer.extension.indatabase.provider.QueryRunner;
import com.rapidminer.operator.Operator;
import com.rapidminer.tools.LogService;
import java.sql.SQLException;
import java.util.logging.Level;

public class CancelListener
implements ProcessStoppedListener,
AutoCloseable {
    private QueryRunner queryRunner;
    private Operator operator;
    private volatile boolean cancelled = false;

    private CancelListener(QueryRunner queryRunner, Operator operator) {
        this.queryRunner = queryRunner;
        this.operator = operator;
    }

    public void stopped(Process process) {
        try {
            try {
                if (this.operator.isRunning() && !this.cancelled) {
                    this.cancelled = true;
                    this.queryRunner.cancel();
                }
            }
            catch (SQLException sqle) {
                this.cancelled = false;
                LogService.getRoot().log(Level.WARNING, "com.rapidminer.tools.jdbc.DatabaseHandler.cancel_request_error");
            }
        }
        finally {
            this.close();
        }
    }

    public static CancelListener addCancelListener(QueryRunner queryRunner, Operator operator) {
        Process process = operator.getProcess();
        if (process != null) {
            CancelListener listener = new CancelListener(queryRunner, operator);
            process.addProcessStateListener((ProcessStateListener)listener);
            return listener;
        }
        return null;
    }

    @Override
    public void close() {
        this.operator.getProcess().removeProcessStateListener((ProcessStateListener)this);
    }
}

