/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.indatabase.provider;

import com.rapidminer.extension.indatabase.provider.CancelListener;
import com.rapidminer.extension.indatabase.provider.IndbResultSet;
import com.rapidminer.extension.indatabase.provider.QueryRunner;
import com.rapidminer.operator.Operator;
import java.sql.SQLException;

public abstract class CancellableQueryRunner
implements QueryRunner {
    private final Operator operator;

    protected CancellableQueryRunner(Operator operator) {
        this.operator = operator;
    }

    @Override
    public void execute(String statement) throws SQLException, InterruptedException {
        try (CancelListener cancelListener = CancelListener.addCancelListener(this, this.operator);){
            this.doExecute(statement);
        }
    }

    public abstract void doExecute(String var1) throws SQLException, InterruptedException;

    @Override
    public IndbResultSet executeQuery(String query) throws SQLException, InterruptedException {
        try (CancelListener cancelListener = CancelListener.addCancelListener(this, this.operator);){
            IndbResultSet indbResultSet = this.doExecuteQuery(query);
            return indbResultSet;
        }
    }

    public abstract IndbResultSet doExecuteQuery(String var1) throws SQLException, InterruptedException;
}

