/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.indatabase.provider;

import com.google.api.client.util.Strings;
import com.rapidminer.example.Attribute;
import com.rapidminer.extension.indatabase.DbTools;
import com.rapidminer.extension.indatabase.db.CachedDatabaseHandler;
import com.rapidminer.extension.indatabase.db.object.Column;
import com.rapidminer.extension.indatabase.db.object.ForeignTable;
import com.rapidminer.extension.indatabase.db.object.Table;
import com.rapidminer.extension.indatabase.db.step.AbsoluteSample;
import com.rapidminer.extension.indatabase.db.step.Aggregate;
import com.rapidminer.extension.indatabase.db.step.AggregationSubquery;
import com.rapidminer.extension.indatabase.db.step.Custom;
import com.rapidminer.extension.indatabase.db.step.DbStep;
import com.rapidminer.extension.indatabase.db.step.Distinct;
import com.rapidminer.extension.indatabase.db.step.Filter;
import com.rapidminer.extension.indatabase.db.step.Join;
import com.rapidminer.extension.indatabase.db.step.ProbabilitySample;
import com.rapidminer.extension.indatabase.db.step.Sample;
import com.rapidminer.extension.indatabase.db.step.Select;
import com.rapidminer.extension.indatabase.db.step.Sort;
import com.rapidminer.extension.indatabase.db.step.Union;
import com.rapidminer.extension.indatabase.metadata.DbMetaDataTools;
import com.rapidminer.extension.indatabase.operator.Nest;
import com.rapidminer.extension.indatabase.operator.function.FunctionDefinition;
import com.rapidminer.extension.indatabase.provider.QueryRunner;
import com.rapidminer.extension.indatabase.provider.jdbc.JdbcQueryRunner;
import com.rapidminer.extension.indatabase.provider.storage.CreateTableOptions;
import com.rapidminer.extension.indatabase.provider.storage.StorageFormat;
import com.rapidminer.extension.indatabase.sql.AggregateAnsiSql;
import com.rapidminer.extension.indatabase.sql.AggregationSubqueryAnsiSql;
import com.rapidminer.extension.indatabase.sql.CustomSql;
import com.rapidminer.extension.indatabase.sql.DistinctAnsiSql;
import com.rapidminer.extension.indatabase.sql.FilterAnsiSql;
import com.rapidminer.extension.indatabase.sql.JoinAnsiSql;
import com.rapidminer.extension.indatabase.sql.SelectAnsiSql;
import com.rapidminer.extension.indatabase.sql.SortAnsiSql;
import com.rapidminer.extension.indatabase.sql.SqlSyntax;
import com.rapidminer.extension.indatabase.sql.UnionAnsiSql;
import com.rapidminer.extension.indatabase.sql.mysql.SampleMySql;
import com.rapidminer.extension.indatabase.sql.shared.AbsoluteSampleLimit;
import com.rapidminer.extension.indatabase.sql.shared.ProbabilitySampleRand;
import com.rapidminer.extension.jdbc.tools.jdbc.DatabaseHandler;
import com.rapidminer.extension.jdbc.tools.jdbc.TableName;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.Ontology;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface DatabaseProvider {
    public static final Logger LOGGER = LogService.getRoot();
    public static final String TEMPLATE_DROP = "DROP TABLE %s";
    public static final String TEMPLATE_DROP_IF_EXISTS = "DROP TABLE IF EXISTS %s";
    public static final String TEMPLATE_CTAS = "CREATE TABLE %s AS (%s)";
    public static final String TEMPLATE_IITV = "INSERT INTO %s (%s)";

    public String getId();

    public Map<String, FunctionDefinition> getAggregationFunctions();

    default public String getEnclosingCharacter() {
        return "\"";
    }

    default public String getLiteralEnclosingCharacter() {
        return "'";
    }

    default public Connection getAndCheckConnection(DatabaseHandler dbHandler) throws SQLException {
        Connection connection = dbHandler.getConnection();
        if (connection == null) {
            throw new SQLException("Could not retrieve all table names: no open connection to database '" + dbHandler.getDatabaseUrl() + "'.");
        }
        if (connection.isClosed()) {
            throw new SQLException("Could not retrieve all table names: connection is closed.");
        }
        return connection;
    }

    default public List<String> getProjectNames(CachedDatabaseHandler handler) throws SQLException {
        throw new UnsupportedOperationException();
    }

    default public List<String> getSchemaNames(CachedDatabaseHandler handler) throws SQLException {
        try (DatabaseHandler dbHandler = handler.getConnectedDatabaseHandler();){
            HashSet<String> schemas = new HashSet<String>();
            LOGGER.fine("Finding shemas");
            DatabaseMetaData metaData = this.getAndCheckConnection(dbHandler).getMetaData();
            try (ResultSet schemasRs = metaData.getSchemas();){
                while (schemasRs.next()) {
                    schemas.add(schemasRs.getString("TABLE_SCHEM"));
                }
            }
            LOGGER.fine("Done finding shemas");
            List<String> list = DbTools.sortedList(schemas);
            return list;
        }
    }

    default public List<String> getSchemaNames(CachedDatabaseHandler handler, String projectName) throws SQLException {
        throw new UnsupportedOperationException();
    }

    default public List<String> getTableNames(CachedDatabaseHandler handler, String schemaName) throws SQLException, OperatorException {
        try (DatabaseHandler dbHandler = handler.getConnectedDatabaseHandler();){
            LOGGER.fine(() -> String.format("Finding tables in schema '%s'", schemaName));
            Map allmetadata = dbHandler.getAllTableMetaData(null, 0, 0, false);
            List<String> tables = allmetadata.keySet().stream().filter(k -> schemaName.equals(k.getSchema())).map(TableName::getTableName).collect(Collectors.toList());
            LOGGER.fine(() -> String.format("Done finding tables in schema '%s'", schemaName));
            List<String> list = DbTools.sortedList(tables);
            return list;
        }
    }

    default public List<String> getTableNames(CachedDatabaseHandler handler, String projectName, String schemaName) throws SQLException, OperatorException {
        throw new UnsupportedOperationException();
    }

    default public List<Attribute> getColumnMetaData(CachedDatabaseHandler handler, String schemaName, String tableName) throws SQLException, OperatorException {
        LOGGER.fine(() -> String.format("Finding columns in table '%s'.'%s'", schemaName, tableName));
        List<Attribute> attrs = this.getColumnMetaDataImpl(handler, this.quote(schemaName) + "." + this.quote(tableName));
        LOGGER.fine(() -> String.format("Done finding columns in table '%s'.'%s'", schemaName, tableName));
        return attrs;
    }

    default public List<Attribute> getColumnMetaData(CachedDatabaseHandler handler, String projectName, String schemaName, String tableName) throws SQLException, OperatorException {
        if (!this.supportsProjects()) {
            throw new UnsupportedOperationException();
        }
        if (Strings.isNullOrEmpty((String)projectName)) {
            return this.getColumnMetaData(handler, schemaName, tableName);
        }
        LOGGER.fine(() -> String.format("Finding columns in table '%s'.'%s'.'%s'", projectName, schemaName, tableName));
        List<Attribute> attrs = this.getColumnMetaDataImpl(handler, this.quote(projectName) + "." + this.quote(schemaName) + "." + this.quote(tableName));
        LOGGER.fine(() -> String.format("Done finding columns in table '%s'.'%s'.'%s'", projectName, schemaName, tableName));
        return attrs;
    }

    /*
     * Exception decompiling
     */
    default public List<String[]> getColumnMetaData(CachedDatabaseHandler handler, String query) throws SQLException, OperatorException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    default public List<Attribute> getColumnMetaDataImpl(CachedDatabaseHandler handler, String from) throws SQLException, OperatorException {
        String sqlQuery = String.format("SELECT * FROM %s LIMIT 0", from);
        ArrayList<Attribute> attrs = new ArrayList<Attribute>();
        try (QueryRunner qR = this.createQueryRunner(handler);){
            qR.executeQuery(sqlQuery).createExampleTable(null).build().getAttributes().allAttributes().forEachRemaining(attrs::add);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return attrs;
    }

    default public InputStream getGrammarStream() {
        LOGGER.finer("Using grammar file that accepts every input (no syntax check).");
        return this.getClass().getClassLoader().getResourceAsStream("com/rapidminer/extension/resources/grammars/accept_everything_as_attribute_value.g4");
    }

    default public Map<Class<? extends DbStep>, SqlSyntax<?>> getDbStepToSyntaxMap() {
        HashMap res = new HashMap();
        res.put(Select.class, new SelectAnsiSql());
        res.put(Aggregate.class, new AggregateAnsiSql());
        res.put(Distinct.class, new DistinctAnsiSql());
        res.put(AggregationSubquery.class, new AggregationSubqueryAnsiSql());
        res.put(Filter.class, new FilterAnsiSql());
        res.put(Join.class, new JoinAnsiSql());
        res.put(Sample.class, new SampleMySql());
        res.put(Sort.class, new SortAnsiSql());
        res.put(Union.class, new UnionAnsiSql());
        res.put(Custom.class, new CustomSql());
        res.put(AbsoluteSample.class, new AbsoluteSampleLimit());
        res.put(ProbabilitySample.class, new ProbabilitySampleRand());
        return res;
    }

    default public <T extends DbStep> String generateSql(T dbStep) {
        SqlSyntax<?> impl = this.getDbStepToSyntaxMap().get(dbStep.getClass());
        if (impl == null) {
            throw new UnsupportedOperationException(String.format("Missing implementation for '%s' in dialect '%s'", dbStep.getClass().getSimpleName(), this.getId()));
        }
        return impl.toSql(this, dbStep);
    }

    default public String quote(String str) {
        return String.format("%s%s%s", this.getEnclosingCharacter(), str, this.getEnclosingCharacter());
    }

    default public String literal(String val) {
        return String.format("%s%s%s", this.getLiteralEnclosingCharacter(), this.escapeLiteral(val), this.getLiteralEnclosingCharacter());
    }

    default public boolean isLiteral(String val) {
        return val != null && val.startsWith(this.getLiteralEnclosingCharacter()) && val.endsWith(this.getLiteralEnclosingCharacter());
    }

    default public String escapeLiteral(String val) {
        String enclosingChar = this.getLiteralEnclosingCharacter();
        return val.replace(enclosingChar, enclosingChar + enclosingChar);
    }

    default public String escapeLikeExpr(String str) {
        return str.replace("%", "\\%").replace("_", "\\_");
    }

    default public boolean supportsInfinity() {
        return true;
    }

    default public String escapeInfinity(String val) {
        if (String.valueOf(Double.POSITIVE_INFINITY).equals(val)) {
            return this.literal(val);
        }
        if (String.valueOf(Double.NEGATIVE_INFINITY).equals(val)) {
            return "-" + this.literal(String.valueOf(Double.POSITIVE_INFINITY));
        }
        return val;
    }

    default public String format(String val, Column c) {
        int type;
        if (!this.isLiteral(val) && Ontology.ATTRIBUTE_VALUE_TYPE.isA(type = DbMetaDataTools.getRapidMinerTypeIndex(c.getType()), 9)) {
            return this.literal(DbTools.defaultFormat(val, type));
        }
        return val;
    }

    default public String generateFirstNonNullExpr(String ... arg) {
        return String.format("COALESCE(%s)", String.join((CharSequence)", ", arg));
    }

    default public boolean supportsRegexpInReplace() {
        return true;
    }

    default public String generateReplaceExpr(String column, String replaceWhat, String replaceBy) {
        return String.format("REGEXP_REPLACE(%s, %s, %s)", this.quote(column), this.literal(replaceWhat), this.literal(replaceBy));
    }

    default public Map<String, Integer> getDataTypeSuggestions() {
        return Collections.emptyMap();
    }

    default public Map<Filter.FilterCondition, BiFunction<String, String, String>> getFilterSyntax() {
        EnumMap<Filter.FilterCondition, BiFunction<String, String, String>> res = new EnumMap<Filter.FilterCondition, BiFunction<String, String, String>>(Filter.FilterCondition.class);
        res.put(Filter.FilterCondition.EQUALS, (col, val) -> col + "=" + this.literal((String)val));
        res.put(Filter.FilterCondition.DOES_NOT_EQUAL, (col, val) -> col + "!=" + this.literal((String)val));
        res.put(Filter.FilterCondition.IS_IN, (col, val) -> col + " IN (" + Stream.of(val.split(";")).map(this::literal).collect(Collectors.joining(", ")) + ")");
        res.put(Filter.FilterCondition.IS_NOT_IN, (col, val) -> col + " NOT IN (" + Stream.of(val.split(";")).map(this::literal).collect(Collectors.joining(", ")) + ")");
        res.put(Filter.FilterCondition.CONTAINS, (col, val) -> col + " LIKE " + this.literal("%" + this.escapeLikeExpr((String)val) + "%"));
        res.put(Filter.FilterCondition.DOES_NOT_CONTAIN, (col, val) -> col + " NOT LIKE " + this.literal("%" + this.escapeLikeExpr((String)val) + "%"));
        res.put(Filter.FilterCondition.STARTS_WITH, (col, val) -> col + " LIKE " + this.literal(this.escapeLikeExpr((String)val) + "%"));
        res.put(Filter.FilterCondition.ENDS_WITH, (col, val) -> col + " LIKE " + this.literal("%" + this.escapeLikeExpr((String)val)));
        res.put(Filter.FilterCondition.MATCHES, (col, val) -> col + " REGEXP " + this.literal((String)val));
        res.put(Filter.FilterCondition.IS_MISSING, (col, val) -> col + " IS NULL");
        res.put(Filter.FilterCondition.IS_NOT_MISSING, (col, val) -> col + " IS NOT NULL");
        res.put(Filter.FilterCondition.EQ, (col, val) -> col + "=" + this.escapeInfinity((String)val));
        res.put(Filter.FilterCondition.NE, (col, val) -> col + "<>" + this.escapeInfinity((String)val));
        res.put(Filter.FilterCondition.LT, (col, val) -> col + "<" + this.escapeInfinity((String)val));
        res.put(Filter.FilterCondition.LE, (col, val) -> col + "<=" + this.escapeInfinity((String)val));
        res.put(Filter.FilterCondition.GT, (col, val) -> col + ">" + this.escapeInfinity((String)val));
        res.put(Filter.FilterCondition.GE, (col, val) -> col + ">=" + this.escapeInfinity((String)val));
        return res;
    }

    default public boolean supportsDropIfExistsSyntax() {
        return true;
    }

    default public void dropIfExists(Nest nest, QueryRunner queryRunner, Table table) throws SQLException, InterruptedException, OperatorException {
        if (table instanceof ForeignTable) {
            throw new UnsupportedOperationException("Tables in other projects cannot be dropped");
        }
        String qualifiedTargetName = table.toSql(this);
        if (this.supportsDropIfExistsSyntax()) {
            String dropSql = String.format(TEMPLATE_DROP_IF_EXISTS, qualifiedTargetName);
            queryRunner.execute(dropSql);
        } else if (nest.getDbHandler().tableExists(table.getSchema(), table.getTable(), true)) {
            String dropSql = String.format(TEMPLATE_DROP, qualifiedTargetName);
            queryRunner.execute(dropSql);
        }
    }

    default public String generateCreateTableSql(Table table, DbStep dbStep) {
        return String.format(TEMPLATE_CTAS, table.toSql(this), dbStep.toSql(this));
    }

    default public String generateCreateTableSql(Table table, DbStep dbStep, CreateTableOptions options) {
        if (options == null || options.isDefault()) {
            return this.generateCreateTableSql(table, dbStep);
        }
        throw new UnsupportedOperationException("Custom create table options are not yet supported by " + this.getId());
    }

    default public String insertIntoTableSql(Table table, DbStep dbStep) {
        return String.format(TEMPLATE_IITV, table.toSql(this), dbStep.toSql(this));
    }

    default public QueryRunner createQueryRunner(CachedDatabaseHandler handler) throws SQLException {
        return new JdbcQueryRunner(handler);
    }

    default public boolean supportsProjects() {
        return false;
    }

    default public boolean supportsRandomSeed() {
        return false;
    }

    default public List<ParameterType> getParameterTypes() {
        return new ArrayList<ParameterType>();
    }

    default public int getRankFunctionReturnType() {
        return 4;
    }

    default public boolean isCustomFormatEnabled() {
        return false;
    }

    default public List<StorageFormat> getSupportedStorageFormats() {
        return Arrays.asList(StorageFormat.DEFAULT);
    }
}

