/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.indatabase.provider;

import com.rapidminer.connection.ConnectionInformation;
import com.rapidminer.extension.indatabase.provider.DatabaseProvider;
import com.rapidminer.extension.indatabase.provider.bigquery.GoogleBigQueryProvider;
import com.rapidminer.extension.jdbc.connection.JDBCConnectionHandler;
import com.rapidminer.tools.LogService;
import java.lang.invoke.LambdaMetafactory;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class DatabaseProviderFactory {
    private static Map<String, DatabaseProviderDescriptor> providers = new HashMap<String, DatabaseProviderDescriptor>();

    private DatabaseProviderFactory() {
    }

    public static void registerProvider(DatabaseProviderDescriptor desc) {
        if (providers.containsKey(desc.provider.getId())) {
            throw new IllegalArgumentException("Database provider with id '" + desc.provider.getId() + "' is already registered.");
        }
        providers.put(desc.provider.getId(), desc);
        LogService.getRoot().info("Registered database provider: " + desc.getProvider().getClass().getSimpleName());
        providers.put(desc.provider.getId(), desc);
    }

    public static DatabaseProvider getProvider(String id) {
        DatabaseProviderDescriptor res = providers.get(id);
        if (res == null) {
            throw new UnknownSqlDialect("Unkown database provider id: " + id);
        }
        return res.provider;
    }

    public static DatabaseProvider detectProvider(ConnectionInformation connectionInformation) {
        if (!connectionInformation.getConfiguration().getType().equals(JDBCConnectionHandler.INSTANCE.getType())) {
            return GoogleBigQueryProvider.INSTANCE;
        }
        String dbSystem = connectionInformation.getConfiguration().getValue("jdbc_driver.urlprefix");
        if (dbSystem == null || !dbSystem.startsWith("jdbc:")) {
            throw new UnknownSqlDialect(String.format("Cannot determine the database type, JDBC URL value is \"%s\".", dbSystem));
        }
        LogService.getRoot().finest(() -> String.format("DB Type is: %s", dbSystem));
        return Stream.of(DatabaseProviderFactory.getOrderedProviderIdList()).map((Function<String, DatabaseProviderDescriptor>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$detectProvider$1(java.lang.String ), (Ljava/lang/String;)Lcom/rapidminer/extension/indatabase/provider/DatabaseProviderFactory$DatabaseProviderDescriptor;)()).filter((Predicate<DatabaseProviderDescriptor>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$detectProvider$2(java.lang.String com.rapidminer.extension.indatabase.provider.DatabaseProviderFactory$DatabaseProviderDescriptor ), (Lcom/rapidminer/extension/indatabase/provider/DatabaseProviderFactory$DatabaseProviderDescriptor;)Z)((String)dbSystem)).findFirst().orElseThrow((Supplier<UnknownSqlDialect>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$detectProvider$3(java.lang.String ), ()Lcom/rapidminer/extension/indatabase/provider/DatabaseProviderFactory$UnknownSqlDialect;)((String)dbSystem)).provider;
    }

    public static String[] getOrderedProviderIdList() {
        return (String[])providers.values().stream().sorted().map(desc -> desc.provider.getId()).toArray(String[]::new);
    }

    private static /* synthetic */ UnknownSqlDialect lambda$detectProvider$3(String dbSystem) {
        return new UnknownSqlDialect(String.format("Could not find any database provider for URL \"%s\"", dbSystem));
    }

    private static /* synthetic */ boolean lambda$detectProvider$2(String dbSystem, DatabaseProviderDescriptor p) {
        return p.jdbcUrlPrefixes.stream().anyMatch(dbSystem::startsWith);
    }

    private static /* synthetic */ DatabaseProviderDescriptor lambda$detectProvider$1(String id) {
        return providers.get(id);
    }

    public static final class DatabaseProviderDescriptor
    implements Comparable<DatabaseProviderDescriptor> {
        private final DatabaseProvider provider;
        private final int rank;
        private final Set<String> jdbcUrlPrefixes;

        @Override
        public int compareTo(DatabaseProviderDescriptor o) {
            return Integer.compare(this.rank, o.rank);
        }

        public DatabaseProviderDescriptor(DatabaseProvider provider, int rank, String ... jdbcUrlPrefixes) {
            if (rank < 0 || rank > 100) {
                throw new IllegalArgumentException("Rank must be between 0 and 100.");
            }
            this.provider = provider;
            this.rank = rank;
            this.jdbcUrlPrefixes = new LinkedHashSet<String>(Arrays.asList(jdbcUrlPrefixes));
        }

        public DatabaseProvider getProvider() {
            return this.provider;
        }

        public int getRank() {
            return this.rank;
        }

        public Set<String> getJdbcUrlPrefixes() {
            return this.jdbcUrlPrefixes;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DatabaseProviderDescriptor)) {
                return false;
            }
            DatabaseProviderDescriptor other = (DatabaseProviderDescriptor)o;
            if (this.getRank() != other.getRank()) {
                return false;
            }
            DatabaseProvider this$provider = this.getProvider();
            DatabaseProvider other$provider = other.getProvider();
            if (this$provider == null ? other$provider != null : !this$provider.equals(other$provider)) {
                return false;
            }
            Set<String> this$jdbcUrlPrefixes = this.getJdbcUrlPrefixes();
            Set<String> other$jdbcUrlPrefixes = other.getJdbcUrlPrefixes();
            return !(this$jdbcUrlPrefixes == null ? other$jdbcUrlPrefixes != null : !((Object)this$jdbcUrlPrefixes).equals(other$jdbcUrlPrefixes));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getRank();
            DatabaseProvider $provider = this.getProvider();
            result = result * 59 + ($provider == null ? 43 : $provider.hashCode());
            Set<String> $jdbcUrlPrefixes = this.getJdbcUrlPrefixes();
            result = result * 59 + ($jdbcUrlPrefixes == null ? 43 : ((Object)$jdbcUrlPrefixes).hashCode());
            return result;
        }

        public String toString() {
            return "DatabaseProviderFactory.DatabaseProviderDescriptor(provider=" + String.valueOf(this.getProvider()) + ", rank=" + this.getRank() + ", jdbcUrlPrefixes=" + String.valueOf(this.getJdbcUrlPrefixes()) + ")";
        }
    }

    public static class UnknownSqlDialect
    extends RuntimeException {
        private static final long serialVersionUID = 9071608049222293145L;

        public UnknownSqlDialect(String message) {
            super(message);
        }

        public UnknownSqlDialect(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

